/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.spi.testing.coverage.Coverage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PhpFileCoverageDetails
implements FileCoverageDetails {
    private final FileObject fo;
    private final Coverage.File file;
    private final long generated;

    public PhpFileCoverageDetails(FileObject fo, Coverage.File file) {
        assert (fo != null);
        assert (file != null);
        this.fo = fo;
        this.file = file;
        this.generated = FileUtil.toFile((FileObject)fo).lastModified();
    }

    public FileObject getFile() {
        return this.fo;
    }

    public int getLineCount() {
        return this.file.getMetrics().getLineCount();
    }

    public boolean hasHitCounts() {
        return true;
    }

    public long lastUpdated() {
        return this.generated;
    }

    public FileCoverageSummary getSummary() {
        return PhpCoverageProvider.getFileCoverageSummary(this.file);
    }

    public CoverageType getType(int lineNo) {
        ++lineNo;
        for (Coverage.Line line : this.file.getLines()) {
            if (line.getNumber() != lineNo) continue;
            if (line.getHitCount() > 0) {
                return CoverageType.COVERED;
            }
            return CoverageType.NOT_COVERED;
        }
        return CoverageType.UNKNOWN;
    }

    public int getHitCount(int lineNo) {
        ++lineNo;
        for (Coverage.Line line : this.file.getLines()) {
            if (line.getNumber() != lineNo) continue;
            return line.getHitCount();
        }
        return 0;
    }
}

