/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.singlesourcefile;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

public class CompilerOptionsQueryImpl
implements CompilerOptionsQueryImplementation,
ClassPathProvider,
SourceLevelQueryImplementation2 {
    private final Map<NbCodeLanguageClient, Configuration> file2Configuration = new WeakHashMap<NbCodeLanguageClient, Configuration>();

    public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
        NbCodeLanguageClient client;
        if (CompilerOptionsQueryImpl.isSingleSourceFile(file) && (client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class)) != null) {
            return this.getConfiguration((NbCodeLanguageClient)client).compilerOptions;
        }
        return null;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        NbCodeLanguageClient client;
        if (CompilerOptionsQueryImpl.isSingleSourceFile(file) && (client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class)) != null) {
            switch (type) {
                case "classpath/compile": 
                case "modules/classpath": {
                    return this.getConfiguration((NbCodeLanguageClient)client).compileClassPath;
                }
                case "modules/compile": {
                    return this.getConfiguration((NbCodeLanguageClient)client).moduleCompileClassPath;
                }
            }
        }
        return null;
    }

    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject file) {
        NbCodeLanguageClient client;
        if (CompilerOptionsQueryImpl.isSingleSourceFile(file) && (client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class)) != null) {
            return this.getConfiguration((NbCodeLanguageClient)client).sourceLevelResult;
        }
        return null;
    }

    public boolean setConfiguration(NbCodeLanguageClient client, String vmOptions) {
        return this.getConfiguration(client).setConfiguration(vmOptions);
    }

    private synchronized Configuration getConfiguration(NbCodeLanguageClient client) {
        return this.file2Configuration.computeIfAbsent(client, cl -> new Configuration());
    }

    static boolean isSingleSourceFile(FileObject fObj) {
        Project p = FileOwnerQuery.getOwner((FileObject)fObj);
        return p == null && fObj.getExt().equalsIgnoreCase("java");
    }

    private static final class ProxyClassPathImplementation
    implements ClassPathImplementation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private List<ClassPathImplementation> delegates = Collections.emptyList();
        private List<? extends PathResourceImplementation> cachedResources = null;

        private ProxyClassPathImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDelegates(List<ClassPathImplementation> delegates) {
            List<ClassPathImplementation> list = delegates;
            synchronized (list) {
                this.delegates = new ArrayList<ClassPathImplementation>(delegates);
                this.cachedResources = null;
            }
            this.pcs.firePropertyChange("resources", null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            List<ClassPathImplementation> delegates;
            ProxyClassPathImplementation proxyClassPathImplementation = this;
            synchronized (proxyClassPathImplementation) {
                if (this.cachedResources != null) {
                    return this.cachedResources;
                }
                delegates = this.delegates;
            }
            List allResources = new ArrayList();
            delegates.stream().map(d -> d.getResources()).forEach(allResources::addAll);
            allResources = Collections.unmodifiableList(allResources);
            ProxyClassPathImplementation proxyClassPathImplementation2 = this;
            synchronized (proxyClassPathImplementation2) {
                if (this.cachedResources == null && this.delegates == delegates) {
                    this.cachedResources = allResources;
                }
            }
            return allResources;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private static final class Configuration {
        private List<String> currentOptions = Collections.emptyList();
        public final OptionsResultImpl compilerOptions = new OptionsResultImpl();
        public final SourceLevelResultImpl sourceLevelResult = new SourceLevelResultImpl();
        public final ProxyClassPathImplementation compileClassPathImplementation = new ProxyClassPathImplementation();
        public final ProxyClassPathImplementation compileModulePathImplementation = new ProxyClassPathImplementation();
        public final ClassPath compileClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)this.compileClassPathImplementation);
        public final ClassPath moduleCompileClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)this.compileModulePathImplementation);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setConfiguration(String vmOptions) {
            List<String> newOptions = this.compilerOptions.doParse(vmOptions);
            Configuration configuration = this;
            synchronized (configuration) {
                if (this.currentOptions.equals(newOptions)) {
                    return false;
                }
                this.currentOptions = newOptions;
            }
            this.compilerOptions.setArguments(newOptions);
            String classpath = "";
            String modulepath = "";
            String sourceLevel = SourceLevelResultImpl.DEFAULT_SL;
            block16: for (int i = 0; i < newOptions.size() - 1; ++i) {
                String parameter = newOptions.get(i + 1);
                switch (newOptions.get(i)) {
                    case "-classpath": 
                    case "-cp": 
                    case "--class-path": {
                        classpath = parameter;
                        continue block16;
                    }
                    case "--module-path": 
                    case "-p": {
                        modulepath = parameter;
                        continue block16;
                    }
                    case "--source": {
                        sourceLevel = parameter;
                    }
                }
            }
            this.compileClassPathImplementation.setDelegates(this.spec2CP(classpath));
            this.compileModulePathImplementation.setDelegates(this.spec2CP(modulepath));
            this.sourceLevelResult.setSourceLevel(sourceLevel);
            return true;
        }

        private List<ClassPathImplementation> spec2CP(String spec) {
            List entries = spec.isEmpty() ? Collections.emptyList() : ClassPathSupport.createClassPath((String)spec).entries().stream().map(e -> e.getURL()).map(ClassPathSupport::createResource).collect(Collectors.toList());
            return Arrays.asList(ClassPathSupport.createClassPathImplementation(entries));
        }
    }

    private static final class SourceLevelResultImpl
    implements SourceLevelQueryImplementation2.Result {
        private static final String DEFAULT_SL = String.valueOf(SourceVersion.latest().ordinal() - SourceVersion.RELEASE_0.ordinal());
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private String sourceLevel = DEFAULT_SL;

        private SourceLevelResultImpl() {
        }

        public synchronized String getSourceLevel() {
            return this.sourceLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSourceLevel(String sourceLevel) {
            SourceLevelResultImpl sourceLevelResultImpl = this;
            synchronized (sourceLevelResultImpl) {
                this.sourceLevel = sourceLevel;
            }
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }
    }

    private static final class OptionsResultImpl
    extends CompilerOptionsQueryImplementation.Result {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private List<String> args = Collections.emptyList();

        private OptionsResultImpl() {
        }

        public List<String> doParse(String line) {
            return this.parseLine(line);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setArguments(List<String> newArguments) {
            OptionsResultImpl optionsResultImpl = this;
            synchronized (optionsResultImpl) {
                this.args = newArguments;
            }
            this.cs.fireChange();
        }

        public synchronized List<? extends String> getArguments() {
            return this.args;
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }
    }
}

