/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;

public interface FormPropertyContext {
    public boolean useMultipleEditors();

    public void initPropertyEditor(PropertyEditor var1, FormProperty var2);

    public FormModel getFormModel();

    public Object getOwner();

    public static class EmptyImpl
    implements FormPropertyContext {
        private static EmptyImpl theInstance = null;

        @Override
        public boolean useMultipleEditors() {
            return false;
        }

        @Override
        public void initPropertyEditor(PropertyEditor prEd, FormProperty property) {
            if (prEd instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)prEd)).setContext(this.getFormModel(), property);
            }
        }

        @Override
        public FormModel getFormModel() {
            return null;
        }

        @Override
        public Object getOwner() {
            return null;
        }

        public static EmptyImpl getInstance() {
            if (theInstance == null) {
                theInstance = new EmptyImpl();
            }
            return theInstance;
        }
    }

    public static class SubProperty
    implements FormPropertyContext {
        private FormProperty parentProperty;

        public SubProperty(FormProperty parentProp) {
            this.parentProperty = parentProp;
        }

        @Override
        public boolean useMultipleEditors() {
            return this.parentProperty.getPropertyContext().useMultipleEditors();
        }

        @Override
        public void initPropertyEditor(PropertyEditor prEd, FormProperty property) {
            this.parentProperty.getPropertyContext().initPropertyEditor(prEd, property);
        }

        @Override
        public FormModel getFormModel() {
            return this.parentProperty.getPropertyContext().getFormModel();
        }

        @Override
        public Object getOwner() {
            return this.parentProperty;
        }
    }

    public static class Component
    implements FormPropertyContext {
        private RADComponent component;

        public Component(RADComponent metacomp) {
            this.component = metacomp;
        }

        @Override
        public boolean useMultipleEditors() {
            return true;
        }

        @Override
        public void initPropertyEditor(PropertyEditor prEd, FormProperty property) {
            if (prEd instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)prEd)).setContext(this.getFormModel(), property);
            }
        }

        @Override
        public FormModel getFormModel() {
            return this.component.getFormModel();
        }

        @Override
        public RADComponent getOwner() {
            return this.component;
        }
    }
}

