/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.friendapi.OverrideErrorMessage;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class SerialVersionUID
implements ErrorRule<Void>,
OverrideErrorMessage<Void> {
    public static final Set<String> CODES = Collections.singleton("compiler.warn.missing.SVUID");
    private static final String SERIAL = "serial";
    private static final String SVUID = "serialVersionUID";
    private final AtomicBoolean cancel = new AtomicBoolean();

    public Set<Tree.Kind> getTreeKinds() {
        return TreeUtilities.CLASS_TREE_KINDS;
    }

    public Set<String> getCodes() {
        return CODES;
    }

    @Override
    public String createMessage(CompilationInfo info, Diagnostic d, int offset, TreePath treePath, ErrorRule.Data data) {
        if (treePath == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.INTERFACE) {
            return "";
        }
        return null;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (treePath == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.INTERFACE) {
            return null;
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(treePath);
        if (type == null) {
            return null;
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)info), false).toEditorFix());
        if (type.getNestingKind() != NestingKind.ANONYMOUS) {
            fixes.addAll(FixFactory.createSuppressWarnings((CompilationInfo)info, (TreePath)treePath, (String[])new String[]{SERIAL}));
        }
        return fixes;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"DN_SerialVersionUID");
    }

    public void cancel() {
        this.cancel.set(true);
    }

    private static class FixImpl
    extends JavaFix {
        private final TreePathHandle handle;
        private final boolean generated;

        public FixImpl(TreePathHandle handle, boolean generated) {
            super(handle);
            this.handle = handle;
            this.generated = generated;
            if (generated) {
                throw new UnsupportedOperationException("TODO: implement");
            }
        }

        protected String getText() {
            if (this.generated) {
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_SerialVersionUID_Generated");
            }
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_SerialVersionUID");
        }

        protected void performRewrite(@NonNull JavaFix.TransformationContext ctx) throws Exception {
            TreePath treePath = ctx.getPath();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
            VariableTree svuid = make.Variable(make.Modifiers(modifiers), (CharSequence)SerialVersionUID.SVUID, (Tree)make.Identifier((CharSequence)"long"), (ExpressionTree)make.Literal((Object)1L));
            ClassTree decl = GeneratorUtilities.get((WorkingCopy)ctx.getWorkingCopy()).insertClassMember(classTree, (Tree)svuid);
            ctx.getWorkingCopy().rewrite((Tree)classTree, (Tree)decl);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            FixImpl other = (FixImpl)((Object)obj);
            if (!(this.handle == other.handle || this.handle != null && this.handle.equals((Object)other.handle))) {
                return false;
            }
            return this.generated == other.generated;
        }

        public int hashCode() {
            int hash = 5;
            hash = 41 * hash + (this.handle != null ? this.handle.hashCode() : 0);
            hash = 41 * hash + (this.generated ? 1 : 0);
            return hash;
        }
    }
}

