/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UserMappingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CachedInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestV2ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientCertificateUrlExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptThenMacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedMasterSecretExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.HeartbeatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.MaxFragmentLengthExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PaddingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SRPExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerAuthzExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerCertificateTypeExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SessionTicketTLSExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignedCertificateTimestampExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TruncatedHmacExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TrustedCaIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ServerHelloMessage
extends HelloMessage {
    private static final byte[] HELLO_RETRY_REQUEST_RANDOM = new byte[]{-49, 33, -83, 116, -27, -102, 97, 17, -66, 29, -116, 2, 30, 101, -72, -111, -62, -94, 17, 22, 122, -69, -116, 94, 7, -98, 9, -30, -56, -88, 51, -100};
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray selectedCipherSuite;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByte selectedCompressionMethod;

    public ServerHelloMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.SERVER_HELLO);
        if (!tlsConfig.getHighestProtocolVersion().isSSL() || tlsConfig.getHighestProtocolVersion().isSSL() && tlsConfig.isAddExtensionsInSSL().booleanValue()) {
            if (tlsConfig.isAddHeartbeatExtension().booleanValue()) {
                this.addExtension(new HeartbeatExtensionMessage());
            }
            if (tlsConfig.isAddECPointFormatExtension().booleanValue() && !tlsConfig.getHighestProtocolVersion().isTLS13()) {
                this.addExtension(new ECPointFormatExtensionMessage());
            }
            if (tlsConfig.isAddMaxFragmentLengthExtension()) {
                this.addExtension(new MaxFragmentLengthExtensionMessage());
            }
            if (tlsConfig.isAddServerNameIndicationExtension().booleanValue()) {
                ServerNameIndicationExtensionMessage extension = new ServerNameIndicationExtensionMessage();
                ServerNamePair pair = new ServerNamePair();
                pair.setServerNameConfig(tlsConfig.getDefaultServerConnection().getHostname().getBytes(Charset.forName("US-ASCII")));
                extension.getServerNameList().add(pair);
                this.addExtension(extension);
            }
            if (tlsConfig.isAddKeyShareExtension().booleanValue()) {
                this.addExtension(new KeyShareExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddEncryptedServerNameIndicationExtension().booleanValue()) {
                this.addExtension(new EncryptedServerNameIndicationExtensionMessage());
            }
            if (tlsConfig.isAddExtendedMasterSecretExtension().booleanValue()) {
                this.addExtension(new ExtendedMasterSecretExtensionMessage());
            }
            if (tlsConfig.isAddSessionTicketTLSExtension().booleanValue()) {
                this.addExtension(new SessionTicketTLSExtensionMessage());
            }
            if (tlsConfig.isAddSignedCertificateTimestampExtension().booleanValue()) {
                this.addExtension(new SignedCertificateTimestampExtensionMessage());
            }
            if (tlsConfig.isAddPaddingExtension().booleanValue()) {
                this.addExtension(new PaddingExtensionMessage());
            }
            if (tlsConfig.isAddRenegotiationInfoExtension().booleanValue()) {
                this.addExtension(new RenegotiationInfoExtensionMessage());
            }
            if (tlsConfig.isAddTokenBindingExtension().booleanValue()) {
                this.addExtension(new TokenBindingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestExtension().booleanValue()) {
                this.addExtension(new CertificateStatusRequestExtensionMessage());
            }
            if (tlsConfig.isAddAlpnExtension().booleanValue()) {
                this.addExtension(new AlpnExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddSRPExtension().booleanValue()) {
                this.addExtension(new SRPExtensionMessage());
            }
            if (tlsConfig.isAddSRTPExtension().booleanValue()) {
                this.addExtension(new SrtpExtensionMessage());
            }
            if (tlsConfig.isAddTruncatedHmacExtension().booleanValue()) {
                this.addExtension(new TruncatedHmacExtensionMessage());
            }
            if (tlsConfig.isAddUserMappingExtension().booleanValue()) {
                this.addExtension(new UserMappingExtensionMessage());
            }
            if (tlsConfig.isAddCertificateTypeExtension().booleanValue()) {
                this.addExtension(new CertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddClientAuthzExtension().booleanValue()) {
                this.addExtension(new ClientAuthzExtensionMessage());
            }
            if (tlsConfig.isAddServerAuthzExtension().booleanValue()) {
                this.addExtension(new ServerAuthzExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateTypeExtension().booleanValue()) {
                this.addExtension(new ClientCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddServerCertificateTypeExtension().booleanValue()) {
                this.addExtension(new ServerCertificateTypeExtensionMessage());
            }
            if (tlsConfig.isAddEncryptThenMacExtension().booleanValue()) {
                this.addExtension(new EncryptThenMacExtensionMessage());
            }
            if (tlsConfig.isAddCachedInfoExtension().booleanValue()) {
                this.addExtension(new CachedInfoExtensionMessage());
            }
            if (tlsConfig.isAddClientCertificateUrlExtension().booleanValue()) {
                this.addExtension(new ClientCertificateUrlExtensionMessage());
            }
            if (tlsConfig.isAddTrustedCaIndicationExtension().booleanValue()) {
                this.addExtension(new TrustedCaIndicationExtensionMessage());
            }
            if (tlsConfig.isAddCertificateStatusRequestV2Extension().booleanValue()) {
                this.addExtension(new CertificateStatusRequestV2ExtensionMessage());
            }
            if (tlsConfig.isAddPreSharedKeyExtension().booleanValue()) {
                this.addExtension(new PreSharedKeyExtensionMessage(tlsConfig));
            }
            if (tlsConfig.isAddSupportedVersionsExtension().booleanValue()) {
                this.addExtension(new SupportedVersionsExtensionMessage());
            }
            if (tlsConfig.isAddExtendedRandomExtension()) {
                this.addExtension(new ExtendedRandomExtensionMessage());
            }
        }
    }

    public ServerHelloMessage() {
        super(HandshakeMessageType.SERVER_HELLO);
    }

    public ModifiableByteArray getSelectedCipherSuite() {
        return this.selectedCipherSuite;
    }

    public void setSelectedCipherSuite(ModifiableByteArray selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void setSelectedCipherSuite(byte[] value) {
        this.selectedCipherSuite = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.selectedCipherSuite, (byte[])value);
    }

    public ModifiableByte getSelectedCompressionMethod() {
        return this.selectedCompressionMethod;
    }

    public void setSelectedCompressionMethod(ModifiableByte selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public void setSelectedCompressionMethod(byte value) {
        this.selectedCompressionMethod = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.selectedCompressionMethod, (Byte)value);
    }

    public Boolean isTls13HelloRetryRequest() {
        if (this.getRandom() != null && this.getRandom().getValue() != null) {
            return Arrays.equals((byte[])this.getRandom().getValue(), HELLO_RETRY_REQUEST_RANDOM);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null && !ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).isTLS13()) {
            sb.append("\n  Server Unix Time: ").append(new Date(ArrayConverter.bytesToLong((byte[])((byte[])this.getUnixTime().getValue())) * 1000L));
        }
        sb.append("\n  Server Unix Time: ");
        if (this.getProtocolVersion() != null) {
            if (!ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).isTLS13()) {
                sb.append(new Date(ArrayConverter.bytesToLong((byte[])((byte[])this.getUnixTime().getValue())) * 1000L));
            } else {
                sb.append("null");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Server Random: ");
        if (this.getRandom() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getRandom().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Session ID: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            if (!ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).isTLS13()) {
                sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSessionId().getValue())));
            } else {
                sb.append("null");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Selected Cipher Suite: ");
        if (this.selectedCipherSuite != null && this.selectedCipherSuite.getValue() != null) {
            sb.append((Object)CipherSuite.getCipherSuite((byte[])this.selectedCipherSuite.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Selected Compression Method: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            if (!ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()).isTLS13()) {
                sb.append((Object)CompressionMethod.getCompressionMethod((Byte)this.selectedCompressionMethod.getValue()));
            } else {
                sb.append("null");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Extensions: ");
        if (this.getExtensions() == null) {
            sb.append("null");
        } else {
            for (ExtensionMessage e : this.getExtensions()) {
                sb.append(e.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new ServerHelloHandler(context);
    }
}

