/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.pentaho.di.core.logging.Log4jStringAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.WebResult;

public class GetJobStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/jobStatus";
    private static LogWriter log = LogWriter.getInstance();
    private JobMap jobMap;

    public GetJobStatusServlet(JobMap jobMap) {
        this.jobMap = jobMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContextPath().equals(CONTEXT_PATH)) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("GetJobStatusServlet.Log.JobStatusRequested"), new Object[0]);
        }
        String jobName = request.getParameter("name");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html");
        }
        PrintWriter out = response.getWriter();
        Job job = this.jobMap.getJob(jobName);
        if (job != null) {
            String status = job.getStatus();
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
                SlaveServerJobStatus jobStatus = new SlaveServerJobStatus(jobName, status);
                Log4jStringAppender appender = (Log4jStringAppender)this.jobMap.getAppender(jobName);
                if (appender != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzos = new GZIPOutputStream(baos);
                    gzos.write(appender.getBuffer().toString().getBytes());
                    gzos.close();
                    String loggingString = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
                    jobStatus.setLoggingString(loggingString);
                }
                jobStatus.setResult(job.getResult());
                out.println(jobStatus.getXML());
            } else {
                response.setContentType("text/html");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + Messages.getString("GetJobStatusServlet.KettleJobStatus") + "</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"10;url=/kettle/jobStatus?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">");
                out.println("</HEAD>");
                out.println("<BODY>");
                out.println("<H1>" + Messages.getString("GetJobStatusServlet.JobStatus") + "</H1>");
                try {
                    out.println("<table border=\"1\">");
                    out.print("<tr> <th>" + Messages.getString("GetJobStatusServlet.Jobname") + "</th> <th>" + Messages.getString("TransStatusServlet.TransStatus") + "</th> </tr>");
                    out.print("<tr>");
                    out.print("<td>" + jobName + "</td>");
                    out.print("<td>" + status + "</td>");
                    out.print("</tr>");
                    out.print("</table>");
                    out.print("<p>");
                    if (job.isFinished()) {
                        out.print("<a href=\"/kettle/startJob?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">" + Messages.getString("GetJobStatusServlet.StartJob") + "</a>");
                        out.print("<p>");
                    } else {
                        out.print("<a href=\"/kettle/stopJob?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">" + Messages.getString("GetJobStatusServlet.StopJob") + "</a>");
                        out.print("<p>");
                    }
                    out.println("<p>");
                    out.print("<a href=\"/kettle/jobStatus/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&xml=y\">" + Messages.getString("TransStatusServlet.ShowAsXml") + "</a><br>");
                    out.print("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><br>");
                    out.print("<p><a href=\"/kettle/jobStatus?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">" + Messages.getString("TransStatusServlet.Refresh") + "</a>");
                    Log4jStringAppender appender = (Log4jStringAppender)this.jobMap.getAppender(jobName);
                    if (appender != null) {
                        out.println("<p>");
                        out.println("<textarea id=\"joblog\" cols=\"120\" rows=\"20\" wrap=\"off\" name=\"Job log\" readonly=\"readonly\">" + appender.getBuffer().toString() + "</textarea>");
                        out.println("<script type=\"text/javascript\"> ");
                        out.println("  joblog.scrollTop=joblog.scrollHeight; ");
                        out.println("</script> ");
                        out.println("<p>");
                    }
                }
                catch (Exception ex) {
                    out.println("<p>");
                    out.println("<pre>");
                    ex.printStackTrace(out);
                    out.println("</pre>");
                }
                out.println("<p>");
                out.println("</BODY>");
                out.println("</HTML>");
            }
        } else if (useXML) {
            out.println(new WebResult("ERROR", Messages.getString("StartJobServlet.Log.SpecifiedJobNotFound", jobName)));
        } else {
            out.println("<H1>Job '" + jobName + "' could not be found.</H1>");
            out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
        }
    }

    public String toString() {
        return "Job Status Handler";
    }
}

