/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.security;

import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.resteasy.reactive.jackson.SecureField;
import io.quarkus.security.identity.SecurityIdentity;
import java.lang.annotation.Annotation;

public class SecurityPropertyFilter
extends SimpleBeanPropertyFilter {
    static final String FILTER_ID = "securityFilter";

    protected boolean include(PropertyWriter writer) {
        SecureField secureField = (SecureField)writer.getAnnotation(SecureField.class);
        if (secureField == null) {
            return super.include(writer);
        }
        ArcContainer container = Arc.container();
        if (container == null) {
            return false;
        }
        InstanceHandle instance = container.instance(SecurityIdentity.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            return false;
        }
        SecurityIdentity securityIdentity = (SecurityIdentity)instance.get();
        for (String role : secureField.rolesAllowed()) {
            if (!securityIdentity.hasRole(role)) continue;
            return true;
        }
        return false;
    }
}

