/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Collection;
import org.hibernate.PropertyAccessException;
import org.hibernate.proxy.HibernateProxy;

public class PropertySetterAccessException
extends PropertyAccessException {
    public PropertySetterAccessException(Throwable cause, Class<?> persistentClass, String propertyName, Class<?> expectedType, Object target, Object value) {
        super(cause, String.format("IllegalArgumentException occurred while calling setter for property [%s.%s (expected type = %s)]; target = [%s], property value = [%s]", persistentClass.getName(), propertyName, expectedType.getName(), target, PropertySetterAccessException.loggablePropertyValueString(value)), true, persistentClass, propertyName);
    }

    public static String loggablePropertyValueString(Object value) {
        if (value instanceof Collection || value instanceof HibernateProxy) {
            return value.getClass().getSimpleName();
        }
        return value.toString();
    }

    public String toString() {
        return super.originalMessage();
    }
}

