/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.Locale;
import oracle.sql.TIMESTAMPTZ;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.StructJdbcType;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;

public class OracleStructJdbcType
extends StructJdbcType {
    public OracleStructJdbcType() {
        this(null, null, null);
    }

    private OracleStructJdbcType(EmbeddableMappingType embeddableMappingType, String typeName, int[] orderMapping) {
        super(embeddableMappingType, typeName == null ? null : typeName.toUpperCase(Locale.ROOT), orderMapping);
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new OracleStructJdbcType(mappingType, sqlType, creationContext.getBootModel().getDatabase().getDefaultNamespace().locateUserDefinedType(Identifier.toIdentifier(sqlType)).getOrderMapping());
    }

    @Override
    protected Object transformRawJdbcValue(Object rawJdbcValue, WrapperOptions options) {
        if (rawJdbcValue.getClass() == TIMESTAMPTZ.class) {
            try {
                return ((TIMESTAMPTZ)rawJdbcValue).offsetDateTimeValue(options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection());
            }
            catch (Exception e) {
                throw new HibernateException("Could not transform the raw jdbc value", e);
            }
        }
        return rawJdbcValue;
    }
}

