/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.cte.AbstractCteMutationHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.graph.basic.BasicResult;

public class CteDeleteHandler
extends AbstractCteMutationHandler
implements DeleteHandler {
    private static final String DELETE_RESULT_TABLE_NAME_PREFIX = "delete_cte_";

    protected CteDeleteHandler(CteTable cteTable, SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, CteMutationStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmDeleteStatement, domainParameterXref, strategy, sessionFactory);
    }

    @Override
    protected void addDmlCtes(CteContainer statement, CteStatement idSelectCte, MultiTableSqmMutationConverter sqmConverter, Map<SqmParameter<?>, List<JdbcParameter>> parameterResolutions, SessionFactoryImplementor factory) {
        TableGroup updatingTableGroup = sqmConverter.getMutatingTableGroup();
        SelectStatement idSelectStatement = (SelectStatement)idSelectCte.getCteDefinition();
        sqmConverter.getProcessingStateStack().push(new SqlAstQueryPartProcessingStateImpl(idSelectStatement.getQuerySpec(), sqmConverter.getCurrentProcessingState(), sqmConverter.getSqlAstCreationState(), sqmConverter.getCurrentClauseStack()::getCurrent, false));
        SqmMutationStrategyHelper.visitCollectionTables((EntityMappingType)updatingTableGroup.getModelPart(), pluralAttribute -> {
            if (pluralAttribute.getSeparateCollectionTable() != null) {
                boolean useFkTarget;
                boolean bl = useFkTarget = !pluralAttribute.getKeyDescriptor().getTargetPart().isEntityIdentifierMapping();
                if (useFkTarget) {
                    TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
                    pluralAttribute.getKeyDescriptor().getTargetPart().applySqlSelections(mutatingTableGroup.getNavigablePath(), mutatingTableGroup, sqmConverter, (selection, jdbcMapping) -> idSelectStatement.getDomainResultDescriptors().add(new BasicResult(selection.getValuesArrayPosition(), null, (JdbcMapping)jdbcMapping)));
                }
                String tableExpression = pluralAttribute.getSeparateCollectionTable();
                CteTable dmlResultCte = new CteTable(this.getCteTableName((PluralAttributeMapping)pluralAttribute), idSelectCte.getCteTable().getCteColumns());
                NamedTableReference dmlTableReference = new NamedTableReference(tableExpression, "to_delete_", true);
                ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
                pluralAttribute.getKeyDescriptor().visitKeySelectables((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable)));
                DeleteStatement dmlStatement = new DeleteStatement(dmlTableReference, this.createIdSubQueryPredicate(columnReferences, idSelectCte, useFkTarget ? pluralAttribute.getKeyDescriptor().getTargetPart() : null, factory), columnReferences);
                statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
            }
        });
        sqmConverter.getProcessingStateStack().pop();
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableColumnsVisitationSupplier) -> {
            String cteTableName = this.getCteTableName(tableExpression);
            if (statement.getCteStatement(cteTableName) != null) {
                return;
            }
            CteTable dmlResultCte = new CteTable(cteTableName, idSelectCte.getCteTable().getCteColumns());
            TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true);
            NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
            ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
            ((Consumer)tableColumnsVisitationSupplier.get()).accept((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable)));
            DeleteStatement dmlStatement = new DeleteStatement(dmlTableReference, this.createIdSubQueryPredicate(columnReferences, idSelectCte, factory), columnReferences);
            statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
        });
    }

    @Override
    protected String getCteTableName(String tableExpression) {
        Dialect dialect = this.getSessionFactory().getJdbcServices().getDialect();
        if (Identifier.isQuoted(tableExpression)) {
            tableExpression = QualifiedNameParser.INSTANCE.parse(tableExpression).getObjectName().getText();
        }
        return Identifier.toIdentifier(DELETE_RESULT_TABLE_NAME_PREFIX + tableExpression).render(dialect);
    }

    protected String getCteTableName(PluralAttributeMapping pluralAttribute) {
        Dialect dialect = this.getSessionFactory().getJdbcServices().getDialect();
        String hibernateEntityName = pluralAttribute.findContainingEntityMapping().getEntityName();
        String jpaEntityName = this.getSessionFactory().getJpaMetamodel().entity(hibernateEntityName).getName();
        return Identifier.toIdentifier(DELETE_RESULT_TABLE_NAME_PREFIX + jpaEntityName + "_" + pluralAttribute.getRootPathName().substring(hibernateEntityName.length() + 1)).render(dialect);
    }
}

