/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.AbstractSqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;

public class SqmInsertValuesStatement<T>
extends AbstractSqmInsertStatement<T> {
    private final List<SqmValues> valuesList;

    public SqmInsertValuesStatement(SqmRoot<T> targetRoot, NodeBuilder nodeBuilder) {
        super(targetRoot, SqmQuerySource.HQL, nodeBuilder);
        this.valuesList = new ArrayList<SqmValues>();
    }

    private SqmInsertValuesStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target, List<SqmPath<?>> insertionTargetPaths, List<SqmValues> valuesList) {
        super(builder, querySource, parameters, cteStatements, target, insertionTargetPaths);
        this.valuesList = valuesList;
    }

    @Override
    public SqmInsertValuesStatement<T> copy(SqmCopyContext context) {
        SqmInsertValuesStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmValues> valuesList = new ArrayList<SqmValues>(this.valuesList.size());
        for (SqmValues sqmValues : this.valuesList) {
            valuesList.add(sqmValues.copy(context));
        }
        return context.registerCopy(this, new SqmInsertValuesStatement<T>(this.nodeBuilder(), this.getQuerySource(), this.copyParameters(context), this.copyCteStatements(context), ((SqmRoot)this.getTarget()).copy(context), this.copyInsertionTargetPaths(context), (List<SqmValues>)valuesList));
    }

    public List<SqmValues> getValuesList() {
        return this.valuesList;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInsertValuesStatement(this);
    }

    @Override
    public JpaPredicate getRestriction() {
        return null;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        super.appendHqlString(sb);
        sb.append(" values (");
        SqmInsertValuesStatement.appendValues(this.valuesList.get(0), sb);
        for (int i = 1; i < this.valuesList.size(); ++i) {
            sb.append(", ");
            SqmInsertValuesStatement.appendValues(this.valuesList.get(i), sb);
        }
        sb.append(')');
    }

    private static void appendValues(SqmValues sqmValues, StringBuilder sb) {
        List<SqmExpression<?>> expressions = sqmValues.getExpressions();
        sb.append('(');
        expressions.get(0).appendHqlString(sb);
        for (int i = 1; i < expressions.size(); ++i) {
            sb.append(", ");
            expressions.get(i).appendHqlString(sb);
        }
        sb.append(')');
    }
}

