/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

@Converter
public class NumericBooleanConverter
implements AttributeConverter<Boolean, Integer>,
BasicValueConverter<Boolean, Integer> {
    public static final NumericBooleanConverter INSTANCE = new NumericBooleanConverter();

    public Integer convertToDatabaseColumn(Boolean attribute) {
        return this.toRelationalValue(attribute);
    }

    public Boolean convertToEntityAttribute(Integer dbData) {
        return this.toDomainValue(dbData);
    }

    @Override
    public Boolean toDomainValue(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        if (1 == relationalForm) {
            return true;
        }
        if (0 == relationalForm) {
            return false;
        }
        return null;
    }

    @Override
    public Integer toRelationalValue(Boolean domainForm) {
        if (domainForm == null) {
            return null;
        }
        return domainForm != false ? 1 : 0;
    }

    @Override
    public JavaType<Boolean> getDomainJavaType() {
        return BooleanJavaType.INSTANCE;
    }

    @Override
    public JavaType<Integer> getRelationalJavaType() {
        return IntegerJavaType.INSTANCE;
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType jdbcType, Dialect dialect) {
        return columnName + " in (0,1)";
    }
}

