/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import org.hibernate.internal.log.SubSystemLogging;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.jboss.logging.Logger;

@SubSystemLogging(name="org.hibernate.orm.jdbc.extract", description="Logging of JDBC value extraction")
public interface JdbcExtractingLogging {
    public static final String NAME = "org.hibernate.orm.jdbc.extract";
    public static final Logger LOGGER = Logger.getLogger((String)"org.hibernate.orm.jdbc.extract");

    public static void logExtracted(int jdbcPosition, int typeCode, Object value) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("extracted value ([%s] : [%s]) - [%s]", jdbcPosition, (Object)JdbcTypeNameMapper.getTypeName(typeCode), value);
        }
    }

    public static void logNullExtracted(int jdbcPosition, int typeCode) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("extracted value ([%s] : [%s]) - [null]", jdbcPosition, (Object)JdbcTypeNameMapper.getTypeName(typeCode));
        }
    }

    public static void logExtracted(String callableParamName, int typeCode, Object value) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("extracted value ([%s] : [%s]) - [%s]", (Object)callableParamName, (Object)JdbcTypeNameMapper.getTypeName(typeCode), value);
        }
    }

    public static void logNullExtracted(String callableParamName, int typeCode) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("extracted value ([%s] : [%s]) - [null]", (Object)callableParamName, (Object)JdbcTypeNameMapper.getTypeName(typeCode));
        }
    }
}

