/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class PropertyMappingInterceptor
implements ConfigSourceInterceptor {
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        ConfigValue value = PropertyMappers.getValue(context, name);
        if (value == null || value.getValue() == null) {
            return null;
        }
        if (!value.getValue().contains("${")) {
            return value;
        }
        return value.withValue(StringPropertyReplacer.replaceProperties((String)value.getValue(), property -> {
            ConfigValue prop = context.proceed(property);
            if (prop == null) {
                return null;
            }
            return prop.getValue();
        }));
    }
}

