/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.Ids;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;

@Deprecated
public class InternalMetadataImpl
implements InternalMetadata {
    private final Metadata actual;
    private final long created;
    private final long lastUsed;

    public InternalMetadataImpl() {
        this(null, -1L, -1L);
    }

    public InternalMetadataImpl(InternalCacheEntry ice) {
        this(ice.getMetadata(), ice.getCreated(), ice.getLastUsed());
    }

    public InternalMetadataImpl(InternalCacheValue icv) {
        this(icv.getMetadata(), icv.getCreated(), icv.getLastUsed());
    }

    public InternalMetadataImpl(Metadata actual, long created, long lastUsed) {
        this.actual = InternalMetadataImpl.extractMetadata(actual);
        this.created = created;
        this.lastUsed = lastUsed;
    }

    @Override
    public long lifespan() {
        return this.actual.lifespan();
    }

    @Override
    public long maxIdle() {
        return this.actual.maxIdle();
    }

    @Override
    public EntryVersion version() {
        return this.actual.version();
    }

    @Override
    public Metadata.Builder builder() {
        return new InternalBuilder(this.actual, this.created, this.lastUsed);
    }

    @Override
    public long created() {
        return this.created;
    }

    @Override
    public long lastUsed() {
        return this.lastUsed;
    }

    public Metadata actual() {
        return this.actual;
    }

    @Override
    public long expiryTime() {
        long muet;
        long lifespan = this.actual.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.actual.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public boolean isExpired(long now) {
        long expiry = this.expiryTime();
        return expiry > 0L && expiry <= now;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalMetadataImpl)) {
            return false;
        }
        InternalMetadataImpl that = (InternalMetadataImpl)o;
        if (this.created != that.created) {
            return false;
        }
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        return !(this.actual != null ? !this.actual.equals(that.actual) : that.actual != null);
    }

    public int hashCode() {
        int result = this.actual != null ? this.actual.hashCode() : 0;
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    public String toString() {
        return "InternalMetadataImpl{actual=" + String.valueOf(this.actual) + ", created=" + this.created + ", lastUsed=" + this.lastUsed + "}";
    }

    public static Metadata extractMetadata(Metadata metadata) {
        Metadata toCheck = metadata;
        while (toCheck != null && toCheck instanceof InternalMetadataImpl) {
            toCheck = ((InternalMetadataImpl)toCheck).actual();
        }
        return toCheck;
    }

    static class InternalBuilder
    implements Metadata.Builder {
        private Metadata.Builder actualBuilder;
        private final long created;
        private final long lastUsed;

        InternalBuilder(Metadata actual, long created, long lastUsed) {
            this.actualBuilder = actual != null ? actual.builder() : new EmbeddedMetadata.Builder();
            this.created = created;
            this.lastUsed = lastUsed;
        }

        @Override
        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            this.actualBuilder = this.actualBuilder.lifespan(time, unit);
            return this;
        }

        @Override
        public Metadata.Builder lifespan(long time) {
            this.actualBuilder = this.actualBuilder.lifespan(time);
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            this.actualBuilder = this.actualBuilder.maxIdle(time, unit);
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time) {
            this.actualBuilder = this.actualBuilder.maxIdle(time);
            return this;
        }

        @Override
        public Metadata.Builder version(EntryVersion version) {
            this.actualBuilder = this.actualBuilder.version(version);
            return this;
        }

        @Override
        public Metadata.Builder merge(Metadata metadata) {
            this.actualBuilder = this.actualBuilder.merge(metadata);
            return this;
        }

        @Override
        public Metadata build() {
            return new InternalMetadataImpl(this.actualBuilder.build(), this.created, this.lastUsed);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<InternalMetadataImpl> {
        public void writeObject(ObjectOutput output, InternalMetadataImpl b) throws IOException {
            output.writeLong(b.created);
            output.writeLong(b.lastUsed);
            output.writeObject(b.actual);
        }

        public InternalMetadataImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long created = input.readLong();
            long lastUsed = input.readLong();
            Metadata actual = (Metadata)input.readObject();
            return new InternalMetadataImpl(actual, created, lastUsed);
        }

        public Integer getId() {
            return Ids.INTERNAL_METADATA_ID;
        }

        public Set<Class<? extends InternalMetadataImpl>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{InternalMetadataImpl.class});
        }
    }
}

