/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener.event.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ConfigurationChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.SitesViewChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;

public class EventImpl
implements CacheStartedEvent,
CacheStoppedEvent,
ViewChangedEvent,
MergeEvent,
ConfigurationChangedEvent,
SitesViewChangedEvent {
    private String cacheName;
    private EmbeddedCacheManager cacheManager;
    private Event.Type type;
    private List<Address> newMembers;
    private List<Address> oldMembers;
    private Address localAddress;
    private int viewId;
    private List<List<Address>> subgroupsMerged;
    private boolean mergeView;
    private String configurationEntityType;
    private String configurationEntityName;
    private ConfigurationChangedEvent.EventType configurationEventType;
    private Collection<String> sitesView;
    private Collection<String> sitesUp;
    private Collection<String> sitesDown;

    public EventImpl() {
    }

    public EventImpl(String cacheName, EmbeddedCacheManager cacheManager, Event.Type type, List<Address> newMemberList, List<Address> oldMemberList, Address localAddress, int viewId) {
        this.cacheName = cacheName;
        this.cacheManager = cacheManager;
        this.type = type;
        this.newMembers = newMemberList;
        this.oldMembers = oldMemberList;
        this.localAddress = localAddress;
        this.viewId = viewId;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Event.Type getType() {
        return this.type;
    }

    public void setType(Event.Type type) {
        this.type = type;
    }

    @Override
    public List<Address> getNewMembers() {
        if (this.newMembers == null) {
            return Collections.emptyList();
        }
        return this.newMembers;
    }

    public void setNewMembers(List<Address> newMembers) {
        this.newMembers = newMembers;
    }

    public void setOldMembers(List<Address> oldMembers) {
        this.oldMembers = oldMembers;
    }

    @Override
    public List<Address> getOldMembers() {
        if (this.oldMembers == null) {
            return Collections.emptyList();
        }
        return this.oldMembers;
    }

    @Override
    public Address getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public int getViewId() {
        return this.viewId;
    }

    public void setViewId(int viewId) {
        this.viewId = viewId;
    }

    public void setLocalAddress(Address localAddress) {
        this.localAddress = localAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)o;
        return this.viewId == event.viewId && this.mergeView == event.mergeView && this.type == event.type && this.configurationEventType == event.configurationEventType && Objects.equals(this.cacheName, event.cacheName) && Objects.equals(this.cacheManager, event.cacheManager) && Objects.equals(this.newMembers, event.newMembers) && Objects.equals(this.oldMembers, event.oldMembers) && Objects.equals(this.localAddress, event.localAddress) && Objects.equals(this.subgroupsMerged, event.subgroupsMerged) && Objects.equals(this.configurationEntityType, event.configurationEntityType) && Objects.equals(this.configurationEntityName, event.configurationEntityName) && Objects.equals(this.sitesView, event.sitesView) && Objects.equals(this.sitesUp, event.sitesUp) && Objects.equals(this.sitesDown, event.sitesDown);
    }

    public int hashCode() {
        int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
        result = 31 * result + (this.cacheManager != null ? this.cacheManager.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.newMembers != null ? this.newMembers.hashCode() : 0);
        result = 31 * result + (this.oldMembers != null ? this.oldMembers.hashCode() : 0);
        result = 31 * result + (this.localAddress != null ? this.localAddress.hashCode() : 0);
        result = 31 * result + this.viewId;
        result = 31 * result + (this.subgroupsMerged == null ? 0 : this.subgroupsMerged.hashCode());
        result = 31 * result + (this.mergeView ? 1 : 0);
        result = 31 * result + (this.configurationEntityType != null ? this.configurationEntityType.hashCode() : 0);
        result = 31 * result + (this.configurationEntityName != null ? this.configurationEntityName.hashCode() : 0);
        result = 31 * result + (this.configurationEventType != null ? this.configurationEventType.hashCode() : 0);
        result = 31 * result + (this.sitesView != null ? this.sitesView.hashCode() : 0);
        result = 31 * result + (this.sitesUp != null ? this.sitesUp.hashCode() : 0);
        result = 31 * result + (this.sitesDown != null ? this.sitesDown.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventImpl{cacheName='" + this.cacheName + "', cacheManager=" + String.valueOf(this.cacheManager) + ", type=" + String.valueOf((Object)this.type) + ", newMembers=" + String.valueOf(this.newMembers) + ", oldMembers=" + String.valueOf(this.oldMembers) + ", localAddress=" + String.valueOf(this.localAddress) + ", viewId=" + this.viewId + ", subgroupsMerged=" + String.valueOf(this.subgroupsMerged) + ", mergeView=" + this.mergeView + ", configurationEntityType='" + this.configurationEntityType + "', configurationEntityName='" + this.configurationEntityName + "', configurationEventType=" + String.valueOf((Object)this.configurationEventType) + ", sitesView=" + String.valueOf(this.sitesView) + ", sitesUp=" + String.valueOf(this.sitesUp) + ", sitesDown=" + String.valueOf(this.sitesDown) + "}";
    }

    public void setSubgroupsMerged(List<List<Address>> subgroupsMerged) {
        this.subgroupsMerged = subgroupsMerged;
    }

    @Override
    public List<List<Address>> getSubgroupsMerged() {
        return this.subgroupsMerged;
    }

    @Override
    public boolean isMergeView() {
        return this.mergeView;
    }

    public void setMergeView(boolean b) {
        this.mergeView = b;
    }

    public void setConfigurationEventType(ConfigurationChangedEvent.EventType eventType) {
        this.configurationEventType = eventType;
    }

    public void setConfigurationEntityType(String type) {
        this.configurationEntityType = type;
    }

    public void setConfigurationEntityName(String name) {
        this.configurationEntityName = name;
    }

    @Override
    public ConfigurationChangedEvent.EventType getConfigurationEventType() {
        return this.configurationEventType;
    }

    @Override
    public String getConfigurationEntityType() {
        return this.configurationEntityType;
    }

    @Override
    public String getConfigurationEntityName() {
        return this.configurationEntityName;
    }

    @Override
    public Collection<String> getSites() {
        return this.sitesView;
    }

    @Override
    public Collection<String> getJoiners() {
        return this.sitesUp;
    }

    @Override
    public Collection<String> getLeavers() {
        return this.sitesDown;
    }

    public void setSitesView(Collection<String> sitesView) {
        this.sitesView = sitesView;
    }

    public void setSitesUp(Collection<String> sitesUp) {
        this.sitesUp = sitesUp;
    }

    public void setSitesDown(Collection<String> sitesDown) {
        this.sitesDown = sitesDown;
    }
}

