/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Comparator;
import org.keycloak.models.sessions.infinispan.UserSessionTimestamp;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class Comparators {
    public static Comparator<UserSessionTimestamp> userSessionTimestamp() {
        return new UserSessionTimestampComparator();
    }

    public static Comparator<UserSessionEntity> userSessionLastSessionRefresh() {
        return new UserSessionLastSessionRefreshComparator();
    }

    private static class UserSessionTimestampComparator
    implements Comparator<UserSessionTimestamp>,
    Serializable {
        private UserSessionTimestampComparator() {
        }

        @Override
        public int compare(UserSessionTimestamp u1, UserSessionTimestamp u2) {
            return u1.getClientSessionTimestamp() - u2.getClientSessionTimestamp();
        }
    }

    private static class UserSessionLastSessionRefreshComparator
    implements Comparator<UserSessionEntity>,
    Serializable {
        private UserSessionLastSessionRefreshComparator() {
        }

        @Override
        public int compare(UserSessionEntity u1, UserSessionEntity u2) {
            return u1.getLastSessionRefresh() - u2.getLastSessionRefresh();
        }
    }
}

