/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.services.resources.Cors;
import org.keycloak.utils.MediaType;

public class OAuth2Error {
    private static final Map<Response.Status, Class<? extends WebApplicationException>> STATUS_MAP = new HashMap<Response.Status, Class<? extends WebApplicationException>>();
    private RealmModel realm;
    private String error;
    private String errorDescription;
    private Optional<Cors> cors = Optional.empty();
    private Class<? extends WebApplicationException> clazz;
    private Response.Status status;
    private boolean json = true;

    public OAuth2Error realm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public OAuth2Error error(String error) {
        this.error = error;
        switch (error) {
            case "invalid_grant": 
            case "invalid_request": 
            case "unauthorized_client": 
            case "unsupported_grant_type": 
            case "invalid_scope": {
                this.status = Response.Status.BAD_REQUEST;
                break;
            }
            case "invalid_client": 
            case "invalid_token": {
                this.status = Response.Status.UNAUTHORIZED;
                break;
            }
            case "insufficient_scope": {
                this.status = Response.Status.FORBIDDEN;
                break;
            }
            case "server_error": {
                this.status = Response.Status.INTERNAL_SERVER_ERROR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized OAuth 2.0 error: " + error);
            }
        }
        return this;
    }

    public OAuth2Error errorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    public OAuth2Error cors(Cors cors) {
        this.cors = Optional.ofNullable(cors);
        return this;
    }

    public OAuth2Error status(Response.Status status) {
        this.status = status;
        return this;
    }

    public OAuth2Error json(boolean json) {
        this.json = json;
        return this;
    }

    public WebApplicationException build() {
        this.clazz = STATUS_MAP.getOrDefault(this.status, WebApplicationException.class);
        Response.ResponseBuilder builder = Response.status((Response.Status)this.status);
        try {
            Constructor<? extends WebApplicationException> constructor = this.clazz.getConstructor(Response.class);
            this.cors.ifPresent(_cors -> _cors.build((arg_0, arg_1) -> ((Response.ResponseBuilder)builder).header(arg_0, arg_1)));
            if (this.json) {
                OAuth2ErrorRepresentation errorRep = new OAuth2ErrorRepresentation(this.error, this.errorDescription);
                builder.entity((Object)errorRep).type(MediaType.APPLICATION_JSON_TYPE);
            } else {
                WWWAuthenticate.BearerChallenge bearer = new WWWAuthenticate.BearerChallenge();
                bearer.setRealm(this.realm.getName());
                bearer.setError(this.error);
                bearer.setErrorDescription(this.errorDescription);
                WWWAuthenticate wwwAuthenticate = new WWWAuthenticate(bearer, new WWWAuthenticate.Challenge[0]);
                wwwAuthenticate.build((arg_0, arg_1) -> ((Response.ResponseBuilder)builder).header(arg_0, arg_1));
                builder.entity((Object)"").type(MediaType.TEXT_PLAIN_UTF_8_TYPE);
            }
            return constructor.newInstance(builder.build());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    public WebApplicationException insufficientScope(String errorDescription) {
        return this.error("insufficient_scope").errorDescription(errorDescription).build();
    }

    public WebApplicationException invalidToken(String errorDescription) {
        return this.error("invalid_token").errorDescription(errorDescription).build();
    }

    public WebApplicationException invalidRequest(String errorDescription) {
        return this.error("invalid_request").errorDescription(errorDescription).build();
    }

    public WebApplicationException unauthorized() {
        return this.status(Response.Status.UNAUTHORIZED).build();
    }

    static {
        STATUS_MAP.put(Response.Status.BAD_REQUEST, BadRequestException.class);
        STATUS_MAP.put(Response.Status.UNAUTHORIZED, NotAuthorizedException.class);
        STATUS_MAP.put(Response.Status.FORBIDDEN, ForbiddenException.class);
        STATUS_MAP.put(Response.Status.INTERNAL_SERVER_ERROR, InternalServerErrorException.class);
    }

    private static class WWWAuthenticate {
        private final List<Challenge> challenges;
        private Challenge master;
        private boolean singleHeader = true;

        public WWWAuthenticate(Challenge challenge, Challenge ... moreChallenges) {
            this.challenges = new ArrayList<Challenge>(1 + (moreChallenges == null ? 0 : moreChallenges.length));
            this.challenges.add(challenge);
            if (moreChallenges != null) {
                this.challenges.addAll(Arrays.asList(moreChallenges));
            }
            this.master = challenge;
        }

        public void addChallenge(Challenge challenge) {
            this.challenges.add(challenge);
        }

        public void setMasterChallenge(Challenge challenge) {
            if (!this.challenges.contains(challenge)) {
                throw new IllegalArgumentException("Unknown challenge: " + challenge);
            }
            this.master = challenge;
        }

        public void setMasterChallenge(String scheme) {
            this.master = this.challenges.stream().filter(c -> c.getScheme().equals(scheme)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown challenge: " + scheme));
        }

        public Challenge getMasterChallenge() {
            return this.master;
        }

        public boolean isSingleHeader() {
            return this.singleHeader;
        }

        public void setSingleHeader(boolean singleHeader) {
            this.singleHeader = singleHeader;
        }

        public void setAttribute(String attribute, String value) {
            this.challenges.forEach(c -> c.setAttribute(attribute, value));
        }

        public void build(BiConsumer<String, Object> addHeader) {
            if (this.singleHeader) {
                String header = this.challenges.stream().map(Challenge::toString).collect(Collectors.joining(", "));
                addHeader.accept("WWW-Authenticate", header);
            } else {
                this.challenges.forEach(c -> addHeader.accept("WWW-Authenticate", c));
            }
        }

        public static abstract class Challenge {
            private final Map<String, String> attributes = new LinkedHashMap<String, String>();

            public void setAttribute(String attribute, String value) {
                if (value != null) {
                    this.attributes.put(attribute, value);
                }
            }

            public abstract String getScheme();

            public String toString() {
                StringBuilder sb = new StringBuilder(this.getScheme());
                if (!this.attributes.isEmpty()) {
                    sb.append(" ").append(this.attributes.entrySet().stream().map(e -> String.format("%s=\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(", ")));
                }
                return sb.toString();
            }
        }

        public static class BearerChallenge
        extends BasicChallenge {
            private static final String BEARER_SCHEME = "Bearer";
            private static final String ERROR_ATTRIBUTE = "error";
            private static final String ERROR_DESCRIPTION_ATTRIBUTE = "error_description";
            private static final String ERROR_URI_ATTRIBUTE = "error_uri";
            private static final String SCOPE_ATTRIBUTE = "scope";

            public void setError(String error) {
                this.setAttribute(ERROR_ATTRIBUTE, error);
            }

            public void setErrorDescription(String errorDescription) {
                this.setAttribute(ERROR_DESCRIPTION_ATTRIBUTE, errorDescription);
            }

            public void setErrorUri(String errorUri) {
                this.setAttribute(ERROR_URI_ATTRIBUTE, errorUri);
            }

            public void setScope(String scope) {
                this.setAttribute(SCOPE_ATTRIBUTE, scope);
            }

            @Override
            public String getScheme() {
                return BEARER_SCHEME;
            }
        }

        public static class BasicChallenge
        extends Challenge {
            private static final String BASIC_SCHEME = "Basic";
            private static final String REALM_ATTRIBUTE = "realm";

            public void setRealm(String realm) {
                this.setAttribute(REALM_ATTRIBUTE, realm);
            }

            @Override
            public String getScheme() {
                return BASIC_SCHEME;
            }
        }
    }
}

