/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.http.entity.ContentType;
import org.keycloak.client.admin.cli.util.Header;

public class Headers
implements Iterable<Header> {
    private LinkedHashMap<String, Header> headers = new LinkedHashMap();

    public void add(String header, String value) {
        this.headers.put(header.toLowerCase(), new Header(header, value));
    }

    public boolean addIfMissing(String header, String value) {
        String key = header.toLowerCase();
        if (!this.headers.containsKey(key)) {
            this.headers.put(key, new Header(header, value));
            return true;
        }
        return false;
    }

    public boolean contains(String header) {
        String key = header.toLowerCase();
        return this.headers.containsKey(key);
    }

    public Header get(String header) {
        return this.headers.get(header.toLowerCase());
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.values().iterator();
    }

    public Optional<ContentType> getContentType() {
        return Optional.ofNullable(this.headers.get("content-type")).map(Header::getValue).map(ContentType::parse);
    }
}

