/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;

public interface NTAdapter {
    public NetworkAdapterType getNetworkAdapterType();

    public void connect(DMSFactory.DMSNoun var1) throws IOException;

    public void disconnect() throws IOException;

    public SocketChannel getSocketChannel();

    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    public void setOption(int var1, Object var2) throws IOException, NetException;

    public Object getOption(int var1) throws IOException, NetException;

    public void abort() throws IOException, NetException;

    public void sendUrgentByte(int var1) throws IOException;

    public boolean isCharacteristicUrgentSupported() throws IOException;

    public void setReadTimeoutIfRequired(Properties var1) throws IOException, NetException;

    public boolean isConnectionSocketKeepAlive() throws SocketException;

    public InetAddress getInetAddress();

    default public NetStat getNetStat() {
        return null;
    }

    default public CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        throw new UnsupportedOperationException("This NT Adapter does not support non-blocking connects");
    }

    default public void registerForNonBlockingRead(Consumer<Throwable> onReady) throws IOException {
        throw new UnsupportedOperationException("This NT Adapter does not support non-blocking reads");
    }

    default public void registerForNonBlockingWrite(Consumer<Throwable> onReady) throws IOException {
        throw new UnsupportedOperationException("This NT Adapter does not support non-blocking writes");
    }

    default public void cancelNonBlockingRegistration(Throwable onReadyError) throws IOException {
        throw new UnsupportedOperationException("This NT Adapter does not support non-blocking IO");
    }

    default public boolean awaitWriteReadiness(long timeoutMillis) throws IOException {
        return true;
    }

    @Blind
    default public Properties getSqlNetOptions() {
        throw new UnsupportedOperationException();
    }

    default public void enqueueBlockedWrites(boolean isEnabled) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public boolean completeBlockedWrites() throws IOException {
        throw new UnsupportedOperationException();
    }

    public static enum NetworkAdapterType {
        TCP,
        TCPS,
        SDP,
        MSGQ,
        BEQ;

    }
}

