/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.cdi;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusArcBeanContainer;
import java.lang.annotation.Annotation;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;

public class QuarkusManagedBeanRegistry
implements ManagedBeanRegistry {
    private final QuarkusArcBeanContainer beanContainer = (QuarkusArcBeanContainer)((Object)Arc.container().instance(QuarkusArcBeanContainer.class, new Annotation[0]).get());

    public <T> ManagedBean<T> getBean(Class<T> beanClass) {
        return this.getBean(beanClass, (BeanInstanceProducer)FallbackBeanInstanceProducer.INSTANCE);
    }

    public <T> ManagedBean<T> getBean(String beanName, Class<T> beanContract) {
        return this.getBean(beanName, beanContract, (BeanInstanceProducer)FallbackBeanInstanceProducer.INSTANCE);
    }

    public BeanContainer getBeanContainer() {
        return this.beanContainer;
    }

    public <T> ManagedBean<T> getBean(Class<T> beanClass, BeanInstanceProducer fallbackBeanInstanceProducer) {
        return new ContainedBeanManagedBeanAdapter<T>(beanClass, this.beanContainer.getBean(beanClass, QuarkusBeanContainerLifecycleOptions.INSTANCE, fallbackBeanInstanceProducer));
    }

    public <T> ManagedBean<T> getBean(String beanName, Class<T> beanContract, BeanInstanceProducer fallbackBeanInstanceProducer) {
        return new ContainedBeanManagedBeanAdapter<T>(beanContract, this.beanContainer.getBean(beanName, beanContract, QuarkusBeanContainerLifecycleOptions.INSTANCE, fallbackBeanInstanceProducer));
    }

    private static final class QuarkusBeanContainerLifecycleOptions
    implements BeanContainer.LifecycleOptions {
        private static final QuarkusBeanContainerLifecycleOptions INSTANCE = new QuarkusBeanContainerLifecycleOptions();

        private QuarkusBeanContainerLifecycleOptions() {
        }

        public boolean useJpaCompliantCreation() {
            return false;
        }

        public boolean canUseCachedReferences() {
            return false;
        }
    }

    private static class ContainedBeanManagedBeanAdapter<B>
    implements ManagedBean<B> {
        private final Class<B> beanClass;
        private final ContainedBean<B> containedBean;

        private ContainedBeanManagedBeanAdapter(Class<B> beanClass, ContainedBean<B> containedBean) {
            this.beanClass = beanClass;
            this.containedBean = containedBean;
        }

        public Class<B> getBeanClass() {
            return this.beanClass;
        }

        public B getBeanInstance() {
            return (B)this.containedBean.getBeanInstance();
        }
    }
}

