/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import jakarta.persistence.GenerationType;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.generator.Generator;
import org.hibernate.id.Assigned;
import org.hibernate.id.Configurable;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.factory.IdGenFactoryLogging;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.internal.AutoGenerationTypeStrategy;
import org.hibernate.id.factory.internal.IdentityGenerationTypeStrategy;
import org.hibernate.id.factory.internal.SequenceGenerationTypeStrategy;
import org.hibernate.id.factory.internal.TableGenerationTypeStrategy;
import org.hibernate.id.factory.internal.UUIDGenerationTypeStrategy;
import org.hibernate.id.factory.spi.GenerationTypeStrategy;
import org.hibernate.id.factory.spi.GenerationTypeStrategyRegistration;
import org.hibernate.id.factory.spi.GeneratorDefinitionResolver;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;

final class QuarkusSimplifiedIdentifierGeneratorFactory
implements IdentifierGeneratorFactory {
    private final ServiceRegistry serviceRegistry;
    private final ConcurrentHashMap<GenerationType, GenerationTypeStrategy> generatorTypeStrategyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends Generator>> legacyGeneratorClassNameMap = new ConcurrentHashMap();
    private Dialect dialect;

    public QuarkusSimplifiedIdentifierGeneratorFactory(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.registerJpaGenerators();
        this.logOverrides();
        this.registerPredefinedGenerators();
        this.registerUsingLegacyContributor();
    }

    private void registerJpaGenerators() {
        this.generatorTypeStrategyMap.put(GenerationType.AUTO, (GenerationTypeStrategy)AutoGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.SEQUENCE, (GenerationTypeStrategy)SequenceGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.TABLE, (GenerationTypeStrategy)TableGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.IDENTITY, (GenerationTypeStrategy)IdentityGenerationTypeStrategy.INSTANCE);
        this.generatorTypeStrategyMap.put(GenerationType.UUID, (GenerationTypeStrategy)UUIDGenerationTypeStrategy.INSTANCE);
    }

    private void logOverrides() {
        ((ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class)).loadJavaServices(GenerationTypeStrategyRegistration.class).forEach(registration -> registration.registerStrategies((generationType, generationTypeStrategy) -> {
            GenerationTypeStrategy previous = this.generatorTypeStrategyMap.put((GenerationType)generationType, (GenerationTypeStrategy)generationTypeStrategy);
            if (previous != null) {
                IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debugf("GenerationTypeStrategyRegistration [%s] overrode previous registration for GenerationType#%s : %s", registration, (Object)generationType.name(), (Object)previous);
            }
        }, this.serviceRegistry));
    }

    private void registerPredefinedGenerators() {
        this.register("uuid2", UUIDGenerator.class);
        this.register("guid", GUIDGenerator.class);
        this.register("uuid", UUIDHexGenerator.class);
        this.register("uuid.hex", UUIDHexGenerator.class);
        this.register("assigned", Assigned.class);
        this.register("identity", IdentityGenerator.class);
        this.register("select", SelectGenerator.class);
        this.register("sequence", SequenceStyleGenerator.class);
        this.register("increment", IncrementGenerator.class);
        this.register("foreign", ForeignGenerator.class);
        this.register("enhanced-sequence", SequenceStyleGenerator.class);
        this.register("enhanced-table", TableGenerator.class);
    }

    private void registerUsingLegacyContributor() {
        ConfigurationService configService = (ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class);
        Object providerSetting = configService.getSettings().get("hibernate.identifier_generator_strategy_provider");
        if (providerSetting != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting2("hibernate.identifier_generator_strategy_provider", "supply a org.hibernate.id.factory.spi.GenerationTypeStrategyRegistration Java service");
            IdentifierGeneratorStrategyProvider idGeneratorStrategyProvider = (IdentifierGeneratorStrategyProvider)((StrategySelector)this.serviceRegistry.getService(StrategySelector.class)).resolveStrategy(IdentifierGeneratorStrategyProvider.class, providerSetting);
            for (Map.Entry entry : idGeneratorStrategyProvider.getStrategies().entrySet()) {
                Class generatorClass = (Class)entry.getValue();
                this.register((String)entry.getKey(), generatorClass);
            }
        }
    }

    public void register(String strategy, Class generatorClass) {
        IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debugf("Registering IdentifierGenerator strategy [%s] -> [%s]", (Object)strategy, (Object)generatorClass.getName());
        Class<? extends Generator> previous = this.legacyGeneratorClassNameMap.put(strategy, generatorClass);
        if (previous != null && IdGenFactoryLogging.ID_GEN_FAC_LOGGER.isDebugEnabled()) {
            IdGenFactoryLogging.ID_GEN_FAC_LOGGER.debugf("    - overriding [%s]", (Object)previous.getName());
        }
    }

    public IdentifierGenerator createIdentifierGenerator(GenerationType generationType, String generatedValueGeneratorName, String generatorName, JavaType<?> javaType, Properties config, GeneratorDefinitionResolver definitionResolver) {
        GenerationTypeStrategy strategy = this.generatorTypeStrategyMap.get(generationType);
        if (strategy != null) {
            return strategy.createIdentifierGenerator(generationType, generatorName, javaType, config, definitionResolver, this.serviceRegistry);
        }
        throw new UnsupportedOperationException("No GenerationTypeStrategy specified");
    }

    public Dialect getDialect() {
        if (this.dialect == null) {
            this.dialect = ((JdbcEnvironment)this.serviceRegistry.getService(JdbcEnvironment.class)).getDialect();
        }
        return this.dialect;
    }

    public Generator createIdentifierGenerator(String strategy, Type type, Properties parameters) {
        Class clazz = this.getIdentifierGeneratorClass(strategy);
        try {
            Generator identifierGenerator = (Generator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (identifierGenerator instanceof Configurable) {
                ((Configurable)identifierGenerator).configure(type, parameters, this.serviceRegistry);
            }
            return identifierGenerator;
        }
        catch (Exception e) {
            String entityName = parameters.getProperty("entity_name");
            throw new MappingException("Could not instantiate id generator [entity-name=" + entityName + "]");
        }
    }

    public Class getIdentifierGeneratorClass(String strategy) {
        if ("hilo".equals(strategy)) {
            throw new UnsupportedOperationException("Support for 'hilo' generator has been removed");
        }
        String resolvedStrategy = "native".equals(strategy) ? this.getDialect().getNativeIdentifierGeneratorStrategy() : strategy;
        Class generatorClass = this.legacyGeneratorClassNameMap.get(resolvedStrategy);
        try {
            if (generatorClass == null) {
                ClassLoaderService cls = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
                generatorClass = cls.classForName(resolvedStrategy);
            }
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Could not interpret id generator strategy [" + strategy + "]");
        }
        return generatorClass;
    }
}

