/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of metropolitan France by region
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
* @source http://commons.wikimedia.org/wiki/File:Guadeloupe_department_location_map.svg
* @source http://commons.wikimedia.org/wiki/File:Martinique_department_location_map.svg
* @source http://commons.wikimedia.org/wiki/File:Guyane_department_location_map.svg
* @source http://commons.wikimedia.org/wiki/File:La_R%C3%A9union_arrondissement_commune_map.svg
* @source http://commons.wikimedia.org/wiki/File:Mayotte_blank_map.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_regions : {
					width : 599.91296,
					height : 626.66663,
					getCoords : function (lat, lon) {
						if (lat < 43.213183 && lat > 40.780541 && lon > 7.611694 && lon < 11.21521) {
							// Corse
							var xfactor = 43.64246;
							var xoffset = 223.2912;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -65.77758;
							var yoffset = 3346.37839;
							var y = (lat * yfactor) + yoffset;
						} else {
							var xfactor = 45.48385;
							var xoffset = 222.309;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -65.97284;
							var yoffset = 3371.10748;
							var y = (lat * yfactor) + yoffset;
						}
                        return {x : x, y : y};
					},
					elems : {
					    "region-53" : "m 77.55,146.69 c -2.18,0.97 -4.29,2.09 -5.31,4.31 -0.95,0.92 1.17,-5.13 -1.44,-3.44 -1.04,2.53 -4.55,0.8 -6.22,2.69 -2.17,3.05 -3.41,-2.38 -6.09,-0.78 -1.84,0.33 -1.1,2.47 -3.03,2.88 -0.93,1.49 3.49,3.66 0.09,3.84 -0.99,0.94 1.04,4.8 -1.59,3.13 -1.84,1.15 -0.66,-0.87 -2.47,-0.84 -2.05,-0.25 -3.75,-1.52 -5.91,-1.38 -3.15,-1.06 -2.04,4.36 -3.09,5.41 -1.21,-0.52 -1.95,-1.73 -2.19,-2.81 -1.19,0.54 -2.06,1.99 -2.28,-0.03 -0.68,-1.05 -0.42,-2.7 -0.91,-3.59 -1.58,0.96 -3.5,1.64 -4.16,3.31 -1.54,-1.47 -4.05,-0.61 -5.72,0.28 -1.47,0.32 -0.49,2.11 -0.47,1.94 -1.6,-0.37 -3.55,0.35 -4.66,0.72 1.4,-2.77 -2.51,-2.89 -3.97,-1.38 -0.64,0.11 -2,0.43 -1.03,1.28 -2.04,0.5 -3.81,0.84 -5.84,0.44 -2.03,0.42 1.52,3.32 -1.31,2.25 -2.56,-1.01 -1.41,1.5 -0.75,2.41 -1.28,-1.21 -3.95,-1.38 -5.34,-0.06 -1.98,0.41 -3.19,2.69 -3.28,4.59 0.74,1.03 1.43,1.8 -0.13,2.56 -1.57,2.24 1.6,4.38 -0.22,6.47 0.53,2.34 3.91,1.86 4.59,0.09 2.27,0.52 4.46,1.23 6.56,-0.44 2.6,-1.34 5.43,-2.15 8.22,-2.97 0.92,-0.31 4.09,-1.68 1.88,-0.22 -2.02,1.28 -5.2,1.76 -5.81,4.44 -0.04,1.77 1.96,-0.55 2.59,1.09 1.06,-1.01 2.4,-1.7 3.81,-1.44 1.47,-1.28 1.28,0.04 0.13,0.69 -1.8,1.75 1.83,1.25 2.72,1.94 0.36,-0.17 1.77,0.85 1.97,0.78 -1.65,0.15 -3.08,1.32 -4.38,0 -2.31,0.21 -4.61,1.9 -6.69,-0.09 -1.48,0.7 -3.23,0.53 -4.59,0.16 -0.84,-0.95 1.43,-3.75 -0.97,-2.47 -1.64,0.71 0.55,4.28 -2.09,3.09 -1.86,1.31 1.59,2.52 2.69,1.97 0.19,1.21 -0.97,2.21 -0.03,3.56 0.11,1.13 -0.37,2.81 1.06,1.28 1.1,-1.67 1.85,-4.89 4.5,-3.38 1.97,1.62 4.98,1.12 6,3.59 1.13,1.38 1.68,5.94 -1.13,5.16 -2.19,-1.24 -4.56,0.13 -6.78,0.53 -3.6,0.94 -7.3,1.41 -10.97,2 -1.02,2.79 2.2,2.3 3.94,2.69 1.57,0.58 2.72,2.13 4.28,0.44 2.87,1.58 5.45,3.83 6.97,6.78 0.75,1.87 2.57,4.36 0.56,6 -0.49,2.41 3.46,1.3 4.97,1.91 1.77,0.5 6.29,-1.55 3.63,-3.09 -1.14,-1.39 0.15,-3.24 1,-1.09 2.15,0.54 2.05,-1.76 0.84,-2.78 -0.21,-2.37 1.08,2.24 2.5,2.06 1.3,-0.04 1.91,1.21 3.25,0.75 2.3,0.96 0.55,-4.29 3.09,-2.06 2.11,1.57 2.69,4.21 4.56,6 1.48,0.03 3.55,0.98 5.03,-0.31 1.53,-0.27 2.74,1.8 4.56,1.56 7.1,1.87 6.22,-1.53 5.28,0.34 0.76,1.87 1.76,4.55 4,4.84 1.75,0.33 3.97,-0.88 2.47,-2.28 1.59,0.45 3.33,-2.79 4.09,-2.38 -0.13,1.59 -3.63,3.33 -2.06,4.22 2.47,-0.22 3.68,4.17 5.75,3.22 -0.25,-2.41 3.74,-3.2 1.31,-5.38 0.07,-0.51 1.48,0.54 1.97,-0.28 -0.65,1.5 2.24,1.64 0.59,3.25 -2.17,0.5 -5.09,2.65 -2.59,4.88 2.69,1.08 0.71,4.49 1.41,6.69 -0.22,1.75 3.13,1.9 1.44,0.16 -0.99,-0.96 -1.05,-6.52 1,-4.22 -0.06,1.32 4.37,0.76 3.56,-1.19 0.28,-0.25 1.24,3.02 1.38,0.81 0.45,1.07 3.39,2.69 1.94,0.66 -0.85,-1.47 -0.64,-3.47 -1.09,-4.88 1.67,1.06 0.92,3.22 2.78,3.75 1.19,1.24 2.51,-1.47 3.25,-1.75 1.74,0.54 4.19,-2.37 4.41,0.28 -1.13,0.56 2.41,2.03 2.03,0.22 -0.01,-1.02 0.07,-1.73 0.66,-0.31 -0.1,1.85 -1.62,4.06 -2.97,4.91 -2.01,-1.25 -3.92,0.53 -5.75,-1.09 -2.41,-0.75 -1.22,1.48 0.28,1.88 1.28,1.49 2.28,4 4.72,2.34 1.58,-1.19 4.64,1.01 4.91,-1.53 0.94,0.16 2.07,0.05 1.56,-1.03 1.32,-0.16 3,-0.7 1.13,0.69 0.65,1.62 3.99,-0.93 5.56,0.44 1.17,1.48 3.84,0.65 4.78,1.28 -2.04,0.45 -6.32,-0.66 -5.19,2.78 1.29,2.36 2.69,-3.37 4.06,-0.44 1.93,0.09 4.5,0.48 4.41,-2.28 0.26,-2.08 2.41,-0.85 3.03,-0.28 1.19,-0.72 2.59,-0.89 3.09,0.41 1.27,-0.55 0.9,-2.95 2.88,-2.59 0.95,-1.62 0.37,-3.71 0.84,-5.49 0.78,-5.61 -4.02,0.63 3.1,-3.58 1.4,-0.12 2.45,-2.65 2.97,-0.28 1.34,-1.32 3.48,-1.27 5,-2.28 1.96,0.36 3.9,0.32 5.81,0.38 2.01,-0.47 4.26,-1.08 4.47,-3.59 1.78,-2.07 5.04,-1.86 7.03,-3.38 -1.35,-2.84 2.64,-1.48 4,-1.03 0.91,1.88 2.98,2.02 4.75,2.59 2.4,1.02 2.01,-2.44 2.91,-3.78 -0.25,-1.23 1.51,-1.54 1.13,-3.09 1.75,-1.44 0.62,-4.34 2.53,-5.69 1.37,-2.06 5.65,0.75 5.31,-2.94 -0.57,-1.85 -0.31,-3.81 -1.41,-5.47 -0.19,-2.53 -1.34,-4.78 -1.47,-7.31 -0.32,-1.92 -1.38,-4.44 0.53,-5.94 1.68,-1.62 0.44,-4.09 0.5,-6.03 -1.88,-2.34 0.48,-5.06 -0.88,-7.47 -1.44,-1.4 -3.62,-0.63 -5.25,-1.78 -1.79,-0.97 -3.67,-0.49 -4.03,1.72 -2.41,0.32 -3.01,3.67 -5.59,3.19 -1.6,-0.55 -2.12,-2.02 -3.88,-2.34 -1.66,-2.38 -1.57,-5.06 -2.81,-7.53 -0.67,-1.47 -1.98,-2.35 -3.31,-0.84 -2.14,1.06 -4.77,0.58 -7.09,1 -1.98,0.31 -4.48,-1.04 -4.06,-3.28 0.37,-0.95 1.78,-2.35 0.56,-3.25 -1.79,1.11 -3.53,0.49 -5.19,1.22 -1.33,0.27 -1.62,2.1 -2.81,2.91 0.05,2.01 1.94,3.28 3.13,4.44 -1.9,1.4 1.28,2.2 0.34,3.34 -2.2,2.26 -0.47,-3.02 -3.16,-2.09 -1.23,2.3 -1.13,-1.92 -3.16,-0.97 -0.98,-0.96 -3.18,-4.55 -3.47,-1.25 -0.31,1.86 -1.31,-1.15 -2.13,0.75 -0.55,-1.37 -1.29,-3.44 -2.13,-4.22 -1.05,0.87 -3.98,2.86 -2.31,0.19 1.61,-1.33 -0.19,-4.16 -1.41,-1.78 -1.59,0.73 -2.87,2.56 -4.5,1.06 -0.75,-0.13 -2.87,0.55 -1.22,1.19 -1.01,2 -3.58,2.06 -4.94,3.59 -1.37,1.74 -2.79,3.54 -4.88,3.31 0.31,3.1 -2.72,0.01 -2.03,-1.5 -2.07,-1.61 -5.2,-2.76 -4.5,-6.06 -1.5,-2.13 -3.95,-3.36 -5.38,-5.66 0.92,-3.22 -2.95,-1.86 -4.25,-3.5 -0.56,-0.74 2.52,-2.63 -0.09,-2.81 -2.8,-0.54 -2.29,3.78 -4,4.19 1.22,-1.79 2.14,-3.95 1.69,-6.22 0,-0.43 -0.03,-0.98 -0.5,-1.16 z",
					    "region-52" : "m 208.48,167.06 c -1.48,0.64 0.52,2.23 -1.16,2.94 -0.62,1.58 -2.9,-1.24 -3.44,1.03 -1.11,2.61 -2.89,-1.23 -4.88,-0.63 -1.86,0.66 -3.73,0.55 -4.91,2.47 -1.67,0.11 -2.98,1.41 -4.56,1.69 -0,-0.93 -0.73,-2.83 -1.72,-1.31 -1.02,-0.25 -2.56,-0.06 -1.38,1.13 -0.7,1.44 -2.8,1.17 -2.97,-0.5 -0.93,-0.24 -1.59,0.59 -1.84,-0.91 -0.54,-2.95 -3.74,-0.29 -4.78,-2.56 -1.76,-0.88 -2.04,2.67 -4.06,1.19 -0.83,-1.53 -3.41,-1.05 -2.44,0.88 0.79,1.99 -1.26,3.98 0.56,5.81 0.03,1.6 0.47,3.25 0.34,4.84 -1.21,1.42 -2.79,3.36 -1.75,5.31 0.7,2.08 0.5,4.36 1.34,6.41 0.4,1.57 0.16,3.51 1.53,4.66 -0.23,1.58 0.13,3.02 0.41,4.5 -0.72,2.52 -3.81,0.32 -4.94,1.81 -1.68,0.68 -1.55,2.84 -2,4.41 -1.1,1.4 -0.69,2.98 -2.06,4.03 -0.81,2.4 -0.14,2.65 -0.66,2.94 -0.65,0.74 -0.38,1.51 -0.98,2.11 -1.77,-1.05 -3.44,-0.63 -5.05,-1.86 -1.28,-1.9 -2.98,-1.97 -5.09,-2.16 0.99,2.76 -2.34,2.74 -4.16,3.59 -2.66,0.16 -2.99,3.08 -4.31,4.44 -2.35,0.63 -4.46,0.91 -7,0.75 -2.15,-0.63 -4.33,0.65 -6.25,1.56 -1.04,1.56 -1.14,-2.44 -2.03,0.06 -1.72,0.93 -4.03,1.19 -4.59,3.22 0.34,1.88 -0.7,4.08 -0.41,6.22 -1.94,0.02 -2.39,1.77 -3.16,2.88 -1.2,-0.61 -1.59,-1.83 -3.09,-0.47 -1.16,0.3 -2.43,-2.11 -3.06,0.22 0.15,3.01 -3.49,2.71 -5.16,2 -2.61,-1.24 -2.16,4.49 0.53,3.28 1.03,1.2 -1.51,0.54 -1.88,1.31 -1.01,-2.17 -4.45,0.91 -4.53,1.78 1.63,1.36 3.42,2.64 4.66,4.41 0.14,3.2 -5.02,-1.23 -4.06,0.81 1.77,0.74 4.56,3.3 5.41,0.84 3.12,-0.51 5,4.8 7.97,1.47 2.43,-0.5 2.6,-4.21 5.47,-3.41 2.69,0.13 5.46,-1.42 7.72,0.94 2.25,0.07 4.06,1.3 5.34,3.09 0.91,1.4 2.77,2.15 4,2.66 -2.49,0.83 -3.91,-1.92 -6.16,-2.31 -1.91,-0.02 -1.26,-3.91 -3,-2 -2.34,-0.79 -4.4,-1.45 -6.75,-0.44 -2.98,-0.51 -4.67,2.23 -3.22,4.84 1.49,2.66 -2.12,3.14 -3.22,4.47 1.94,1.83 5.66,0.78 7.81,2.78 2.09,1.48 3.33,3.8 5.13,5.5 3.1,3.69 -1.32,-2.24 -2.94,-0.13 -1.04,2.02 -1.04,4.6 -3.56,5.41 -0.99,1.76 -2.23,3.3 -1.94,5.44 -0.02,2.5 2.58,3.68 4.25,5.06 1.48,1.04 2.72,2.47 3.19,4.25 1.93,0.88 2.89,2.4 3.97,4.13 1.35,1.69 2.62,3.67 2.78,5.78 0.54,1.46 0.07,4.78 1.69,4.94 0.11,-0.77 -0.23,-3.25 0.53,-1.25 0.82,1.68 2.7,2.29 4.06,3.41 1.2,0.95 3.56,-0.2 2.69,2.06 2,0.84 5.25,-0.66 6.78,1.66 0.84,1.71 0.97,5.4 3.81,3.72 2.06,-1.27 3.2,2.06 4.59,1.56 0.61,-0.76 2.33,3.52 3.44,2.53 -0.14,-2.55 2.6,-3.23 4.53,-2.44 0.96,-0.72 2.22,-0.12 2.91,-1.78 1.71,-1.01 4.1,-1.13 6,-1.81 -0.43,1.18 -1.66,4.21 0.88,3.34 1.55,-0.59 2.76,-0.38 3.69,-1.53 1.96,-0.54 1.67,1.96 3.78,2.09 1.38,0.67 2.23,-2.19 3.78,-0.59 1.88,-0.77 2.8,-3.17 5.13,-3.38 1.55,-1.43 -2.67,-3.79 -3.03,-1.72 -2.47,-0.7 0.97,-3.66 -0.06,-5.28 -0.62,-1.47 -1.62,-3.73 0.66,-4.06 -0.38,-1.92 -0.88,-3.67 -0.78,-5.72 -0.4,-1.4 -2.26,-0.43 -1.13,-2.19 0.1,-1.5 -1.87,-2 -0.63,-3.56 -1.5,-1.8 -4.18,-4.05 -2.16,-6.5 -0.53,-1.57 -3.62,-1.66 -4.25,-3.81 -2.25,-1.31 0.41,-4.47 -2.78,-5.13 -0.94,-0.55 0.01,-0.98 -0.91,-1.69 0.93,-1.21 1.47,-1.08 2.26,-1.4 1.5,-0.57 2.53,-1.4 4,-0.34 1.92,0.34 3.87,-0.61 5.94,-0.19 1.85,-0.7 3.41,-2.43 2.94,-4.28 1.33,-1.58 3.84,-1.82 5.19,-0.47 2.04,0.28 2.19,-2.51 4.47,-1.56 2.07,-0.07 3.91,-1.32 6.06,-0.47 0.98,-0.69 4.56,-0.52 2.22,0.97 -1.16,1.22 1.28,1.45 1.94,1.66 1.06,-1.12 0.87,-3.69 3.13,-2.25 1.72,-0.1 -0.18,-2.92 1.53,-3.78 0.74,-1.38 1.73,-1.61 3.03,-1 0.6,-1.69 0.81,-4.03 1.09,-6 0.39,-2.25 1.51,-4.36 3.06,-5.84 0.04,-1.46 2.68,-2.26 0.69,-3.69 2.11,-1.35 0.62,-4.46 2.53,-6.06 1.44,-1.95 -1.95,-3.07 0.06,-4.81 1.39,-3.22 0.07,-3.16 1.1,-3.1 2.37,0.18 3.96,1.27 5.93,2.57 2.46,0.23 0.91,-2.42 0.06,-3.25 0.43,-2.12 2.06,-0.81 2.81,0.13 1.46,-0.48 1.8,-2.16 3.66,-2.03 1.24,-0.96 4.39,-0.87 4.25,-2.53 -2.08,-1.77 1.01,-3.58 2.34,-4.72 1.24,-0.44 2.28,-0.33 2.16,-1.91 1.51,-0.55 2.08,-2.63 3.22,-3.34 -0.56,-1.36 -1.11,-5.36 1.28,-4.28 1.16,1.48 -0.06,-2.45 1.66,-2.44 1.26,-1.13 -1.77,-3.23 0.09,-4.63 0.46,-1.77 -3.37,-1.8 -1.47,-3.91 1.34,0.27 2.45,-1.18 0.69,-1.66 1.71,-0.69 1.24,-3.36 3.56,-2.72 1.69,-1.55 -2.41,-1.71 -3.25,-2.47 -1.21,-1.93 -3.96,0.61 -4.84,-1.97 -1.01,-1.18 -1.91,-5 -3.88,-3.16 0.5,1.93 -2.54,0.03 -3.75,0.28 -1.39,-0.92 -2.78,-1.98 -2.78,-3.69 -2.14,0.23 -5.75,-0.97 -4.94,-3.72 -1.03,-2 0.43,-4.65 -1.47,-6.31 -0.97,-1 -2.34,-1.62 -3.72,-1.75 -1.82,0.73 -4.08,0.78 -5.25,2.59 -1.02,0.75 -2.36,0.73 -2.94,2.22 -1.69,-0.06 -1.5,3.19 -3.53,1.63 -1.68,-1.56 -1.6,0.2 -3.1,0.08 -0.03,-0.82 -0.32,-0.1 -0.12,-1.36 -0.24,-1.26 0.73,-4.38 -1.59,-2.94 -1.71,0.29 -3.1,-0.61 -3,-2.41 -0.79,-1.07 -0.57,-1.9 0.13,-2.75 -0.95,-1.08 -2.33,-2.44 -3.94,-2.47 z",
					    "region-25" : "m 131.33,90.22 c -0.1,-0.01 -0.2,0.01 -0.31,0.03 -2.07,1.53 -0.37,4.37 2,4.31 2.23,1.05 2.23,4.3 1.5,6.31 -2.49,1.68 -0.73,3.58 0.41,5.38 0.96,2.16 0.93,4.77 1.5,7.06 2.08,-0.34 2.6,2.06 4.31,3 0.39,-2.34 1.97,0.49 0.34,0.84 1.8,1.66 2.25,4.31 3.31,6.44 1.02,-0.52 2.93,-1.19 3.41,0.25 -3.06,-1.2 -2.53,3.85 -1.06,4.84 0.73,1.01 -2.29,2.18 -0.88,4 0.9,1.35 -0.83,3.99 1.22,4.78 -0.29,-1.98 3.58,-1.34 2.47,-0.94 -2.19,-0.32 -2.42,4.49 -0.94,5.53 -1.49,1.88 -0.81,4.79 -2.53,6.75 2.86,1.4 0.28,5.39 2.63,7.16 1.57,2.06 3.28,4.7 6.22,4.41 1.27,0.62 2.97,2.16 0.44,1.47 -2.01,-0.05 -3.98,1.29 -6.03,0.56 -1.76,-0.81 -2.47,0.59 -0.91,1.63 1.59,2.18 0.86,5.03 2.72,7.13 1.82,0.95 4.55,4.48 6.47,1.53 1.1,-1.94 3.71,-1.76 4.13,-4.25 2.92,-0.15 5.6,1.84 8.56,2.03 1.72,0.13 4.33,2.58 5.31,-0.25 1.6,-0.43 2.18,1.64 4.64,0.78 1.35,0.03 1.29,2.39 2.76,2.84 1.25,-0.81 1.25,2.88 2.91,0.85 -0.34,-1.52 0.41,-2.15 1.78,-1.59 1.44,-1.68 1.56,0.19 2.09,1.19 1.94,-0.76 4.31,-1.38 5.84,-3.09 1.96,-0.76 5.17,-1.36 7.31,0.56 0.86,-1.55 2.64,-2.22 3.84,-1.53 2.19,-0.69 -0.32,-3.61 2.41,-3.25 1.22,0.63 4.8,2.15 2.63,3.63 0.42,2.11 1.42,5 4.16,3.63 2.64,-0.54 -0.68,6.29 2.44,4 1.37,-0.32 3.43,2.21 3.94,-0.5 1.52,-1.02 2.55,-2.1 3.94,-2.88 0.13,-1.39 3.5,-1.72 5.06,-2.44 2.07,-0.26 4.59,1.13 5.28,3.13 -0.06,2.06 0.38,4.02 0.44,6.06 0.3,2.62 4.16,1.96 5.31,3.19 -0.15,2.4 3.74,4.17 5.78,2.94 2.1,-2.41 3.28,1.6 4.31,2.97 0.79,2.77 5.5,0.5 4.25,-1.69 -2.11,-1.04 0.14,-4.68 -2.47,-4.47 -0.11,-2.74 2.48,-3.47 4.63,-3.75 2.4,-0.8 4.73,-4.02 4.38,-5.88 -2.6,-1.75 2.03,-5.13 -1.28,-6.06 0.58,-2.87 -4.21,-1.68 -4.03,-4.59 -2.12,-0.59 0.3,-4.97 -3,-4.28 -0.97,-0.7 -0.32,-2.36 -2.09,-2.5 2.39,-1.14 1.58,-4.4 -0.72,-5.22 -1.46,-1.16 -4.51,-1.72 -4.59,-3.75 0.31,-1.19 -1.25,-2.23 -1.53,-3.09 -1.64,1.84 -3.89,0.06 -5.91,0.5 -1.87,-0.14 -3.8,-2.54 -2.31,-4.34 0.36,-0.64 0.58,0.08 1.19,-1.63 -0.17,-1.62 1.69,-3.89 -1.06,-4 -2.67,-0.46 -0.94,-3.18 0.38,-3.34 -1.98,-1.59 2.31,-4.07 -0.88,-4.56 -0.57,-1.85 0.6,-4.24 -2.09,-4.84 -1.63,-0.93 -0.88,-2.37 0.84,-2.38 1.89,-1.03 -0.49,-3.21 -1.69,-1.53 -1.75,1.03 0.44,-1.94 -1.28,-1.97 1.47,-2.14 -0.51,-4.56 -0.16,-6.97 -0.31,-0.85 -1.21,-0.51 -1.88,-0.5 -2.27,0.34 -4.7,0.99 -6.5,2.44 -1.26,1.74 -2.9,3.08 -4.88,3.94 -2.67,1.45 -5.6,2.57 -8.66,2.72 -1.57,0.68 -2.47,1.16 -3.78,-0.13 -2.28,-0.63 -4.34,-1.82 -6.47,-2.81 -2.03,-0.27 -4.08,-0.36 -6.09,-0.91 -1.82,0.2 -3.72,0.61 -5.59,0.16 -3.59,-0.37 -7.33,-0.44 -10.72,-1.81 -1.79,-1.87 -4.45,-1.13 -6.75,-1.16 -1.97,-0.42 -3.96,1.4 -3.34,3.41 0.03,1.19 -1.86,-1.57 -3.19,-1.13 1.82,-3.14 -1.03,-5.44 -2.84,-7.69 -1.07,-2.07 -3.58,-4.19 -2.53,-6.72 1.49,-0.46 1.59,-1.77 2.81,-2.53 0.64,-1.58 -0.91,-6.17 -3.88,-5.59 -2.22,-0.46 -4.6,-0.57 -6.75,0.28 -0.7,2.48 -3.39,2.48 -5.44,2.63 -3.16,0.33 -5.73,-2.16 -9.06,-2.06 -1.72,-0.12 -2.65,-2.59 -4.5,-1.56 -0.6,-0.28 -1.01,-1.03 -1.69,-1.09 z",
					    "region-54" : "m 220.11,259 c -1.83,1.36 -2.39,3.5 -2.09,5.47 -1.62,-0.38 -3.86,-0.7 -3.09,1.91 -0.6,1.04 -0.69,0.03 -1.63,0.25 -0.87,-0.96 -2.95,-0.24 -1.19,-1.94 0.94,-0.85 -0.02,-1.14 -0.78,-1.16 -1.9,1.4 -4.41,-0.8 -6.38,0.88 -1.77,0.1 -3.38,-0.03 -4.53,1.59 -1.1,-0.38 -2.37,0.66 -3.13,0.44 0.43,-0.68 1.31,-1.97 -0.38,-1.34 -1.39,0.15 -3.84,1.4 -2.47,3.03 -1.35,1.52 -2.84,3.5 -5.19,2.53 -2.04,1.17 -4.12,-0.02 -6.25,-0.16 -1,1.07 -5.15,1.37 -3.16,3.19 0.99,1.24 3.17,1.93 1.88,3.78 0.61,2.43 2.79,3.98 5.03,4.94 0.97,0.91 -2.04,3.97 0.75,4.66 0.24,1.6 2.44,2.55 1.41,4.22 0.87,0.83 1.52,1.78 0.84,2.78 2.6,1.36 0.57,4.61 2.16,6.69 -0.35,1.33 -2.77,1.22 -1.25,3.06 1.15,1.77 0.53,3.41 -0.38,5.16 -0.03,1.27 0.81,2.02 1.28,0.5 1.8,0.1 4.51,2.12 1.81,3.38 -2.52,0.17 -3.25,4.04 -6.13,2.63 -0.61,0.86 -1.5,0.87 -2.16,1.66 -0.15,-0.66 -0.54,-1.26 -1.44,-1.63 -1.04,-0.75 -2.84,-2.01 -3.28,0.09 -1.72,-0.29 -6.44,1.16 -4,-2.06 0.3,-0.52 -0.12,-1.17 -0.75,-0.88 -1.84,1.26 -4.74,0.41 -5.81,2.91 -3.26,0.02 0.77,5.14 -3.06,5.47 -1.82,1.05 -3.7,4.18 -2.19,5.84 3.16,-0.44 2.83,3.25 4.66,4.75 0.18,1.52 3.73,5.28 0.16,5.06 -2.63,-0.06 1.74,2.73 0.25,4.13 1.31,1.55 0.24,3.46 -1.38,3.28 -0.47,1.76 -2.35,1.76 -1.16,3.84 0.65,3.56 3.83,5.46 6.34,7.59 -3.27,-0.53 -4.87,-4.06 -7.22,-5.25 -3.39,-0.91 -3.86,2.38 -3.84,4.88 -0.67,3.03 2.89,0.24 3.72,2.81 2.22,1.16 4.24,2.77 6.34,4.09 1.78,2.01 2.91,4.4 5.78,5.19 3.78,3.01 6.99,7.11 7.78,12 0.56,3.54 5.83,1.95 6.97,1.47 0.01,4.14 4.06,2.04 6.41,3.25 2.17,2.13 0.32,5.42 2.06,7.81 0.55,1.04 2.17,-1.22 3.19,0.59 2.59,1.32 4.25,4.44 7.59,4.28 1.79,-0.22 2.74,-3.46 4.41,-0.78 1.6,0.17 0.6,-2.97 2.56,-3.41 -0.86,-1.27 -0.11,-1.48 0.29,-2.89 0.46,0.7 0.68,-1.05 1.55,-0.77 1.12,-1.93 3.28,-0.2 4.75,-0.25 1.32,-1.28 1.61,-3.13 3.19,-3.94 0.74,-1.56 3.64,-1.09 2.59,-3.53 -0.91,-1.87 -0.76,-4.09 0.22,-5.91 0.83,-1.03 1.82,-1.26 1.72,-2.66 2.14,0.73 3.02,-3.1 5.38,-2.09 0.34,-1.94 2.4,-3.25 3.38,-4.41 1.34,-1.83 -0.88,-4.57 1.38,-5.63 2.01,1.43 2.17,-1.86 3.34,-3 1.3,-1.48 1.93,-3.57 3.66,-4.59 2.06,-0.54 0.26,-4.35 3.13,-3.19 1.8,1.51 1.2,-2.15 2.63,-2.69 0.9,-1.93 -0.04,-3.83 0.5,-5.66 1.77,0.89 4.2,0.31 5.03,-1.66 0.94,-1.41 -0.51,-4.75 -2.38,-4.5 -1.22,0.39 -3.6,-2.28 -2.44,-3.84 -0.52,-2.27 -0.81,-2.05 0.4,-4.47 -0.69,-1.69 -3.03,-5.26 0.35,-5.56 0.85,-1.96 2.73,-3.74 4.97,-3.81 3.08,1.68 3.11,-2.44 4.09,-4.25 1.66,-1.63 4.57,1.31 5.22,-1.78 1.49,-0.33 3.43,-2.93 1.13,-3.88 -2.84,-0.91 -0.57,-4.31 -2.72,-5.72 -1.55,-1.59 -4.62,0.57 -4.75,-2.44 -1.74,-0.37 -3.68,-1.15 -4.75,-2.78 -1.09,-1.83 0.1,-4.21 0.5,-6.06 -0.12,-2.37 -2.82,-3.37 -4.03,-5.16 -1.17,-2.49 -1.79,-5.27 -4.5,-6.69 -1.72,-1.44 -1.28,-3.75 -1.78,-5.69 -1.15,-1.45 -3.05,-1.62 -4.16,-2.97 -3.22,-0.24 0.18,1.98 -0.31,3.25 -2.34,0.38 -5.37,-0.55 -7.13,1.63 -1.89,-0.2 -3.78,-1.28 -5.44,-0.03 -1.93,-1.75 -0.88,-4.6 -0.81,-6.91 0.33,-1.71 -2.65,0.44 -2.06,-1.69 -0.96,-0.9 -3.56,1.74 -3.84,-0.44 1.52,-1.61 0.24,-3.14 -1.44,-2.16 -0.41,-1.64 -1.84,-1.37 -2.91,-1.47 -0.25,-1.89 -1.73,-2.4 -3.03,-3.22 z m -68.97,61 c -1.76,0.06 -3.89,0.95 -2.03,2.69 2.45,1.55 5.98,0.45 8.22,3 1.27,1.33 6.26,1.63 3.41,-0.91 -1.66,-2.42 -5.97,-1.19 -6.94,-3.13 -0.71,1.19 -4.32,0.67 -3,-0.41 1.53,0.61 1.73,-1.01 0.34,-1.25 z m 4.28,13.72 c -0.39,1.9 1.91,3.6 0.91,5.69 1.13,2.53 4.43,3.24 5.47,5.94 0.77,1.92 1.8,6.42 3.22,2.22 1.27,-2.59 -0.1,-4.72 -1.84,-6.47 0.15,-2.4 -0.83,-4.49 -3.47,-4.56 -1.38,-0.97 -2.49,-2.6 -4.28,-2.81 z",
					    "region-72" : "m 247.98,356.31 -0.34,0.38 c -1.25,1.56 -2.08,5.44 -4.38,4 -1.12,2.06 0.64,6.19 -2.78,7.03 -0.72,1.93 -1.6,3.14 -3.66,3.22 -1.43,0.82 -1.88,2.66 -3.44,2 1.01,1.66 -2.35,1.6 -2.03,3.69 -1.23,2.3 1.52,4.81 -0.19,6.81 -2.94,0.32 -3.39,4.4 -6.03,5.34 -2.31,-2.11 -5.97,0.65 -6.22,3.19 1.69,0.92 -1.24,1.84 -0.78,2.83 -0.45,0.74 0.74,0.18 -1.44,1.3 -2.38,-2.83 -4.15,2.64 -6.97,0.16 -2.07,-0.72 -3.49,-3.22 -5,-3.41 -0.47,-1.38 -2.8,-1.36 -2.84,0.28 -2.21,-2.81 -0.46,-6.54 -2.5,-9 -2.12,-1.28 -6.83,0.96 -6.34,-3.09 -0.56,-0.81 -2.47,1.64 -3.91,0.5 -4.02,-1.34 -1.32,4.42 -1.47,6.59 0.58,4.02 0.28,9.09 3.91,11.78 1.46,0.51 5.55,1.77 4.44,3.09 -0.84,-1.43 -5.07,-1.89 -2.38,0.25 1.43,1.74 0.5,4.83 0.75,7.16 -1.4,-2.45 0.48,-6.18 -2.53,-7.81 -3.29,-2.45 -5.45,-6.24 -5.75,-10.34 -0.44,-5.63 -1.58,-11.97 -6.41,-15.56 -1.63,-2.01 -3.21,-4.12 -5.81,-4.88 -2.26,-1.42 -3.52,-3.71 -3.19,-6.16 l -0.44,-0.09 c -2.25,1.99 -3.57,5.08 -3.5,8.13 -0.48,6.34 -0.21,12.81 -1.81,19.03 -1.2,6.71 -1.29,13.54 -2.25,20.28 -0.55,4.81 -1.06,9.63 -1.28,14.47 1.23,-0.88 0.56,-4.8 2.59,-6.25 0.81,-2.73 2.87,-3.42 4.53,-0.78 1.78,1.59 5.08,5.73 0.47,5.78 -1.94,0.32 -4.77,-1.94 -5.13,1.38 0.08,2.79 -3.05,4.54 -1.88,7.41 -0.13,1.32 0.11,2.59 0.97,2.72 -2.19,2.2 -1.34,5.96 -2.16,8.81 -1.09,9.88 -3.29,19.6 -4.84,29.41 -1.98,7.87 -2.82,16 -5.06,23.81 -1.75,2.09 2.49,-2.46 -2.31,2.69 -1.68,1.56 -1.95,4.34 -4.28,5.25 -1.69,1.55 -7.66,0.47 -5.66,3.84 1.87,0.86 1.46,4.4 4.19,2.53 2.6,-0.58 2.29,2.17 3.09,3.53 2.76,1.38 2.09,-3.66 4.78,-2 1.78,1.78 5.84,-0.03 5.91,3.25 0.24,2.43 -0.82,4.75 -1.66,6.97 -1.29,1.67 -3.57,3.42 -1.06,5.31 1.51,1.31 5.28,2.06 4.59,-1.16 -0.71,-1.55 2.39,-4.33 2.69,-2.53 -2.06,1.66 0.02,4.03 2.16,3.69 2.46,-0.03 4.03,2.65 6.25,2.53 1.72,1.34 4.04,1.08 5.38,2.88 1.73,1.93 4.53,0.85 6.75,1.66 1.99,-0.16 4.83,-2.3 5.06,1.22 -0.81,2.07 0.72,3.45 2.66,3.66 1.79,1.33 2.97,3.13 4.19,4.84 0.76,1.05 1.54,2.13 2.47,0.38 1.16,-3.48 4.7,1.81 7,-0.81 1.19,-1.54 3.57,-1.59 2.63,-4.13 -1.03,-1.8 -0.58,-3.28 1.28,-4.13 -0.06,-1.84 -1,-4.36 1,-5.5 -0.26,-2.35 3.42,-0.39 2.38,-2.97 -0.31,-2.04 0.52,-3.45 2.38,-4.53 0.43,-1.68 1.01,-3.08 2.84,-2.84 0.96,-1.29 0.1,-2.98 1.75,-3.53 1.05,-1.34 1.17,-3.03 0.09,-4.31 -0.45,-2.45 2.49,-1.8 2.94,-3.19 -2.11,-1.84 0.02,-4.67 -1.59,-6.53 -0.58,1.27 -2.64,3.58 -2.38,0.72 -1.29,-2.3 2.86,-1.98 0.97,-3.94 0.18,-1.68 -0.42,-3.21 -2.28,-3.81 0.91,-3.32 -2.92,-1.3 -3.97,-2.97 -1.33,0.53 -3.1,0.49 -3.52,0.5 0.99,-1.03 0.2,-2.18 -1.07,-2.15 -0.4,-1.67 2.47,-2.42 1.25,-4.29 -0.26,-2.14 3.64,-3.06 1.81,-4.72 0.02,-1.67 -1.1,-3.6 0.81,-4.38 -0.22,-1.33 -0.28,-2.98 -0.09,-3.94 -1.71,-0.35 -2.36,-1.85 -0.34,-2.34 1.14,-1.91 3.98,-1.35 4.91,-1.5 1.19,-0.68 2.41,-2.18 3.22,-2.59 1.87,0.5 1.3,2.46 1.03,3.38 1.52,2.87 4.03,1.16 3,-1.5 0.39,-1.08 0.27,-2.2 0.22,-3.31 0.41,1.66 2.29,0.5 3.31,0.13 0.07,1.08 1.01,2.13 1.44,0.5 0.34,-1.77 2.7,-2.85 3.78,-1.09 1.32,0.59 2.76,1.17 3.5,-0.31 2.29,0.11 4.8,-0.64 5.97,-2.66 1.88,-1.17 4.15,0.59 5.63,-1.44 2.19,-1.4 2.87,4.16 4.66,2.53 0.43,-1.77 3.28,-1.54 2.94,-3.81 0.32,-1.72 2.96,-1.12 2.06,-3.19 1.14,-1.2 3.77,2.23 4.38,-0.28 1.24,-1.76 -3.17,-1.95 -0.81,-3.09 1.93,0.3 2.46,-1.56 2.53,-3.13 0.05,-1.54 1.51,-2.58 -0.28,-3.69 -1.98,0.07 -2.65,-1.75 -1.25,-3.06 -0.66,-1.59 0.89,-4.04 2.16,-1.84 1.2,1.74 3.19,-0.62 4.88,0.22 1.47,-0.35 0.02,-2.37 0.66,-3.41 -0.74,-1.17 -2.31,-1.84 -1.81,-3.5 -0.48,-1.52 -0.18,-3.08 -1.47,-4.38 -0.18,-1.56 2.06,0.03 2.59,-1.47 0.98,-1.03 1.57,-1.58 2.28,-1.19 0.06,-2.42 3.42,-3.32 2.47,-6.13 2,-1.12 4.37,-1.45 5.84,-3.31 1.66,-0.91 2.36,-2.68 1,-4.38 -0.12,-2.03 4.05,-0.97 3,-3.63 1.33,-0.95 3.2,-1.67 3.34,-3.25 -2.18,-1.13 1.1,-2.93 -0.59,-4.41 -0.62,-1.56 -0.83,-3.43 0.72,-4.22 -0.86,-1.85 -2.53,-3.95 -2.31,-5.84 2.69,-1.69 -2.98,-1.93 -4.16,-2.16 -1.37,-0.3 -2.36,-1.78 -0.66,-2.38 0.85,-2.22 -4.19,-0.98 -1.81,-3.19 1.6,-0.51 1.96,-2.22 -0.06,-2.44 -1.52,-0.87 0.21,-2.7 -0.03,-4.03 1.56,-0.49 2.9,-2.44 3.59,-3.75 -0.89,-0.68 -4.19,-1.16 -2.03,-2.72 1.63,-1.41 -2.41,-0.91 -2.47,-2.47 -2.02,0.61 -2.38,-1.49 -4.38,-1.13 -1.27,-1.52 3.38,-3.7 0.06,-4.47 -2.98,1.52 -4.08,-2 -4.81,-4.22 -2.35,-1.05 -5.42,1.51 -6.94,-0.94 -0.7,1.49 -2.13,4.21 -3.44,1.81 -3.87,-0.26 0.41,-4.54 -2.06,-5.84 -1.62,-1.4 -4.46,0.29 -5.78,-1.44 z",
					    "region-73" : "m 289.48,399.97 c -1.78,0.39 -2.93,2.06 -4.78,2.22 -1.23,1.62 0.08,3.58 0.59,5.22 -0.62,1.03 -1.19,1.98 0,3.09 0.18,1.1 -1.75,1.01 -1.91,2.28 -1.5,0.17 -1.62,1.3 -1.78,2.63 -1.56,-0.12 -3.75,1.63 -1.81,2.97 0.48,1.24 -1.14,2.21 -1.53,3.19 -1.79,0.31 -2.39,2.67 -4.56,2.38 -2.48,0.13 -0.93,2.86 -2.16,3.97 -1.67,0.34 -1.51,2.49 -2.09,3.19 -1.96,-0.06 -3.04,2.91 -4.63,1.81 0.3,1.56 1.42,2.97 1.28,4.72 0.12,1.32 0.69,2.67 1.84,3.41 -0.23,1.58 0.34,3.51 2.06,1.94 -0.52,1.94 -4.36,2 -4.78,1.84 -1.31,0.31 -3.13,1.71 -3.41,-0.56 -1.85,-1.31 -1.55,1.91 -1.84,2.97 -1.51,2.17 2.33,1.52 2.56,3.22 0.14,1.45 -1.01,2.72 -0.91,4.22 -0.18,1.5 -1.62,1.79 -2.72,1.91 -0.4,1.36 2.31,1.1 1.28,2.88 -0.69,2.88 -3.06,-1.07 -4.31,0.63 0.27,1.88 -2.73,1.72 -2.47,3.84 0.52,1.2 -3.87,3.7 -4.14,3.52 -0.79,-1.18 -1.54,-3.12 -2.98,-3.55 -1.29,2.88 -5.51,-0.05 -6.5,2.81 -2.1,1.77 -4.75,1.23 -6.78,2.72 -2.08,0.01 -3.66,-3.12 -5.28,-0.69 -0.65,1.86 -1.85,2.55 -2.44,0.63 -2.23,0.44 -3.97,2.37 -2.44,4.63 0.2,3.15 -4.15,0.85 -4.06,-0.78 1.98,-1.15 -1.29,-3.91 -1.88,-1.47 -1.36,0.88 -2.15,2.44 -3.75,1.44 -1.57,0.41 -4.15,1.3 -4.19,2.91 0.97,-0.06 2.75,1.66 1.16,2.06 0.79,1.55 0.47,3.46 -0.69,4.13 -0.33,1.98 2.18,4.35 -0.41,5.44 -1.98,1.42 0.4,4.43 -2.41,5.47 -0.36,1.6 2.13,0.81 1.47,2.47 1.11,1.33 3.17,-0.5 4.56,0.81 3.53,-0.65 2.56,2.45 3.72,2.69 1.77,0.93 0.4,3.31 1.84,4.38 0.55,1.29 -2.76,1.06 -1.72,3.06 0.25,0.94 0.47,1.81 1.19,0.53 0.58,-2.18 2.66,-0.96 1.94,0.88 -0.78,1.76 0.67,3.33 0.88,4.81 -1.18,0.79 -3.45,1.09 -2.97,3.25 1.84,0.97 0.48,2.72 -0.19,4.03 -1.24,0.64 -1.12,1.94 -1.22,3.13 -0.94,1.24 -2.53,-0.25 -2.72,1.72 0.07,2.18 -3.14,2.41 -2.66,4.5 -0.68,1.38 0.98,2.94 -1.25,3.19 -1.81,-0.68 -0.81,2.21 -2.5,2.44 -0.96,1.75 1.59,4.41 -1.16,5.25 -1.17,1.23 0.37,3 0.22,4.56 0.8,1.85 3.22,1.79 4.31,3.38 0.8,1.59 2.24,-0.1 3.03,0.34 -0.62,1.62 1.47,2.54 1.69,4.03 0.86,0.9 2.3,1.13 2.69,2.41 1.83,1.45 3.76,-0.36 5.63,-0.56 1.93,-0.42 3.77,-1.29 5.69,-1.72 1.44,0.78 3.78,0.96 3.81,3.06 2.26,2.18 2.07,-2.6 4.38,-2 1.13,1.17 3.67,3.04 4.84,0.91 0,-0.09 0.01,-0.14 0,-0.22 1.66,1.72 4.89,-0.05 7.28,0.72 3.26,1.27 1.96,-3.09 1.03,-4.38 0.62,-1.99 -0.27,-6.24 2.88,-6.16 1.7,0.86 4.25,1.67 5.75,1.13 2.43,0.47 -6.68,-2.26 2.69,2.09 1.28,1.78 3.02,-0.35 4.47,1.25 1.71,0.48 3.77,0.11 5.28,1.22 1.52,0.96 0.79,4.16 3.22,3.75 1.81,-0.79 3.73,-0.26 5.63,-0.22 2.02,-0.71 2.59,1.65 3.84,2.53 1.12,1.34 1.04,3.24 2,4.59 1.28,1.48 2.36,-0.42 1.84,-1.72 0.69,-1.31 2.64,-0.57 3.97,-1.09 1.28,1.07 2.69,2.2 4.59,1.91 1.34,0.06 3.87,0.02 3.25,1.91 1.39,1.64 3.87,0.79 5.59,0.41 0.57,-1.18 1.04,-2.03 2.44,-1.44 2.19,-0.08 1.96,-2.41 3.34,-3.31 1.93,0.29 3.79,-0.92 5.78,-0.66 2.41,1.1 1.96,-2.39 0.13,-2.72 -1.56,-0.61 -2.09,-3.47 -3.94,-2.56 -1.44,1.17 -3.68,1.47 -5.16,0.19 -1.07,-0.5 -1.37,-1.29 -0.84,-2.25 -0.1,-1.78 -3.16,-1.91 -2.41,-3.56 0.61,-1.93 2.82,-1.16 4.25,-1.81 1.6,-0.65 1.67,-3.23 0.63,-4.41 -0.97,-0.41 -2.69,-1.29 -0.81,-2 2.76,-0.51 0.39,-3.41 1.31,-5 -0.68,-0.84 -2.9,-1.36 -1.25,-2.59 -0.05,-1.47 -0.57,-4.86 -2.63,-3.34 -0.79,0.58 -0.85,-2.15 -2.25,-1.41 -2.03,-0.09 -3.75,-1.13 -5.19,-2.44 -2.44,-0.46 0.31,-2.66 -1.41,-3.88 -1.53,-2.41 0.36,-2.48 0.41,-4.56 0.95,-0.61 0.19,-3.04 2.38,-2.38 3.88,1.33 0.46,-3.77 3.28,-4.97 0.71,-2.95 3.01,-0.1 2.94,1.59 0.84,-2.74 2.96,-1.33 4.81,-1.25 1.61,-1 0.87,-1.27 1.72,-1.16 0.99,1.3 1.91,3.3 3.94,1.97 1.54,-1.93 2.46,0.42 3.75,0.94 0.93,-1.18 0.32,-4.6 2.59,-4.31 1.41,0.67 3.34,0.92 4.75,2 1.78,0.44 3.29,-1.41 5.16,-0.91 1.54,0.64 3.33,1.48 4.91,0.41 1.22,-0.65 2.62,-2.15 3.16,-2.66 -0.33,-1.9 0.47,-4.11 -1.59,-5.38 -0.53,-1.92 -0.31,-3.93 0.59,-5.88 -0.09,-1.86 1.73,-0.33 2.84,-0.56 1.58,0.89 2.6,3.13 4.44,1.25 7.47,-3.19 5.08,-6.79 10.94,-4.25 2.15,-0.16 -0.17,-3.51 1.41,-4.88 -2.07,-2.25 0.27,-5.84 2.84,-3.47 2.56,1.39 6.38,-0.17 5.06,-3.28 1.23,-2.77 5.89,-0.36 5.28,-4.53 0.37,-2.38 6.06,-3.89 3.09,-6.44 -1.72,-1.06 -3.87,-0.95 -4.75,-2.59 -2,1.51 -3.18,-2.51 -0.38,-2.16 0.69,-1.75 0.95,-3.62 2.63,-4.69 -0.85,-3.72 -6.52,0.51 -7.06,-1.34 1.8,-2.6 -2.67,-2.63 -2.94,-4.34 -3.22,0.42 1.61,-3.78 -0.91,-5 -1.34,-2.93 1.78,-5.96 -0.75,-8.47 -2.48,-1.5 -1.86,-4.04 -1.69,-6.31 -1.66,-2.01 -3.31,-4.06 -5.13,-5.97 -2.19,-1.65 -1.11,-4.87 -2.22,-6.81 1.11,-1.31 0.68,-2.21 -1.06,-2.03 -1.82,-1.66 -0.62,-6.97 -4.41,-5.13 -3.08,2.23 0.69,-4.53 -2.69,-4.41 -2.14,1.63 -3.73,3.58 -5.5,5.09 -0.63,2.34 -1.06,4.47 -2.66,6.13 0.54,2.68 -1.95,3.69 -2.91,5.75 -0.72,3.27 -5.19,2.38 -7.34,1.69 -0.99,-2.01 -4.93,-0.47 -5.59,1.09 -1.77,1.5 -0.38,0.87 -2.13,0.13 -0.5,-1.43 1.01,-4.31 -1.52,-4.32 0.01,-1.34 1.13,-3.07 0.78,-4.75 2.27,-2.31 -1.49,-4.36 -2.44,-6.41 -1.64,-1.56 0.95,-3.19 -0.75,-4.47 0.04,-1.98 -1.5,-3.91 -3.63,-2.78 -1.3,0.58 -2.94,2.17 -3.41,-0.03 -1.69,-0.06 -2.56,2.18 -4.22,2.72 -0.83,0.81 -1.65,0.91 -2.34,0.28 -1.65,0.66 -1.8,-2.72 -3.47,-2.88 -0.92,-1.46 -2.12,-2.77 -3.53,-3.69 -1.38,-0.89 -3.01,0.06 -4.22,-0.31 -0.19,-0.27 -0.01,-0.7 -0.44,-0.56 z",
					    "region-91" : "m 373.48,405 c -1.15,1.06 -2.74,1.92 -4,2.63 -0.69,-0.64 -1.69,-0.79 -1.31,0.47 -1.53,0.76 -0.12,2.63 -1.88,3.19 -2.01,2.09 -2.23,-3.14 -4.09,-1.34 -1.31,1.13 -0.06,3.41 -1.69,4.16 -1.69,0.94 -1.26,2.84 -1.72,4.34 -0.97,1.48 0.22,3.28 -1.63,4.28 0.03,1.5 -1.96,3.13 -0.38,4.38 0.87,1.51 2.11,2.71 3.34,3.91 1.23,1.55 -0.59,3.54 0.25,5.22 1.19,0.89 2.58,1.88 2.81,3.5 -0.01,1.82 -0.64,3.51 -0.66,5.34 0.39,1.6 2.04,3.35 0.25,4.88 -0.7,0.91 0.02,1.97 0.78,0.94 0.68,0.58 0.48,2.1 2,1.88 1.21,0.4 2.29,1.44 1.19,2.63 0.66,2 3.45,-0.86 5.09,0.06 1.99,-0.31 1.2,2.35 2.99,2.61 1.32,3.93 1.53,-3.89 -2.64,0.71 -0.62,1.58 -0.36,3.76 -2.66,3.78 -0.55,1.53 1.6,1.9 2.22,1.31 0.87,2.49 4.92,1.11 5.56,4.16 -0.53,2.64 -5.31,3.38 -3.91,6.34 1.76,0.54 0.25,-0.92 -1.44,1.63 -1.75,0.05 -4.9,0.28 -4.13,3.06 0.95,2.61 -3.7,2.77 -5.44,1.78 -1.4,-1.16 -3.23,-1.06 -3,1.19 -0.18,1.32 1.22,2.9 -0.16,4.13 0.62,1.44 0.83,4.08 -1.5,2.91 -1.9,-1.31 -4.86,0.21 -4.97,2.34 -1.72,1.38 -4.21,1.09 -5.84,2.59 -2.33,1.39 -3.19,-2.96 -5.88,-1.81 -1.89,1.46 -1.49,4.44 -1.28,6.38 1.29,1.33 2.43,2.57 1.31,4.41 1.26,2.54 -3.84,3.1 -3.34,5.13 -1.15,-1.19 -3.34,-0.8 -4.78,-1.72 -2.41,-0.21 -4.21,2.13 -6.38,0.19 -1.15,-1.01 -2.84,-0.41 -3.88,-1.34 -2.13,0.57 -0.52,5.91 -3.13,3.75 -1.18,-2.85 -4.84,2.33 -5.84,-1.22 -0.72,-2.31 -2.45,1.37 -4.09,0.03 -1.54,-1.46 -2.34,0.39 -3.25,1.31 -0.23,-2.27 -2.22,-3.93 -3.16,-1.34 -0.87,0.24 -0.12,1.72 -1.22,2.06 0.19,1.45 0.77,3.36 -1.5,2.78 -1.58,-0.53 -2.15,0.65 -2.03,1.84 -1.91,1.64 -1.45,4.24 -0.22,6.19 -1.51,2.59 2.29,3.12 3.91,4.44 1.21,1.16 1.86,-1.13 2.63,0.28 0.85,0.87 1.08,1.72 2.47,1.06 2.01,0.75 2.1,4.05 1.22,5.03 1.15,0.71 2.39,1.6 1.5,3.22 0.51,1.05 0.44,2.72 0.88,3.41 -0.81,-0.18 -3.4,-0.4 -2.44,1.09 2.63,0.22 2.7,4.55 0.47,5.38 -1.52,0.14 -4.84,0.49 -3.84,2.72 1.13,0.78 3.35,2.2 1.94,3.69 1.87,2.17 4.6,1.89 6.78,0.47 1.87,0.67 3.2,2.93 4.91,4.19 0.34,0.39 0.23,1.54 -0.16,1.71 -0.99,0.41 -0.79,-0.53 -2.06,-0.05 -1.57,0.09 -3.05,0.46 -4.56,0.84 -1.73,-0.34 -1.73,2.75 -3.53,2.94 -1.28,-0.07 -2.45,0.32 -2.94,1.56 -1.36,0.64 -3.04,0.25 -4.34,1.16 -1.36,0.9 -1.71,2.73 -1.56,4.25 0.86,1.46 2.93,0.76 4.28,1.34 1.65,0.37 2.29,2.34 4.06,2.41 1.43,-0.11 2.32,0.89 2.38,2.25 0.19,1.48 0.68,3.18 2.19,3.81 1.13,0.44 2.45,0.21 3.5,-0.34 1.24,-0.79 1.71,-2.26 2.66,-3.31 1.39,-1.04 3.28,-0.07 4.75,-0.91 1.22,-0.79 2.49,-0.04 3.63,0.5 1.48,0.81 3,1.56 4.59,2.09 1.32,0.67 1.66,2.4 3.09,3 1.2,0.95 2.83,0.9 3.41,-0.69 1.34,-0.63 2.86,1.1 4.44,0.88 2.15,-0.12 -1.26,-2.72 0.69,-3.56 1.27,-0.56 2.54,-2.05 4.03,-1.25 1.72,0.59 2.72,-1.31 3.94,-2.13 1.15,-1.32 3.17,0.14 4.03,-1.41 0.83,-1.27 1.97,0.63 3.13,-0.16 2.01,-0.88 2.4,1.56 3.75,2.34 1.27,0.46 3.17,0.43 4.25,-0.38 -0.27,-1.45 -1.39,-2.71 -2.25,-3.91 -0.28,-1.72 -2.71,-1.85 -2.88,-3.63 -0.57,-2.26 -0.41,-4.65 -1,-6.91 -1.47,0.73 -1.9,-2.93 -0.31,-1.5 1.18,0.06 0.41,-2.1 0.75,-2.97 0.09,-1.49 0.11,-3.02 -0.31,-4.47 -0.95,-1.13 -3.85,-0.58 -3.44,-2.72 0.37,-0.79 0.15,-1.5 -0.34,-2 1.82,0.97 2.4,-1.32 2.84,-2.66 1.53,0.97 2.52,-0.67 1.16,-1.78 -1.63,-0.06 -2.17,-3.44 -0.28,-3.03 -1.3,1.16 0.14,3.3 0.81,1.09 0.3,-2.15 1.06,-4.18 1.75,-6.13 -1.37,-0.71 -2.48,-2.27 -1.53,-4.09 1.34,-0.99 2.06,0.84 0.72,1.34 0.45,2.19 2.18,0.9 2.38,-0.59 1.25,-2.32 3.42,-4.23 3.92,-6.8 1.24,-0.61 0.49,0.33 1.8,-0.76 1.74,-1.58 3.52,-3.11 5.56,-4.28 2.08,-1.06 5.08,1.35 5.97,-1.84 1.13,-1.74 2.55,-3.34 3.97,-4.84 1.92,-0.8 3.82,-1.55 5.34,-3.03 1.04,-0.77 4.25,-2.56 3.41,-3.19 -1.77,0.69 -2.88,2.98 -5.03,2.66 1.32,-1.08 3.93,-1.46 4.38,-3.59 0.26,-2.07 3.22,-1.88 3.78,-3.94 1.83,-0.89 3.8,-1.45 5.59,-2.44 1.64,-0.59 3.36,-1.3 4.81,-0.13 0.05,-0.76 -0.55,1.67 -0.09,2.28 2.02,1.25 0.61,4.53 2.94,5.5 2.92,2.1 1.98,-3.04 4.66,-2.88 1.75,-0.09 1.41,-1.81 1.59,-2.72 1.58,1.9 3.94,-1 5.06,-1.97 2.26,-0.22 2.56,-2.11 0.22,-2.34 -0.33,-2.07 2.01,-4.12 3.13,-5.5 1.84,-1.43 4.52,1.85 5.5,0.22 -1.01,-2.28 0.78,-4.15 1.44,-6.22 7.8e-4,-1.45 -0.24,-2.77 0.19,-4 -1.54,-1.58 2.66,-2.15 3.16,-3.78 1.09,-1.96 4.33,-2.35 4.06,-5.09 3.05,-0.25 -0.38,-2.8 -0.88,-4.22 -0.73,-1.79 -2.11,-2.02 -3.5,-2.47 -1.24,-1.93 0.7,-4.01 -0.09,-6.03 -0.11,-1.52 -0.56,-2.29 -1.94,-2.72 -0.09,-3.19 -3.04,-4.48 -5.5,-5.88 -0.85,-1.95 -5.4,-3.24 -4.56,0.22 -0.31,2.78 -4.11,0.64 -2.53,-1.5 -0.78,-2.43 -5.24,0.56 -5.03,2.59 -1.74,4.01 -4.07,-2.31 -6.63,-1.66 -0.17,-3.42 -6.06,1.94 -4.22,-2.25 0.89,-1.46 -1.23,-2.75 0.59,-3.78 -1.48,-1.1 -0.81,-3.1 -3,-3.5 -0.72,-0.11 -0.38,-1.61 -0.97,-3.91 -0.53,-1.76 -1.01,-3.64 -2.78,-4.28 -0.89,-1.53 -0.87,-3.26 -1.38,-4.88 -0.57,-1.51 -0.79,-3.12 -0.97,-4.63 0.86,-1.54 -2.63,-1.36 -1.38,-3.03 -0.77,0.01 -1.76,0.71 -1.69,-0.72 -1.09,-0.89 -1.88,-1.9 -2.41,-3.16 -0.97,-0.98 -4.72,1.23 -3.53,-1.13 0.36,-2.46 -4.24,-2.88 -3.41,-0.06 0.11,2.29 -2.55,0.74 -3.84,1.78 -1.38,2.1 -2.54,-0.84 -2.97,-2.16 -0.49,-1.59 -1.45,-3.11 -1.5,-4.81 0.52,-1.64 -1.5,-1.84 -2.16,-2.69 z",
					    "region-24" : "m 287.08,142.25 c -2.37,0.57 1.22,3.96 -1.47,4.66 -1.92,0.36 -4.9,2.34 -3.34,4.5 -0.05,2.87 -3.41,2.19 -5.41,2.66 -0.67,-1.12 -2.1,0.53 -3.09,-0.63 -1.43,0.4 -3.07,-2.56 -3.03,0.22 0.1,2.49 -3.8,-0.64 -3.88,2.19 -2.05,0.03 -3.85,1.15 -5.66,1.44 -2.16,-1.19 -1.85,2.14 -3.91,2.25 -1.02,0.93 0.19,3.18 0.09,4.13 1.27,1.02 1.45,3.18 3.56,3.09 1.58,0.76 1.01,2.47 2.66,3.09 -0.63,1.17 -0.32,2.65 -1.28,3.53 0.28,1.18 2.64,1.89 0.84,3 -0.7,2.66 -3.31,4.78 -6.03,5.03 -2.13,-0.37 -3.5,3.03 -1.19,3.56 -1.23,2.13 1.27,3.55 1.19,5.47 -2.6,1.83 1.89,3.04 3.25,3.41 1.88,1.2 -0.06,1.79 -1.34,1.75 -0.37,2.06 -1.7,1.58 -0.97,3.78 -1.55,-0.17 -2.95,1.3 -1.44,2.66 2.9,0.31 -0.83,3.65 1.5,5.13 0.09,1.68 -2.42,1.94 -1.44,4.03 -0.59,0.43 -2.04,-1.83 -2.47,0.22 -0.2,1.62 1.53,3.9 -0.56,4.75 -0.84,1.32 -2.23,2.39 -2.63,3.63 -2.15,0.21 -4.86,2.49 -4.44,4.44 0.43,0.52 0.91,0.21 1.34,-0.13 -0.21,0.37 -0.18,0.94 -0.56,1.22 -0.49,0.61 -1.15,1.02 -1.94,0.94 -0.73,0.28 -1.18,1.18 -2.09,0.97 -0.78,0.12 -1.32,0.87 -2.19,0.72 -1.08,-0.1 -0.54,1.4 -1.44,1.53 -1.15,0.5 -1.61,-0.95 -2.41,-1.41 -0.58,0.14 -1.02,0.96 -1.09,1.47 0.83,0.58 1.51,1.58 1.56,2.56 -0.48,0.61 -1.22,1.04 -1.91,0.44 -0.98,-0.36 -1.45,-1.59 -2.63,-1.5 -0.84,0.07 -1.45,-0.45 -2.09,-0.88 -0.56,-0.34 -1.35,0.01 -1.09,0.75 0.12,0.69 0.03,1.44 -0.59,1.84 -0.39,0.67 -1.15,1.64 -0.66,2.41 0.32,0.32 1.13,0.32 0.84,0.97 -0.12,1.97 -2.06,3.41 -1.78,5.5 0.17,0.79 -0.19,1.47 -0.81,1.94 -0.35,0.52 0.2,1.29 0.63,1.53 -0.44,0.9 -1.76,1.38 -1.56,2.53 -0.28,0.83 -1.41,0.84 -1.59,1.78 -0.39,0.87 -1.31,1.61 -1.06,2.66 -0.79,1.23 -0.55,2.78 -0.75,4.16 -0.38,0.45 -0.96,1.17 -0.31,1.66 0.19,0.92 -0.85,2.02 0.09,2.81 0.5,0.04 0.6,0.46 0.63,0.91 -0.02,0.81 0.99,1.05 1.31,0.31 0.4,0.04 1.18,0.16 1.31,0.63 -0.27,0.86 0.83,1.17 1.38,0.66 0.37,-0.34 0.78,-0.44 0.84,0.19 0.3,0.63 0.64,1.4 -0.06,1.91 -0.47,0.31 -0.53,1.35 0.25,1.03 0.44,0.03 0.69,0.75 1.19,0.28 0.53,-0.55 1.39,-1.22 2.13,-0.66 0.09,0.45 -0.18,1.54 0.63,1.31 0.46,-0.17 1.16,-0.59 1.38,0.13 0.27,0.54 0.28,1.22 -0.13,1.66 -0.28,0.58 0.32,1.14 0.19,1.66 -0.7,0.61 0.03,1.43 -0.13,2.19 -0.13,0.77 0.3,2.24 1.31,1.91 0.74,-0.22 1.17,-1.35 2,-0.75 0.91,0.12 1.83,0.91 2.75,0.72 1.28,-1.37 3.28,-1.71 5.09,-1.53 0.69,-0.15 1.83,0.35 2.28,-0.34 0.16,-0.99 -1.49,-0.86 -1.28,-1.88 -0.03,-0.34 -0.61,-0.89 0.06,-0.91 0.68,0.02 1.62,-0.41 2.19,0.09 0.16,0.78 0.83,1.06 1.53,1.16 0.47,0.73 1.82,0.34 1.91,1.38 0.57,1.39 0.36,2.94 0.78,4.34 0.72,0.79 1.2,2.08 2.31,2.38 0.66,-0.13 0.02,0.95 0.75,0.88 0.33,-0.02 1.1,0.07 0.63,0.5 -0.28,0.75 0.95,0.75 0.81,1.5 0.13,0.88 0.23,1.77 0.81,2.44 0.16,0.88 1.05,1.52 1.75,2 0.1,0.01 -5.98,-1 1.72,1.5 1.57,1.48 0.23,3.35 0.38,5.03 -1.08,1.82 -0.11,3.59 1.5,4.63 1.38,1.19 3.72,0.81 4.06,2.91 1.98,0.12 4.08,0.24 5.09,2.31 -0.26,1.88 -0.16,3.88 2.03,4.69 2.24,-0.13 -0.77,2.82 -0.03,3.5 1.32,-1.24 1.46,2.16 2.88,0.38 1.41,0.23 2.93,0.06 3.28,-1.41 2.3,-0.94 2.93,2.57 4.69,2.97 1.35,-1.69 3.16,-3.13 4.47,-4.81 1.27,0.09 0.91,2.97 2.47,1.19 1,-0.78 2.14,-1.36 1.97,0.41 1.06,2.68 2.68,-2.88 3.69,-0.03 1.94,1.77 2.64,-1.99 2.59,-3.22 2.22,-1.29 3.19,2.69 5.5,0.97 1.64,-0.66 3.21,0.27 4.94,-0.09 1.88,0.55 4.24,2.05 6.03,1.19 2.03,-0.39 1.38,-0.9 2.66,-0.44 2.26,0.05 5.32,0.81 5.34,-2.44 0.72,-1 2.01,-0.74 1.97,-2.56 1.67,-1.97 4.64,-0.98 6.78,-1.97 2.22,1.06 6.5,-0.37 5.38,-3.34 -1.23,-1.26 -1.47,-1.98 -0.47,-3.44 0.08,-1.16 -1.93,-1.56 0.06,-2.16 1.35,0.35 1.8,0.42 1.47,-1.25 2.2,-0.16 3.01,-3.8 5,-3.91 0.84,1.57 2.08,1.88 3.34,0.69 2.68,0.17 3.31,-3.16 5.63,-3.94 1.82,-1.28 5.05,0.88 5.66,-2.19 1.43,-2.02 -0.17,-4.15 0.13,-6.19 1.46,-1.86 -0,-3.73 0.59,-5.75 0.92,-2.7 -3.55,-3.59 -1.91,-6.41 -0.1,-2.89 -1.24,-5.6 -2.13,-8.31 0.53,-2.38 -1.6,-3.77 -3.28,-5.03 -3.42,-1.42 -0.39,-4.41 0.28,-6.66 1.22,-2.05 -0.14,-4.06 -1.06,-5.91 -1.79,-1.48 -2.93,-3.67 -1.59,-3.83 1.51,-0.53 3.38,-0.55 4.87,-0.83 -0.4,-1.72 -2.02,-3.65 -0.88,-5.78 -1.47,-1.35 -2.38,-3.98 -4.19,-4.28 -0.84,-2.52 1.25,-3.54 3.38,-3.25 1.7,-0.71 5.73,-1.19 3.97,-3.75 1.11,-1.31 0.7,-2.27 -0.59,-3 0.09,-2.52 2.74,-3.46 4.34,-5.16 2.49,-1.47 0.35,-4.35 0.53,-5.81 -2.16,-1.8 -3.41,-4.21 -4.19,-6.75 -2.19,-1.4 -4.9,-2.39 -7.25,-0.59 -1.4,1.83 -3.3,0.68 -2.72,-1.22 -2.2,-0.29 -2.54,2.59 -4.91,2.69 -1.57,0.29 -3.07,-1.32 -4.78,-0.63 -2.24,-0.9 -4.24,1.33 -6.47,0.31 0.78,-1.05 1.74,-2.43 2.84,-2.47 0.77,-2.05 0.77,-4.77 -1.78,-5.47 -2.81,0.03 -1.68,-2.89 -2.97,-4.34 -2.08,1.48 -3.79,-2.48 -5.13,0.38 -0.94,-0.72 -2.49,1.6 -2.25,-0.72 -0.16,-0.79 -0.99,-1.01 -1.63,-1.28 -1.65,1.48 -2.18,3.73 -4.78,2.38 -1.48,1.36 -3.64,1.18 -5.08,1.73 -1.14,-0.85 -2.55,-1.62 -0.64,-3.23 -0.54,-1.83 1.02,-5.17 -1.84,-5.28 -1.23,-0.49 1.24,-2.71 -0.91,-2.75 -2.16,1.54 -3.77,-1.07 -5.47,-1.88 -1.34,-1.71 -0.35,-3.89 -1.28,-5.66 -0.82,-1.34 -3.98,-0.35 -2.69,-2.81 -0.01,-0.99 -3.03,-0.4 -2.97,-2.28 -1.17,-0.9 -2.23,-2.16 -2.16,-3.38 -2.3,-1.28 3.11,-4.05 -0.34,-4.81 -1.59,-1.53 0.22,-3.8 -0.38,-5.47 0.09,-1.23 -2.38,-1.48 -1.19,-2.81 -0.68,-1.66 -1.82,-3.42 -3.63,-3.38 z",
					    "region-23" : "m 285.05,67.41 c -1.74,1.16 -3.94,-0.1 -5.28,2.16 -2.29,2.35 -4.85,4.56 -8.03,5.59 -2.34,1.39 -4.9,2.39 -7.66,2.22 -2.35,0.61 -4.59,1.65 -6.97,2.19 -3.55,1.43 -7.66,0.45 -11.06,2.44 -2.95,1.51 -5.58,3.64 -8.75,4.69 -1.51,1.33 -3.19,2.27 -5.16,2.72 -1.86,1 -4.4,1.34 -5.13,3.66 -0.75,3.04 -2.14,5.81 -3.56,8.59 -1.79,2.24 0.52,4.61 2.72,5.16 1.7,0.51 3.4,0.34 5.13,1.25 3.58,0.81 7.28,-0.28 10.44,-1.97 1.79,0.89 2.85,0.22 0.53,0.06 -1.88,0.87 -3.29,2.63 -5.47,2.88 -1.89,0.2 -4.84,0.55 -3.34,3.19 -0.14,1.72 1,3.52 0.38,5.06 0.52,0.98 -0.45,2.93 1.22,1.53 2.41,-1.27 2.66,2.55 0.25,2.53 -2.27,1.97 3.92,2.2 1.97,4.88 -0.97,2.23 3.08,1.92 1.13,3.78 -1.21,1.17 1.48,3.51 -1.22,3.34 -1.58,2.01 1.39,2.57 2.47,3.28 -0.33,1.89 -0.35,4.06 -1.75,5.59 -1.7,1.69 0.84,3.1 2.38,3.41 1.86,0.07 4.15,1.26 5.69,-0.41 1.46,0.13 1.02,2.44 2.28,2.66 -1.79,2.14 2.3,2.86 3.5,4.06 1.89,0.35 3.98,3.21 2.22,4.78 -1.89,0.92 1.6,1.34 0.72,2.84 1.42,0.67 4.08,-0.27 4.59,-2 0.83,-1.86 3.06,0.75 4.25,-1.28 1.94,0.28 3.17,-1.23 4.75,-2.06 1.61,0.81 2.92,-0.26 2.44,-1.91 1.47,-0.48 2.14,1.45 3.88,1.19 2.24,-0.19 5.23,1.16 7.19,-0.97 1.37,-1.08 -1.66,-3.52 0.97,-4.19 1.41,-1.51 5.16,-1.7 3.31,-4.59 -1.33,-2.09 3.4,-1.11 1.84,-3.13 1.16,-1.54 -0.11,-0.87 -1.16,-1.03 -0.43,-1.14 0.79,-2.47 -0.66,-3.59 -0.98,-1.38 0.17,-2.29 1.41,-1.59 1.25,-0.64 0.95,-2.16 2.41,-1.03 2.27,-0.15 3.98,-1.17 4.72,-3.38 1.38,-2.46 0.89,-5.49 2.66,-7.81 -0.2,-2.14 2.83,-2.48 3.56,-0.75 1.77,-0.54 0.57,-2.61 -0.28,-3.25 0.01,-7.53 -6.31,-5.19 -0.03,-11.56 1.4,-1.6 -0.11,-2.95 -1.28,-1.25 -2.63,-0.14 1.25,-2.56 -0.88,-3.41 0.87,-1.65 -2.2,-1.66 -1,-2.97 -0.44,-1.5 1.55,-2.17 0.03,-3.66 0.3,-0.9 3.04,-3.11 1.41,-3.25 -0.65,1.38 -2.95,0.59 -1.38,-0.63 0.63,-1.59 1.37,-2.89 2.63,-3.78 1.98,-0.19 -1.74,-2.75 -1.53,-4.38 -0.55,-2.02 -0.55,-4.33 -2.5,-5.63 -1.72,-1.41 -3.84,-2.18 -5.03,-4.19 -1.56,-1.57 -3.44,-2.86 -5,-4.38 -0.11,-0.69 0.28,-1.97 -0.94,-1.72 z",
					    "region-22" : "m 292.2,47.66 c -2.76,-0.03 -2.25,3.63 -2.63,5.5 1.19,2.06 4.27,3.76 5.47,5.16 1.3,3.21 -3.04,-0.18 -4.38,-0.47 -3.88,-0.07 -3.56,5.04 -5.41,7.34 -0.71,0.59 -3.75,3.11 -1.34,2.59 1.47,-1.5 2.5,0.6 2.53,1.63 1.88,1.27 3.39,3.01 5.06,4.5 0.98,2.07 3.36,2.37 4.84,3.88 1.75,1.4 1.73,3.63 2.31,5.59 5.2,9.88 10.59,5.88 3.16,4.19 -0.64,-0.36 -1.31,0.39 -2.03,0.43 -0.9,1.51 -2.05,2.89 -2.75,4.41 0.72,1.3 2.77,-1.95 2.47,0.53 -1.27,0.9 -2.25,2.63 -1.34,4.06 -0.91,0.95 -0.75,1.8 -0.03,2.47 -0.13,1.26 0.68,2.63 1.16,3.41 -0.63,0.67 -1.53,2.92 0.16,2 1.1,-1.62 2.87,0.58 1.22,1.44 -0.23,1.5 -3.78,3.59 -1.97,5 0.58,-0.31 -0.73,1.2 0.38,1.53 1.62,1.42 1.34,3.69 1.75,5.59 1.9,0.6 0.81,4.78 -0.75,2.44 -1.9,-1.54 -3.87,1.46 -1.31,2.28 0.51,0.93 -1.25,1.9 0.44,2.63 0.9,0.8 3.16,-0.28 4.5,0.91 2.36,0.62 4.7,-0.16 7.09,-0.5 1.69,-0.31 3.8,-3.12 5.13,-0.63 1.16,-0.16 2.38,0.21 2.81,1.47 0.86,-1.1 3.52,-0.86 2.75,0.88 2.24,1.07 3.58,-3.97 5,-0.88 1.77,1.37 4.5,0.8 6.44,2.34 1.05,0.95 1.86,2.93 2.78,0.72 0.99,0.53 1.93,3.8 3.34,1.69 1.96,-1.93 3.09,1.72 4.47,1.78 0.78,-1.34 2,1.92 2.88,-0.28 0.33,-2.65 3.12,-0.79 4.28,0.09 1.53,-0.88 3.18,-0.87 4.81,-1.03 0.35,1.73 1.88,-1.27 3.25,-0.13 1.13,-0.39 -0.39,-1.2 0.88,-1.76 1.66,-0.49 0.72,-1.03 3.31,0.24 2.65,0.21 2.97,4.34 1.65,6.21 1.62,1.27 3.48,2.24 4.22,4.31 0.74,1.63 2.33,-0.46 2.5,1.88 0.72,2.19 2.68,-1.36 2.66,1.28 -0.24,2.49 3.53,2.87 4.13,3.94 1.75,-1.8 2.07,-4.55 4.88,-5.19 0.68,-2.23 2.37,-3.42 3.56,-5.41 2.67,-0.52 -0.66,-3.26 -2.06,-1.84 -2.26,-0.47 0.23,-2.88 1.31,-3.13 -0.73,-1.44 -2.37,-4.13 0.25,-4.66 1.65,-0.44 4.9,1.28 4.78,-1.5 -2.06,0.27 -1.98,-2.16 -3.88,-2.41 0.6,-1.8 -0.18,-4.31 -0.78,-6.47 1.32,-1.8 3.96,-1.53 5.66,-2.91 1.45,-1.38 4.52,1.52 4,-1.34 1.45,-1.59 3.81,-2.88 5.19,-0.5 1.28,-0.12 3.39,2.55 3.31,-0.22 0.33,-2.86 0.56,-4.98 0,-7.75 1.55,-0.89 1.7,-2.64 0.84,-3.44 1.81,-1.93 -3.62,-5.62 0.69,-5.56 3.16,1.39 1.54,-3.19 4.13,-3.75 1.57,-1.42 5.28,-4.09 2.25,-5.69 0.32,-1.83 0.52,-4.01 1.72,-5.91 1.09,-2.4 -2.7,-2.85 -1.03,-5.34 -0.92,-1.56 -3.38,-2.22 -5.31,-1.53 -1.91,-0.8 -7.17,-0.14 -5.5,-3.66 -0.63,-2.33 -4.89,3.02 -5.13,-0.13 -1.96,-1.5 -4.73,-0.41 -6.75,-2.06 -0.64,-0.23 -1.39,-0.27 -2,0.09 -1.21,0.83 -2.3,3.03 -4.09,1.56 -1.81,-2.61 -3.43,0.49 -5.34,1.06 -2.18,0.63 -4.37,-2 -6.44,-0.25 -1.68,1.82 -4.05,-1.39 -6,0.13 -2.2,1.21 2.12,0.92 -3.49,0.21 -1.83,-1.56 -4.69,-3.08 -7.08,-1.77 -1.63,-0.91 -3.64,1.21 -5.28,1.47 -0.51,-0.79 1.21,-2.03 -0.44,-2.91 -0.98,-1.14 -4.78,3.67 -4.69,0.66 1.62,-1.44 1.72,-3.98 -0.88,-4.22 -1.44,-0.89 -1.04,1.89 -0.91,2.41 -1.98,-0.74 -4.51,-1.19 -6.31,-2.19 0.61,-1.3 -0.76,-2.03 -1.28,-0.53 -0.88,1.66 -1.66,-2.37 -3.22,-0.69 -1.76,0.6 -1.77,4.72 -3.75,1.88 -2.07,-1.49 1.22,-5.38 3.69,-5.38 1.77,-1.43 -2.78,-3.75 -4.16,-2.19 -0.97,2.36 -1.66,-1.18 -2.44,-0.22 -0.33,1.95 -3.12,-0.95 -4,0.91 -2.31,-1.06 -3.91,2.18 -5.59,0.41 -3.43,0.96 -1.19,-3.98 -4.22,-3.97 -2.08,-0.65 -5.34,-1.56 -3.25,-3.91 -1.24,0.25 -2.96,1.34 -4.16,-0.38 -1.88,-2 -4.89,-2.52 -7.13,-0.81 -2.62,2.08 -3.24,-1.93 -5.56,-1.66 z",
					    "region-11" : "m 297.86,122.72 c -1.75,0.85 -1.91,2.97 -2.19,4.66 -0.25,1.42 -0.71,2.89 -1.78,3.91 -0.04,1.04 -0.02,0.73 -0.54,1.02 l -1.06,0.48 c -1,0.54 -2.08,0.8 -3.19,0.78 -0.88,0.67 -1.82,1.37 -2.88,0.72 -1,1.18 0.69,2.19 0.91,3.31 0.23,0.75 -1.18,2.11 0.38,1.81 0.82,-0.44 1.71,0.18 0.75,0.88 -0.37,0.71 0.42,1.09 0.25,1.94 0.29,1.15 1.97,0.94 1.75,2.38 0.87,0.58 0.49,1.27 0.31,2.13 1.32,0.42 2.18,2.12 1.47,3.38 -0.42,1.39 -0.55,3.5 1.16,4.03 1.37,0.98 -0.49,2.26 -0.91,3.25 -0.68,1.18 1.59,1.25 0.69,2.59 -0.04,1.38 2.45,0.98 2.13,2.69 0.34,1.35 3.83,0.32 2.56,2.22 -0.54,1.64 1.41,1.3 2.25,1.56 1.15,0.87 1.43,2.02 0.97,3.34 0.17,1.23 0.64,2.42 1.19,3.53 1.78,-0.36 2.36,2.59 4.38,1.59 0.84,-0.96 2.2,-0.59 1.81,0.91 -0.14,0.69 -0.85,1.76 0.44,1.63 1.2,-0.21 1.25,0.89 1.19,1.75 1.04,0.89 -0.54,1.95 0.06,3 0.63,0.99 -0.75,1.43 -0.53,2.22 1.02,1.29 2.96,0.97 4.25,0.28 0.96,0.25 1.81,-0.89 2.53,-0.56 0.79,0.62 1.93,0.39 1.97,-0.66 1.21,0.12 1.33,-1.12 2.06,-1.75 0.86,0.29 2.16,0.62 2.03,1.69 0.29,1.34 0.97,-0.52 1.72,0.13 1.08,0.55 1.34,-2.34 2.41,-0.78 0.44,0.94 2.06,1.4 2.66,0.44 0.95,-0.46 0.56,-0.21 0.78,0.56 1.12,1.38 -0.37,3.96 2.41,3.78 2.91,0.69 3.09,4.39 1.75,6.31 -1.65,-0.84 -2.88,2.93 -0.41,1.94 1.73,-0.49 3.2,-1.29 5.03,-0.34 1.93,-0.8 3.98,1.81 5.69,-0.28 1.86,-0.31 -0.29,-2.16 1.34,-1.81 1.18,-0.45 3.05,-0.08 1.97,1.41 1.33,2.12 2.95,-1.7 4.97,-1.19 1.67,-0.49 2.04,-2.89 4.03,-3.22 1.12,-1.43 2.91,-3.39 1.16,-5.06 -0.16,-1.63 0.37,-3.89 1.72,-4.81 2.36,0.85 4.14,-2.07 6.47,-0.5 2.32,-0.04 4.01,-1.1 6.34,-0.53 1.28,-0.24 1.3,-2.33 2.97,-1.22 2,-0.66 -1.68,-2.32 -0.03,-3.59 -0.5,-1.21 -1.22,-2.85 0.84,-2.78 1.09,-0.89 -2.02,-3.22 0.59,-2.75 1.77,0.23 2.42,-1.17 1.63,-2.47 1.17,-1.39 1.99,-2.56 3.56,-3.44 -1.04,-1.49 -2.62,-1.7 -4.06,-1.03 -1.93,-1.91 1.07,-3.46 0.31,-5.34 0.3,-1.53 -1.56,-1.91 -2.53,-2.41 -1.25,-0.38 0.2,-2.47 1.31,-2.22 0.34,-0.82 -2.81,-1.8 -0.5,-1.81 1.33,0.7 3.87,-1.62 2.13,-2.16 -1.66,1.45 -1.35,-1.78 -3.38,-1.25 -2.08,-0.53 -0.4,-4.61 -3.09,-2.94 -1.53,-0.07 -0.55,-3.1 -2.69,-1.88 -1.2,-1.64 -2.76,-4.18 -5.06,-5.25 0.91,-1.5 1.05,-2.87 -0.13,-4.28 -0.33,-2.14 -2.6,-1.34 -4.06,-1.97 -0.98,0.49 0.07,2.52 -1.72,1.69 -1.65,-0.86 -2.4,2.1 -3.31,-0.03 -2.1,0.41 -4.57,1.94 -6.31,0.03 -1.77,-1.32 -2.95,3.71 -4.59,0.94 -2.01,1.88 -2.85,-3.56 -5.09,-1.22 -0.21,0.9 -0.92,1.22 -1.53,0.66 -0.5,-0.75 -1.18,-1.8 -1.72,-2.25 -0.42,0.8 -1.43,1.59 -2.09,0.59 0.23,-1.63 -1.65,-1.67 -2.72,-2.19 -0.93,-0.75 -2.23,-0.98 -3.44,-0.88 -1.14,0.44 -1.12,-2.19 -2.5,-1.88 -0.93,0.67 -1.26,2.11 -2.69,1.97 -0.85,0.25 -1.6,-0.39 -1.03,-1.13 -0.93,-1.31 -2.74,1.07 -3.44,-0.84 -1.09,-0.54 -2.35,-0.31 -3.03,-1.41 -1.39,-0.44 -2.35,1.15 -3.59,1.5 -1.54,0.3 -3.06,0.54 -4.63,0.91 -1.02,0.55 -1.67,-0.72 -2.78,-0.16 -1.18,-0.12 -2.15,-1.35 -3.5,-0.66 -1.05,0.52 -2.64,-1.33 -1.94,-2.09 0.55,-0.51 0.17,-1.55 -0.59,-1.5 z",
					    "region-74" : "m 301.02,306.63 c -2.22,0.07 -0.29,3.63 -2.53,4.06 -1.32,0.27 -2.03,-2.74 -3.03,-0.56 -0.89,1.96 -2.58,0.1 -2.16,-1.38 -1.21,0.88 -3.36,2.71 -3.53,0.16 -1.42,-0.74 -1.86,2.28 -3.34,2.69 -3.03,4.43 -2.07,0.52 -5.03,-1.22 l -0.41,-0.13 c -1.42,0.16 -1.77,2.72 -3.53,1.56 -1.2,0.66 -2.72,0.06 -3.06,-0.41 -1.3,-0.05 -2.56,-0.31 -3.03,1.5 -1.19,1 -3.76,-1.33 -4.72,1.13 -0.44,1.9 -0.85,4.73 -3.34,3.78 -1.9,-0.21 -3.23,0.53 -4.47,1.97 -0.02,1.86 -2.26,1.51 -2.78,2.81 1.14,1.36 1.75,3.08 2.03,4.81 -0.68,0.8 -1.8,1.33 -0.59,2.38 -0.3,1.93 -0.97,4.01 1.25,5.16 0.94,0.27 1.88,-0.68 2.59,0.81 1.7,1.94 1.36,4.76 -1.16,5.78 -1.21,0.95 -4.54,-1.23 -3.28,1.66 0.6,1.91 -0.37,3.83 -1.44,5.38 0.26,1.68 -1.12,2.51 -2.19,1.13 -2.49,-0.32 -0.09,2.97 -2.34,3.09 -1.43,0.77 -3.68,3.88 -0.84,4.34 1.89,-0.29 4.26,-0.22 4.78,2.09 -0.95,1.74 -0.87,4.3 1.41,4.5 2,2.75 2.35,-4.25 4.06,-1 1.82,-0.25 3.52,-0.54 5.31,-0.31 2.1,0.81 0.93,3.9 3.41,4.63 0.87,-0.16 3.26,-0.69 3.53,1.25 -1.52,0.83 -2.63,3.88 0.09,3.03 0.75,1.86 3.07,0.22 3.78,2.25 3.5,-1.57 -1.33,-1 1.91,0.69 0.31,0.97 -2.2,1.98 -0.06,2.44 2.59,0.34 1.5,2.35 0,3.31 -0.83,1.5 -2.83,2.33 -2.41,4.34 0.04,1.61 3.43,1.79 1.06,3.34 -1.8,0.75 -0.87,2.15 0.75,1.97 2.37,0.69 -2.16,3.2 0.91,3.56 1.71,0.75 4.39,-0.22 5.41,1.63 -1.66,1.67 0.02,3.87 0.78,5.63 1.3,2.58 3.32,-0.96 4.91,-0.44 1.79,0.66 4.2,-0.24 5.75,1.63 1.5,1.28 2.35,3.24 4.09,4.22 0.76,2.2 3.51,1.8 4.78,0.25 1.25,-0.4 3.35,-3.38 4.06,-0.75 1.76,-0.42 3.25,-1.83 5.25,-1.38 1.95,0.53 4.84,-0.88 2.72,-2.91 -1.73,-1.56 -0.23,-3.93 1.81,-4 1.95,-0.73 0.58,-3.64 2.69,-4.56 0.82,-1.71 -2.57,-3.03 -0.59,-4.81 1.51,-1.4 2.17,-3.42 4,-4.59 0.93,-1.64 3.52,-2.31 3.34,-4.5 0.2,-1.11 -1.11,-4.18 1.22,-2.94 1.67,0.96 3.92,2.81 5.81,1.56 0.19,-1.48 -2.29,-2.38 -0.91,-4.19 0.6,-1.88 0.65,-3.89 0.81,-5.81 -0.59,-1.81 -3,-2.97 -1.91,-5.16 0.21,-1.88 3.04,-1.93 2.06,-4.16 -0.15,-4.41 -1.04,-2.47 -1.69,-4.44 -2.17,-0.79 -2.33,-3.17 -3.84,-4.66 -1.26,-2.03 2.6,-0.91 2.25,-3.03 0.21,-1.29 2.68,0.2 2.69,-1.59 1.86,-0.73 1.65,-2.52 2.34,-3.94 0.66,-1.35 3.22,-1.28 1.78,-3.16 0.41,-1.56 0.09,-3.04 -1.28,-4.09 -1.25,-2.06 -0.74,-4.59 -0.19,-6.78 -0.66,-1.41 -2.33,-2.31 -2.06,-4.19 -0.44,-1.74 -1.9,-2.78 -2.47,-4.5 -0.93,-0.77 -2.55,0.95 -2.25,-1.16 -0.18,-1.3 -1.57,-1.83 -2.16,-0.53 -1.19,-0.72 -4.02,-1.51 -2.22,-3.34 1.61,-1.32 -2.5,-0.5 -1.84,-2.44 -0.35,-2.62 -3.97,-1.23 -5.84,-1.44 -1.93,0.7 -3.78,0.83 -5.66,-0.25 -1.44,-0.55 -3.1,-0.73 -4.56,-0.56 -1.66,-0.98 -3.65,1.46 -5.09,-0.03 -0.47,-0.46 -0.9,-1.08 -1.59,-1.19 z",
					    "region-83" : "m 355.23,283.59 c -0.53,0.03 -0.62,0.95 -1.25,0.59 -1.07,-0.24 -1.3,1.08 -2.19,1.34 -0.68,0.38 -0.82,1.2 -1.56,1.56 -0.59,0.3 -0.39,1.08 -0.69,1.47 -0.82,-0.75 -2.14,-0.58 -2.84,0.25 -0.56,0.51 -1.32,0.28 -1.59,-0.41 -0.26,-0.45 -0.59,-1.49 -1.28,-0.94 -0.65,0.39 -0.38,1.54 -1.28,1.63 -0.49,0.33 -0.43,1.06 -1.06,1.28 -0.54,0.29 -0.85,0.95 -1.53,0.66 -0.62,0.1 -0.27,0.76 -0.06,1.06 0.07,0.49 -0.17,1.38 -0.81,0.88 -0.59,-0.44 -1.76,-0.3 -2,0.31 0.58,0.17 1.69,0.87 1,1.56 -0.36,0.28 -0.08,0.8 -0.25,1.06 -0.67,0.39 -0.14,1.27 0.47,1.34 0.61,0.77 0.54,1.86 0.72,2.78 -1.18,0.73 -2.34,1.72 -3.63,2.13 -0.29,-0.68 -0.87,-0.35 -1.31,-0.09 -0.47,0.1 -0.22,-0.77 -0.81,-0.59 -1.03,0.35 -2.02,0.81 -3.16,0.72 -1.3,0.06 -2.79,0.14 -3.59,1.34 -0.8,0.47 0,1.58 -0.81,2 -0.42,0.05 -0.96,-0.07 -1.16,0.47 -0.78,1.48 -0.91,3.38 -0.41,4.97 0.26,0.38 0.8,0.29 1.16,0.56 0.49,0.09 1.26,0.01 1.06,0.78 0.02,0.4 -0.71,0.16 -0.84,0.56 -1.01,0.83 0.26,2.01 1.16,2.19 0.58,-0.08 0.88,0.54 1.34,0.59 0.39,-0.14 0.36,-1.36 0.88,-0.78 0.76,0.62 1.67,1.42 1.25,2.53 0.36,0.53 0.92,-0.63 1.47,-0.19 0.81,0.23 1.69,0.87 1.44,1.84 0.14,1.11 1.7,1.29 1.69,2.47 0.4,1.14 -0.02,3 1.47,3.41 0.81,0.19 0.42,1.36 0.75,1.94 0.21,1.17 -0,2.06 -0.66,2.5 -0.63,3.31 3.36,4.82 2.13,8.09 1.47,2.13 -3.77,2.43 -2.19,5.09 -1.55,1.17 -2.38,3.36 -4.44,2.97 -0.24,1.6 -1.76,1.78 -2.75,2.78 1.42,1.48 1.73,4.06 3.81,4.88 1.87,1.54 2.6,3.85 2.03,6.16 -0.04,1.68 -2.37,1.11 -2.13,3.19 -1.39,2.53 3.35,3.48 1.78,6.19 -0.13,0.85 0.13,1.66 0.63,2.31 -0.13,-0.03 -0.27,-0.04 -0.47,-0.03 -1.19,1.79 -1.69,4.43 0.41,5.72 -0.45,1.36 -2.52,1.74 -3.5,0.69 -1.54,-0.13 -3.08,-2.71 -4.38,-1.53 1.01,1.48 0.34,3.55 -0.13,5 -1.99,0.75 -2.55,2.82 -4.34,3.78 -0.52,1.72 -2.44,2.69 -2.84,4.41 0.01,1.72 2.73,2.74 0.56,4 -1.7,1.18 -0.24,4.86 -3.06,4.34 -2.7,0.63 -1.6,3.73 0,4.94 0.65,2.63 -4.47,0.66 -2.91,3.47 0.18,1.52 2.04,2.7 0.53,4.13 0.27,1.69 1.62,3.03 2.59,4.38 1.84,1.32 0.94,3.21 0.34,4.84 0.62,1.33 -1.77,3.31 -0.25,3.78 2.44,-0.09 0.11,3.66 2,4.56 1.7,1.06 0.3,-2.61 2.63,-2 1.68,-0.52 3.97,-1.43 4.56,0.78 2,-0.58 4.34,0.82 6.09,-0.75 0.44,-2.1 2.59,-3.2 3.22,-5.22 -0.69,-2.32 2.22,-3.17 2.16,-5.13 0,-1.99 1.08,-3.8 2.78,-4.53 0.13,-1.76 2.71,-1.81 3.06,-3.56 2.42,-0.56 2.51,3.04 2.13,4.63 0.65,0.42 1.86,-1.03 3.03,-0.47 1.73,-0.26 0.77,2.87 1.78,4.06 0.04,1.66 1.49,1.36 2.34,1.41 0.51,2.24 -0.6,4.89 0.69,7.09 0.22,1.4 1.89,3.14 2.25,0.88 0.17,-2.12 2.41,-3.18 1.69,-5.31 1.31,-1.43 0.08,-3.81 1.84,-5 0.34,-0.92 1.67,-0.91 1.28,-2.38 -0.31,-1.78 2.38,-4.14 2.91,-1.41 1.09,2.08 3.68,-0.13 3.13,-1.91 0.66,-0.39 0.95,-3.09 1.75,-1.44 1.49,0.21 2.72,-1.4 3.94,-1.91 0.35,-1.7 3.81,1.59 2.72,2.25 0.25,1.79 1.13,3.49 1.72,5.16 0.34,1.37 1.36,3.4 2.72,1.72 1.7,-0.4 4.23,-0.26 3.84,-2.75 0.47,-2.25 4.43,-0.37 3.41,1.53 -0.08,1.93 4.09,-1.3 4.13,1.69 0.63,1.03 1.68,1.89 2.41,2.97 1.04,-0.64 1.78,0.18 1.09,1.22 1.62,0.86 4.1,-0.84 4.34,-2.72 0.12,-1.27 1.25,-3.15 2.19,-1.59 -0.03,-1.43 2.74,-0.34 1.94,-2.19 0.24,-2.16 3.14,-1.12 4.56,-1.72 2.32,0.9 2.89,-1.82 3.72,-3.28 1,-1.17 1.04,-3.32 3.09,-2.47 1.27,0.03 2.49,-1.1 1.13,-2.06 -0.7,-2.65 2.93,-1.91 3.81,-3.19 -0.1,-1.04 -2.16,-1.3 -1.03,-2.72 -0.2,-1.4 2.98,-1.25 1.28,-2.53 -1.63,-1.76 2.37,-1.76 2.38,0.03 1.44,0.42 -0.33,-2.17 0.88,-2.91 0.94,-1.34 2.07,-3.68 0.75,-5.06 -0.88,-1.26 -2.37,-2.78 -3.72,-1.13 -1.58,0.28 -1.8,-1.64 -1.38,-2.53 -1.45,-0.91 -0.99,-1.91 0.06,-2.78 -0.1,-1.71 -2.18,-2.09 -3.34,-1.28 -1.53,-0.47 -2.3,-2.48 -4.19,-1.63 -1.37,-1.08 -2.02,0.41 -2.16,1.16 -1.7,-0.13 -2.86,0.95 -3.81,1.84 -0.54,-1.5 -1.85,-0.63 -2.22,0.5 -0.6,-1.73 -2.18,-3.98 -3.94,-1.94 -0.39,0.75 -1.16,2.57 -1.53,0.72 -0.67,-0.67 -0.11,1.33 -0.19,-2.22 -0.77,-2.78 3.41,-2.66 3.56,-5.06 0.08,-1.27 0.89,-2.57 -0.59,-3.5 -0.34,-2.4 -0.76,-5.08 -3.38,-6.03 -2.51,-1.49 -4.53,-3.84 -4.94,-6.81 0.3,-1.94 -2.55,-2.71 -2.44,-4.44 -2.77,-1.23 1.29,-3.16 -0.16,-5.28 -0.46,-1.42 2.46,-2.05 0.63,-3.69 -2.2,-1.35 -2.35,-3.28 -2.41,-2.44 0.41,0.47 0.97,-0.54 0.94,-0.97 -0.15,-0.63 0.52,-1.02 1.06,-0.72 0.48,0.22 1.27,0.4 1.28,-0.34 0.41,-0.77 1.1,0.48 1.69,-0.03 0.66,-0.43 2.17,-0.86 1.53,-1.94 -0.55,-1.45 -1,-3.06 -0.38,-4.56 0.35,-0.94 -0.22,-1.77 -0.75,-2.44 -0.09,-0.98 -0.19,-2.05 -0.28,-3 0.9,-0.02 0.56,-0.74 0.19,-1.25 -0.62,-1 0.08,-2.53 -1,-3.28 -0.34,-0.41 -0.34,-1.39 0.44,-1.13 0.62,0.33 1.03,-0.25 1.03,-0.81 0.86,-0.77 2.5,-0.04 3.19,-1.13 0.39,-0.12 0.93,-0.25 0.81,-0.81 0.24,-1.13 2.3,-0.38 2.34,-1.72 -0.01,-1.08 1.49,-0.35 2.03,-0.84 -0.47,-0.98 0.14,-2.28 -0.19,-3.38 -0.22,-0.75 -0.56,-1.53 -0.06,-2.25 -0.09,-0.66 0.49,-1.19 0.25,-1.84 0.92,-0.68 0.3,-2.38 -0.78,-2.59 -0.47,-0.05 -0.92,-0.15 -1,-0.69 -0.62,-0.48 -1.87,-0.88 -2.28,0.06 -0.58,0.43 -1.56,-0.09 -1.78,-0.69 0.04,-0.44 0.16,-1.48 -0.59,-1.16 -0.61,-0.09 -0.17,-0.75 -0.47,-1 -0.68,-0.03 -1.23,0.99 -1.91,0.34 -0.7,-0.25 -1.14,-1.12 -1.97,-0.91 -0.71,-0.06 -1.3,-0.89 -0.78,-1.5 0.12,-0.95 0.3,-2.27 -0.5,-2.97 -0.67,-0.08 -0.62,-0.64 -0.38,-1.09 -0.11,-0.87 -0.72,-1.6 -0.94,-2.44 -0.41,-0.57 -1.3,-0.78 -1.38,-1.53 -0.43,-0.32 -0.74,-0.7 -0.75,-1.25 -0.23,-0.42 -0.82,-0.58 -0.66,-1.19 -0.07,-0.72 -0.65,-1.3 -0.66,-2 -0.38,-0.23 -0.96,-0.08 -1.13,-0.63 -0.76,-0.3 -0.78,0.95 -0.41,1.34 0.52,0.51 0.35,1.09 -0.31,1.25 -0.46,0.18 -1.77,-0.09 -1.38,0.78 0.22,0.53 0.67,1.23 -0.06,1.59 -0.45,0.63 -0.72,-0.75 -1.25,-0.16 -0.73,0.55 -1.34,1.36 -1.72,2.13 -0.7,0.19 -2.06,0.04 -1.81,-1 0.28,-0.69 0.27,-1.72 -0.66,-1.88 -0.06,-0.42 -0.07,-1.16 -0.72,-1 -0.6,-0.11 -1.41,-0.34 -1.66,0.44 -0.42,1.36 -2.42,1.83 -3.19,0.53 -0.36,-0.46 -0.41,-1.39 -1.25,-1.22 -0.93,-0.04 -1.4,0.93 -2.19,1.28 -0.52,0.67 -1.44,1.44 -2.28,0.75 -1.65,-0.71 -2.01,-3.05 -3.97,-3.28 -1.62,-0.6 -2.82,-2.07 -3.16,-3.75 -0.68,-0.77 -1.9,-0.51 -2.81,-0.75 z",
					    "region-82" : "m 445.45,302.63 c -0.9,1.57 -0.94,3.47 -1.88,5.03 -0.08,2.19 -1.36,3.9 -1.91,5.91 -0.03,2.1 -1.17,3.91 -1.75,5.88 -0.42,1.81 -1.29,3.5 -1.5,5.34 -2.68,1.49 -2.72,-0.38 -2.84,-0.72 0.16,-1.57 0.9,-3.79 -1.34,-4.03 -1.92,-1 1.76,-1.41 0.19,-2.69 -0.13,-0.32 -0.29,-0.7 -0.66,-0.81 -0.87,0.66 -2.27,-0.18 -2.53,1.44 -0.41,2.16 -2.62,0.68 -2.94,-0.66 -0.67,1.6 -2.76,2.32 -3.66,0.47 -1.26,-0.9 -4.03,-1.29 -3.94,1 -0.13,1.97 -0.38,1.61 -0.42,3.08 0.23,1.74 -0.15,0.13 -0.32,2.71 -2.07,-0.72 -4.56,2.98 -5.94,0.98 1.08,-1.6 -0.62,-0.92 -1.5,-0.97 -1.01,-1.58 -2.12,1.87 -3.66,0.28 -1.85,-2.55 -4.05,0.47 -6.22,0.59 -1.47,-0.6 -1.79,-3.29 -3.91,-2.34 -2.98,-0.56 1.33,-4.04 -1.34,-4.63 -1.4,1.09 -3.38,0.82 -4.47,2.28 -1.82,0.16 0.93,1.98 0.09,3.09 1.14,1.99 -0.45,4.01 0.88,6.06 0.77,1.92 -0.65,4.23 0.63,6.22 0.35,2.41 -2.8,1.88 -3.97,2.59 -2.35,-0.89 -2.48,3.14 -0.31,3.44 2.21,1.91 -1.22,3.67 -0.25,5.94 0.04,1.28 -2.46,2.83 -0.03,3.19 0.41,1.15 0.55,2.32 1.81,2.59 1.02,2.1 0.9,4.48 2.53,6.38 1.14,1.23 2.73,2.04 4.03,3.16 1.77,0.88 2.27,2.98 2.13,4.78 0.78,1.17 1.98,2.38 0.88,3.66 0.6,2.98 -3.75,2.42 -3.69,5.28 -0.24,1.25 0.86,4.49 1.47,1.78 1.44,-1.91 3.35,-0.47 4.16,1.16 0.79,-1.11 1.74,-0.49 2.69,0 0.15,-2.21 3.89,-0.72 3.47,-2.81 1.64,-0.48 3.97,-0.56 5.25,0.84 0.93,1.42 3.2,-0.8 4.25,1.31 1.2,1.24 -2.34,2.55 0.19,3.31 -0.27,1.39 -0.27,3.35 1.86,1.85 2.67,-0.02 3.91,2.01 3.54,5.68 -0.84,1.45 -2.04,2.84 -1.17,4.56 -1.38,1.82 -1.62,-3.06 -3.47,-1.03 0.08,0.93 1.94,1.83 0.06,2.25 -1.79,0.55 -1.33,2.98 0.03,3.63 -0.47,2.05 -5.24,0.65 -3.53,3.84 1.35,2.27 -2.76,1.27 -3.53,2.22 -0.5,1.82 -1.65,3.12 -2.47,4.78 -1.73,1.45 -4.71,0.11 -6.56,1.22 -0.06,1.33 -0,2.6 -1.59,2.72 -0.66,1.6 -2.32,-1.22 -2.47,1.16 -0.36,1.82 -1.26,3.38 -3.22,3.84 0.04,1.47 -0.12,2.82 0.5,4.13 -0.1,1.82 1.01,3.59 1.19,5.5 0.67,1.99 3.1,2.63 3.16,5.03 0.75,1.76 0.21,4.28 2.34,5.16 1.14,0.83 0.95,2.06 1.75,2.97 -1.24,1.36 0.1,3.48 -0.91,5.34 1.7,-0.1 4,-2.04 4.88,0.53 2.26,-0.51 3.43,4.43 5.78,2.47 0.31,-2.54 2.52,-4.67 5.22,-4.38 0.89,1.01 -0.76,4.43 2.03,3.59 1.01,-1.21 0.12,-4.65 2.97,-3.25 2.16,0.6 2.97,2.89 5.16,3.5 3.18,1.08 0.5,-3.83 2.57,-2.6 2.1,-1.19 -0.23,0.37 3.05,-0.12 2.81,-0.3 3.35,2.7 3.5,4.84 0.37,3.51 2.73,-1.83 4.5,-0.56 2.16,-0.59 4.02,-1.98 6.09,-2.75 1.51,-0.08 2.31,2.57 4.03,0.72 0.5,-1.18 2.5,-1.96 1.56,0 -1.01,1.27 0.17,2.53 -0.34,4.06 1.15,1.41 3.52,1.07 4.38,0.13 1.67,1.57 4.23,0.98 5.78,1.84 0.25,1.64 0.25,3.65 2.38,3.5 0.91,2.71 3.77,2.53 5.25,0.38 2.19,-0.46 -0.07,-2.19 1.78,-3.09 1.34,-0.38 2.44,2.35 3.25,-0.06 2.18,-0.81 0.01,-3.75 0.91,-5.25 -1.51,0.33 -2.13,-0.36 -2.13,-1.88 -1.71,-0.59 -0.04,-1.12 -0.63,-2.16 -2.21,0.34 -4.08,-0.81 -6.06,-0.88 -1.47,-1.34 -2.64,-1.83 -2.28,-4 -1.26,-1.18 -0.41,-2.43 1.16,-1.56 2.99,0.47 -0.79,-1.86 -0.06,-3.41 -0.23,-2.54 3.39,-0.15 4.84,0.19 1.61,1.06 2.73,-0.14 3.06,-1.53 3.5,-0.73 -3.71,-2.71 -0.94,-4.78 1.26,-1.58 1.46,-3.53 1.66,-5.25 1.87,-0.08 4.5,0.45 5.83,-0.67 3.38,-2.47 0.39,-1.08 2.06,-4.74 -0.07,-3.68 3.61,-0.12 5.55,-2 2.01,-0.73 1.36,-1.84 0.69,-3.03 1.72,-0.3 3.13,-2.8 4.63,-0.88 2.1,-0.43 3.19,-3.79 5.72,-2.13 1.86,0.27 3.48,-0.14 4.91,-1.34 1.13,0.91 3.3,2.59 2.84,-0.19 0.52,-2.11 0.19,-4.13 -1.34,-5.56 0.21,-1.88 -0.41,-3.2 -2.41,-2.31 -3.75,0.79 -3.52,-3.61 -1.44,-5.34 -1.16,-1.18 0.95,-3.15 0.91,-4.03 0.97,1.07 1.62,2.76 3.31,1.25 2.63,0.04 0.96,3.97 3.56,3.72 1.62,0.4 4.28,1.15 3.63,-1.59 0.15,-2.51 3.33,0.05 4.25,-2.28 2.39,1.02 4.13,-0.89 6.19,-1.31 1.67,-0.64 2.9,-1.73 4.59,-0.28 0.86,1.73 4.44,1.23 3.34,-0.97 2.96,-0.22 3.03,-3.89 6.13,-3.81 1.12,-1.22 2.87,1.16 3.09,-1.13 2.54,-0.93 1.88,-3.3 1.06,-5.25 0.54,-1.73 2.09,-3.22 2.78,-5.09 0.35,-2.33 -3.38,-2.26 -3.56,-4.69 -1.48,-1.57 -3.46,-2.39 -4.84,-4.16 0.27,-1.97 -1.22,-3.82 -0.66,-5.75 1.75,-2.42 -1.83,-2.52 -3.09,-3.34 -1.24,-1.6 -4.57,-1.91 -4.63,-4.75 0.22,-1.3 -0.53,-2.5 -1.44,-2.38 0.77,-0.55 1.38,-1.18 1.16,-2.34 -0.04,-1.75 1.82,-1.78 2.78,-1.88 0.32,-1.93 2.75,0.19 3.94,-1.25 1.92,-0.72 2.67,-2.72 3.47,-4.44 1.07,-1.81 -0.82,-3.57 -1.31,-5.25 -1.54,-0.97 -2.37,-4.41 -4.38,-3.38 -2.46,1.2 -1.22,-2.53 -0.81,-3.63 0.45,-2.38 -5.15,-0.61 -4.47,-3.47 0.63,-1.52 0.3,-3.29 1.16,-4.69 1.66,-1.42 2.02,-3.73 0.13,-5.19 -1.28,-1.29 -2.79,-3.08 -0.72,-4.31 1.13,-1.5 0.53,-3.98 -1.56,-4.13 -2.01,-0.66 -4.04,-1.44 -6.19,-1.44 -2.47,0.62 -5.49,-0.55 -7.47,1.56 -1.52,1.73 -3.77,1.96 -5.91,2.13 -1.97,0.39 -2.97,2.4 -4.34,3.69 -1.65,1.56 1.06,2.55 0.25,4.16 -0.09,2.18 3.53,0.6 2.25,2.91 -1.49,1.45 -3.65,2.15 -4.84,3.94 -0.54,2.24 -3.42,2.72 -5.28,1.91 -1.74,0.51 -3.53,0.73 -5.31,1.13 1.53,-0.7 2.61,-2.7 0.88,-3.75 -0.92,-2.11 2.74,-3.25 4.44,-3.5 3.3,0.13 0.55,-3.33 2.31,-4.84 1.05,-1.66 2.38,-4.09 0.03,-5.38 -1.53,-2.11 -3.81,-0.86 -4.75,1.03 -1.87,1.05 -2.36,3.25 -3.81,4.63 -1.35,1.27 -3.12,4.03 -5.78,3.22 -1.93,-0.56 -4.98,1.07 -4.41,-2.25 -0.76,-1.18 -2.82,-1.78 -3.59,-2.53 -1.5,1.09 -1.87,3.05 -3.88,3.69 -1.35,2.09 -5.96,0.7 -3.69,-2 -0.13,-1.17 -2.22,0.33 -2.06,-1.72 -0.53,-0.8 -0.76,3.05 -1.06,0.88 -0.55,-1.56 -1.99,-2.97 -1.66,-4.47 -1.69,-0.63 -3.46,-1.38 -2.41,-3.31 -1.67,-0.94 -4.57,-0.63 -4.84,-3.19 -0.77,-2.9 -3.6,-0.35 -5.34,-0.31 -2.42,1.93 -4.07,-2.75 -6.44,-0.84 -0.29,-0.08 -0.47,-0.33 -0.63,-0.56 z m 1.38,137.94 c 2.48,0.28 2.22,2.93 4.59,3.22 -0.38,1.33 -2.81,1.87 -2.81,3.91 -0.59,3.17 -3.26,0.45 -5.16,1.06 -0.4,-1.03 -0.63,-2.47 -0.56,-3.44 1.53,-1.47 1.22,-3.81 3.66,-4.41 z",
					    "region-93" : "m 506.05,394.72 c -2.38,0.66 0.14,3.66 -2.03,4.59 -1.72,2.79 1.36,4.23 3.66,3.34 2.39,-0.55 0.1,3.64 2.59,4.03 0.47,1.76 0.32,4.2 -0.38,6.03 -1.48,-0.46 -3.08,-2.39 -4.31,-0.34 -2.25,0.76 -5.02,-1.36 -6.72,0.91 -1.11,1.7 -2.56,1.95 -3.88,0.47 -0.55,1.28 -4.21,1.51 -1.84,3.06 -0.94,2.26 -4.25,2.96 -6.38,2.25 -1.23,0.91 -1.36,3.17 -0.59,4.31 -1.22,2.28 -3.09,2.69 -5.5,3.16 -1.63,-1.42 -3.66,-0.25 -2.81,1.75 -0.72,1.97 -3.55,4.8 -0.25,5.88 1.2,0.81 1.12,1.94 -0.28,1.84 -0.36,2.15 -2.09,2.59 -3.75,1.28 -1.52,-0.34 -5.11,-2.61 -4.06,0.56 -0.41,1.39 2.92,2.83 0.38,3.09 -1.92,-1.14 -2.36,0.43 -1.34,1.94 -0.48,1.59 1.38,2.76 2.88,3.31 1.63,-0.31 3.03,1.39 4.88,0.66 1.62,0.26 -0.6,2 1.28,2.59 -1.05,2.29 3.34,0.82 2.17,3.08 0.1,1.26 -0.93,4.3 0.23,4.18 -1.44,0.42 -1.76,2.19 -2.9,0.77 -1.2,-1.89 -3.41,-0.48 -2.34,1.28 -1.15,1.03 -3.24,1.96 -3.59,3.63 -0.25,-0.96 -1.62,-1.18 -2.38,-1.81 -0.01,-2.28 -4,-1.04 -2.94,-3.84 0.24,-2.27 -2.29,-1.23 -3.59,-1.47 -1.07,-0.69 -2.7,-2.08 -3.25,-0.41 -1.82,0.23 -4.44,-0.81 -3.41,-2.94 -1.52,-1.18 1.51,-2.73 0,-3.5 -0.77,1.1 -2.2,2.65 -3.63,1.69 -1.1,-2.3 -2.93,-0.01 -4.5,0.34 -1.39,0.4 -2.62,1.74 -4.19,1.22 -1.3,-0.02 -2.71,3.54 -3.53,1.34 -0.4,-1.69 -0.01,-4.12 -1.78,-5.13 -0.57,-0.28 -1.13,-0.48 -1.78,-0.41 -1.19,0.91 -3.87,-0.8 -3.66,1.44 -0.73,2.05 0.8,3.61 1.06,5.47 -0.11,0.77 2,0.05 1.44,1.41 1.54,2.17 -0.7,4.93 0.41,7.13 0.94,0.88 2.16,-0.09 2.81,1.53 0.92,1.17 1.41,2.61 2.56,3.59 1.05,1.11 0.24,2.15 -1.06,2.19 0.2,1.77 -1.23,3.32 -2.73,3.84 -1.29,2.45 -1.68,0.97 -4.67,4.38 1.41,0.89 -0.84,2.14 0.09,3.63 0.42,2.15 -2.07,3.51 -1.69,5.72 0.86,1.45 -0.17,2.58 -1.63,1.53 -1.97,-1.55 -4.68,-0.42 -5.31,1.69 -1.63,1.04 -2.16,4.13 0.44,3.75 0.06,2.02 -2.9,1.67 -3.34,3.31 -1.75,0.99 -3.64,1.22 -4.5,2.81 -1.75,0.17 -4.98,3.13 -2.06,3.97 2.99,-0.17 5.9,1.41 8.88,0.56 2.1,-0.36 4.56,-0.11 6.16,1.38 1.4,1.7 -2.48,3.85 0.47,4.91 1.67,0.45 3.47,0.17 5.19,0.41 1.54,-0.09 3.75,0.56 4.88,-0.31 0.04,-2.31 -3.27,-2.38 -3.94,-4.38 -0.37,-2.14 0.45,-4.38 -0.31,-6.5 -0.27,-0.91 -2.07,-4.59 -0.28,-2.16 1.58,2.03 1.39,4.68 1.03,7.06 -0.44,2.92 3.28,3.57 4.97,5.19 2.32,-0.03 -1.88,-2.78 1.22,-3.16 1.7,-0.98 3.71,-0.9 5,0.78 2.12,-0.03 4.81,-1.93 3,-4.13 -2.29,-0.91 -1.95,-4.33 -0.97,-5.22 1.18,1.76 4.95,0.12 3.94,3.25 1.13,1.96 3.21,1.18 4.72,0.53 1.52,1.99 -1.57,3.81 -3.03,4.84 -1.9,0.72 -4.26,-0.43 -5.91,1.16 -1.75,1.59 0.46,4.43 2.47,4.22 2.62,-0.1 5.4,0.47 7.91,-0.44 1.54,-1.44 4.7,-1.73 4.94,0.97 -0.14,1.58 -0.17,2.96 0.5,4.25 -1.22,1.5 -0.89,3.6 1.41,3.31 2.25,-0.5 4.61,0.98 6.53,0.16 1.1,1.57 2.76,3.17 4.56,1.5 2.91,-0.26 1.33,-0.92 2.22,0.59 -0.02,1.61 1.89,3.03 3.53,2.53 0.63,0.64 0.56,1.77 1.88,1.59 0.19,0.99 -2.68,1.22 -1.13,2.53 1.43,0.36 3.77,3.21 4.47,0.28 0.46,-1.06 3.11,0.27 1.75,-1.19 -1.19,-0.66 -2.06,-1.92 -0.13,-2.22 1.14,-0.04 1.61,1.68 3.16,1 1.73,-0.39 2.65,1.89 4.53,0.69 2.33,-0.05 2.26,3.12 -0.06,3.09 1.01,0.28 3.45,0.88 4.16,-0.09 -1.41,-0.84 -0.65,-3.02 0.06,-4.19 1.81,-0.51 4.14,-1.09 5.91,0.03 0.9,0.75 1.79,2.99 3.06,1.38 -1.33,-2.25 0.73,-4.1 2.94,-4.34 1.82,-0.15 3.7,-0.23 4.81,-1.91 1.53,-0.99 2.63,0.46 3.19,1.5 1.86,-0.28 1.14,-2.69 3.09,-2.91 -0.25,-0.86 -1.21,-2.01 0.22,-2.75 2,-2.05 -1.75,-2.01 -3,-1.59 -2.62,-0.25 0.69,-1.84 1.75,-1.97 0.92,-0.9 0.58,-2.8 2.41,-3 1.27,-1 0.92,-2.99 1.38,-4.44 1.32,-1.24 3.42,1.1 5.13,-0.25 1.94,-0.35 4.81,-3.07 2.84,-4.69 0.95,0.46 2.28,0.08 1.88,-1.53 0.05,-1.74 2.24,-2.35 3.66,-2.25 1.4,-0.6 3.03,-1.95 4.31,-0.47 0.92,-1.55 -0.14,-3.61 0.66,-5.28 0.47,-2.1 3.38,-1.04 4.03,-3.03 0.72,-1.31 3.11,-1.17 4.22,-0.94 0.41,1.87 1.39,-0.15 1,-1.09 1.14,-0.12 2.61,-0.31 2.25,-2.03 0.47,-1.55 1.97,-1.33 2.75,-0.41 1.62,-0.12 1.33,-2.49 3.22,-2.44 0.12,-1.52 -1.18,-3.11 -1.22,-4.78 -0.33,-2.13 2.96,-2.32 2.78,-4.5 0.2,-2.18 2.79,-2.46 3.91,-4.09 1.16,-1.41 0.76,-3.43 2.5,-4.53 1.68,-1.83 -0.81,-3.39 -1.59,-4.88 0.1,-1.29 0.76,-4.59 -1.66,-3.22 -1.26,1.94 -3.98,1.28 -5.91,2.41 -1.51,0.57 -3.08,1.13 -4.69,1.28 -1.89,0.43 -2.52,-1.59 -4.03,-1.94 -2.04,0.55 -3.04,-1.82 -4.88,-2.31 -1.02,-1.04 -2,-2.12 -3.59,-1.63 -1.13,-0.99 -2.65,-2.58 -4.34,-1.81 -2.02,0.21 -1.92,-2.24 -2.78,-3.34 -1.88,-1.1 -1.6,-3.59 -3.53,-4.66 -0.06,-0.14 -0.21,0.11 -0.25,-1.31 -0.43,-1.8 0.92,-3.38 2.13,-3.88 -1.19,-1.88 -3.78,-3.31 -3.41,-5.91 0.82,-2.4 3.86,-3.29 4.41,-6 0.44,-1.01 0.06,-2.42 -1.06,-2.59 0.65,-0.26 1.29,-0.56 1.81,-1 0.67,-2.95 6.21,1.07 4.19,-2.81 -2.19,-1.97 -1.76,-5.16 -1.75,-7.72 -1.52,-2.46 -4.33,-1.95 -6.63,-1.66 -2.02,-1.18 -4.01,-2.55 -5.81,-4 -0.48,-1.92 0.49,-3.92 -0.22,-5.88 -0.38,-2.63 -4.73,-0.19 -4,-3.66 -0.57,-1.87 -2.47,-5.81 -4.59,-2.97 -1.36,0.43 -3.55,-0.41 -3.06,2 -0.06,2.84 -3.64,0.47 -5.25,0.41 0.16,-2.01 -1.7,-4.09 -3.81,-2.69 -0.55,-0.15 -0.84,-0.68 -1.38,-0.88 z m -59.16,46.06 c -1.34,0.86 -2.93,1.53 -2.88,3.41 -0.68,0.82 -1.64,1.75 -0.5,2.59 -1.2,2.34 2.22,1.85 3.59,2.34 1.48,-0.54 1.63,-2.54 2.38,-3.81 0.79,-0.35 2.98,-1.64 0.84,-1.78 -1.64,-0.52 -1.51,-2.57 -3.44,-2.75 z",
					    "region-26" : "m 374.42,178 c -0.09,0 -0.21,0.03 -0.31,0.06 -1.02,3.01 -4.51,0.42 -6.34,1.97 -2.2,0.17 -4.83,-1.19 -6.41,1.03 -2.57,-1.79 -3.94,2.42 -3.25,4.38 1.68,1.97 -0.57,4.6 -2.41,5.5 -1.87,0.69 -2.44,2.93 0.06,3.28 3.44,0.48 2.16,5.15 5.03,6.44 1.86,1.41 0.81,2.98 1.94,4.97 -0.66,1.96 -2.63,3.27 -4.19,4.59 -2.15,0.99 -1.2,3.07 -0.28,4.28 -1.27,1.6 0.91,4.33 -2.31,4.25 -1.68,2 -6.04,-0.22 -5.91,3.16 -0.16,1.79 1.75,0.84 2.06,2.41 1.23,1 1.49,2.38 2.38,3.59 -1.59,1.67 0.33,4.31 2.09,5.13 1.36,0.34 0.24,0.49 -0.59,-0.06 -1.93,0.57 -4.68,0.43 -5.94,1.69 1.17,1.4 2.06,2.94 2.69,4.63 1.41,1.6 0.64,3.6 -0.16,5.28 -1.13,1.89 -2.63,4.76 0.47,5.69 1.61,1.55 3.42,2.82 3,5.31 0.69,2.02 1.62,3.99 1.91,6.16 0.66,1.8 -0.92,4.43 1.25,5.56 2.12,1 -0.1,3.52 0.91,5.03 0.58,2.1 -1.62,3.94 -0.31,6.06 0.71,2.09 -0.92,3.84 -1.38,5.75 -0.16,2.28 2.07,3.67 3.97,4.25 1.45,1.18 2.99,4.61 5.06,2.22 1.39,-2.15 3.2,-1.4 4.22,0.47 1.89,0.79 3.51,-3.54 5,-0.91 1.15,0.73 0.12,3.43 2,3.06 0.82,-1.25 2.27,-2.28 3.44,-2.13 -0.45,-1.58 -0.46,-2.4 1.31,-2.25 -0.04,-1.1 -0.2,-3.77 1.47,-2.03 1.28,-0.83 1.92,1.84 0.59,0.91 0.57,3.06 3.65,4.81 4.22,7.81 0.75,1.41 1.19,3.46 1,5.06 2.04,1.85 5.27,-0.02 5.81,3.28 1.08,1.35 3.61,-1.11 4.91,1.13 2.56,1.38 0.03,4.03 0.38,6.06 0.06,1.87 1.72,4.92 -1.22,4.69 -0.63,1.31 -3.77,1.55 -2.13,3.66 -1.04,1.85 -0.29,4.33 2.16,3.69 1.09,1.48 2.44,3.3 4.28,1.41 2.27,-2.66 4.91,2.5 6.72,-0.66 1.34,0.75 3.64,-0.04 2.69,2.22 1.65,0.02 3.16,-2.01 5.16,-2 1.19,-2.22 0.14,-5.87 2.63,-7.28 2.52,0.05 4.6,3.81 6.38,0.47 0.58,2.51 2.94,1.41 3.28,-0.53 2.49,-1.24 4,1.91 2.38,2.88 2.76,0.76 1.62,3.11 1.88,5.06 3.75,1.26 2.79,-4.69 4.38,-6.75 1.05,-2.9 1.5,-5.84 2.75,-8.66 0.84,-2.16 1.03,-4.89 2.59,-6.5 1.57,0.12 3.16,-0.62 4.22,1.22 2.7,1.53 7.1,-3.93 8.31,0.81 1.01,2.83 4.29,2.1 6.38,1.09 2.34,0.51 4.16,-2.31 1.19,-2.97 -1.86,-1.31 -1.38,-5.17 1.06,-5.09 -0.29,-1.51 0.25,-2.26 1.31,-3.13 -1.26,-2.48 -1.09,-5.01 -3.19,-7.16 1.37,-1.38 0.91,-2.69 -0.97,-3.28 -2.12,-3.08 4.28,-2.05 5.28,-3.09 -2.01,-1.05 -2.54,-4.31 -5.09,-3.16 -2.06,-0.25 -1.36,-4.82 -3.91,-3.03 0.08,-1.67 -0.34,-4.37 -2.72,-3.03 9.3e-4,0.78 -0.25,0.19 3.03,-0.97 1.29,-0.68 2.18,-1.61 0.53,-2.31 -0.4,-3.73 4.95,-2.46 5.59,-5.38 0.99,-2.18 2.82,-4.19 2.56,-6.5 1.77,-1.75 0.38,-4.84 2.5,-6.44 -0.95,-0.58 -2.64,-1.01 -1,-2.28 0.09,-1.58 0.38,-4.2 -2,-3.25 -1.24,-1.39 0.1,-5.58 -3.16,-4.34 -0.46,-1.01 1.12,-1.5 0.72,-2.66 1.66,-0.28 3.17,-0.36 3.75,-2.25 1.65,-1.75 0.28,-6.48 -2.25,-6.5 -0.68,1.44 -1.97,2.06 -3,2.03 -1.1,-0.38 -2.24,-1.73 -3.19,0.19 -1.11,1.75 -2.94,0.44 -2.19,-1.28 -0.65,-2.03 -3.71,-1.92 -3.25,-4.41 -1.58,3.05 -5.35,1.56 -6.19,-1.13 -0.91,-2.23 -2.24,2.2 -3.59,-0.19 0.08,-1.59 0.77,-4.65 -1.66,-4.47 -0.04,-1.89 5.08,-2.47 2,-4.81 -1.06,-1.58 -1.96,-3.49 -3.19,-5.19 -1.04,-0.38 -2.4,2.55 -3.06,0.19 2.11,-0.98 1.08,-3.94 -1.22,-3.09 -1.29,-0.86 0.45,-3.41 -2.28,-2.97 -2.36,-0.57 -4.25,-0.93 -6.75,-1.56 -1.95,0.11 -3.54,1.99 -2.16,3.66 -2.49,1.1 -5.44,0.72 -8.06,0.84 -2.13,-0.11 -4.95,0.4 -3.47,3.25 -0.93,1.29 0.2,-0.42 -1.34,-0.75 -2.2,0.32 -2.21,-2.86 -3.25,-3 0.17,2 -0.71,2.08 -1.81,0.91 -1.33,1.07 -2.8,2.86 -4.13,0.78 -1.05,0.35 -1.81,1.8 -3.16,0.44 -1.52,0.35 -3.33,0.3 -5.13,0.56 0.09,-1.31 1.53,-4.11 -0.41,-4.47 -0.29,2.73 -3.58,-0.65 -1.03,-0.91 -1.81,-2.12 -2.59,-4.78 -3.66,-7.41 -1.51,-0.41 -2.48,-0.8 -1.75,-2.59 -1.08,-1.86 -1.78,2.42 -3.78,1.16 -0.25,-1.72 -1.49,-3.76 -3.25,-2.47 -1.89,-0.87 2.48,-2.38 0.41,-3.69 2.2,-1.9 -1.21,-2.95 -1.41,-4.72 -1.76,-1.44 -2.82,-5.28 -5.84,-4 -1.36,1.45 -1.28,-1.99 -2.66,-1.97 z",
					    "region-21" : "m 440.11,60.78 c -1.24,1.53 -2.96,2.67 -4.19,4.19 -2.61,0.85 -1.45,3.67 -1.94,5.63 -0.38,2.67 -3.5,2.01 -5.25,3.06 -1.78,1.03 -3.51,2.66 -5.75,2.31 -2.01,-0.47 -4.03,-0.8 -5.94,-1.63 -2.18,-1.07 -5.68,1.32 -3.94,3.53 2.27,0.8 0.7,3.6 -0.09,5.06 -0.22,1.15 -0.72,3.46 -0.19,3.94 2.34,1.86 -1.58,4.31 -2.94,5.53 -2.32,0.59 -0.76,4.67 -3.53,3.88 -2.19,-0.91 -2.9,1.61 -1,2.56 0.93,1.15 0.03,2.2 0,3.28 2.33,1.24 -2.55,2.94 -0.59,4.91 1.73,1.58 -1.34,2.03 0.06,3.69 0.69,0.8 0.59,-0.01 0.25,0.72 -0.85,1.01 -1.06,4.16 -2.81,2.13 -1.58,-0.94 -4.15,-2.71 -5.56,-0.59 -0.47,1.86 -1.99,2.53 -3.66,1.63 -2.11,0.93 -4.61,1.62 -6.38,2.88 -0.53,2.28 1.53,4.25 0.5,6.59 1.8,0.71 2.48,2.18 3.97,3 -0.94,2.45 -4.12,0.39 -5.91,1.53 -1.7,1.66 2.41,4.39 -0.88,5.41 -2.23,2.44 5.5,0.7 2.69,3.66 -2.5,1.8 -2.99,5.43 -5.91,6.75 -2.49,1 -1.19,4.96 -2.88,6 -1.36,-0.13 -2.85,0.18 -1.28,1.25 -0.7,1.1 -2.96,2.55 -0.28,3.03 3,1.24 1.09,4.26 0.72,6.31 0.94,1.84 3.99,-0.47 4.72,2.19 -0.43,1.32 -0.78,0.84 -2.28,2.16 -2.73,0.52 0.34,3.89 -2.69,3.91 -1.65,-0.53 -1.6,0.54 -0.78,1.56 1.13,1.8 -3.04,0.96 -1.25,3.06 0.42,1.28 -0.32,2.48 1,3.47 -1.08,1.82 0.39,3.41 2.03,2.16 1.85,0.1 2.84,1.82 3.75,3.16 1.48,1.39 2.14,3.14 3.41,4.59 -1.41,1.17 0.78,2.63 -1.13,3.5 -1.3,1.27 0.05,1.69 1.09,0.97 1.77,0.49 1.43,4.12 3.66,2.69 0.94,-0.2 0.66,-2.76 2.03,-1.09 0.65,0.86 -0.95,2.77 1.09,2.38 2.02,1.3 1.81,4.19 3.03,6.09 1.58,0.78 1.71,2.31 0.5,2.91 0.54,1.51 1.71,0.27 1.97,-0.31 2.56,0.7 -1.28,5.4 2.13,4.31 1.91,-0.23 3.38,-0.23 5.06,0.09 0.59,-1.33 1.97,-1.11 2.56,0.19 1.58,-0.22 2.92,-3.3 4.19,-0.97 0.61,-0.58 -0.3,-2.64 1.34,-1.56 -0.48,2.55 3.68,3.96 3.75,0.78 1.55,-0.59 3.75,-0.44 5.59,-0.63 1.75,0.63 3.69,-0.42 5.56,-0.41 0.29,-1.14 -1.6,-2.56 0.47,-3.03 1.86,-2.3 4.6,1.04 6.56,-0.69 0.26,0.05 0.56,-0.18 0.28,0.09 0.25,2.41 5.64,0.09 3.81,3.34 -0.25,1.39 4.64,0.53 2.81,2.97 -1.68,0.97 -0.12,3.13 0.63,1.09 2.69,-1.66 2.17,3.12 4.06,3.69 1.18,1.84 2.43,3.98 -0.56,4.81 -1.81,0.95 -0.48,1.61 0.72,1.69 1.1,1.35 -1.34,5.62 1.63,4.31 1.63,-1.99 2.74,0.58 3.16,1.72 1.59,1.44 3.76,1.44 4.59,-0.72 0.9,0.19 0.25,2.48 2.06,2.53 0.69,1.12 2.71,1.18 1.56,2.66 0.3,2.71 2.08,0.27 3.03,-0.44 1.42,-0.65 2.31,1.81 2.88,-0.44 1.04,-1.74 1.03,-4.77 3.75,-4 1.6,-1.14 3.56,0.94 4.63,-1.41 1.53,-1.73 1.57,2.71 3.72,1.25 1.9,-0.14 2.95,-1.34 2.19,-3.25 1.43,-1.27 0.78,-2.68 -0.38,-3.66 -0.36,-1.86 1.28,-3.09 2.84,-2.78 0.09,-1.65 1.04,-3.14 2.78,-1.91 1.89,0.14 0.95,-4.54 3.66,-3.31 0.78,-1.86 -1.65,-5 -3.63,-3.16 -2.15,-0.87 0.65,-4.13 -1.69,-5.38 -2.08,-0.99 -3.29,-3.61 -5.72,-3.13 -0.78,-1.43 1.74,-1.98 1.19,-3.5 1.49,-1.43 -0.02,-4.04 2.66,-4.09 0.87,-2.59 -4.13,-1.95 -3.41,-4.16 0.23,-2.18 -2.45,-1.79 -3.16,-1.75 -1.8,-1.38 -2.09,-5 -4.84,-4.5 -0.93,1.04 -3.31,1.86 -2.44,-0.53 1.81,-1.67 -2.53,-1.7 -0.13,-2.75 3.11,-1.15 -1.07,-3.22 -1.19,-4.59 -2.32,-0.43 -3.08,-3.25 -5.75,-2.97 -2.2,-0.41 -3.45,-2.38 -5.41,-3.25 -1,-0.87 -2.09,-2.25 -3.63,-2.31 -0.33,-1.23 -1,-2.41 -1.94,-0.91 -2.48,0.33 -1.07,-3.27 -1.22,-4.5 -1.26,-1.72 1.65,-2.53 -0.66,-4.38 -1.02,-1.86 -5.77,-3.19 -3.53,-5.53 1.95,-1.47 -1.09,-4.18 1.13,-5.78 1.48,-1.5 6.06,-1.28 3.63,-4.44 0.08,-0.05 1.84,-2.53 -0.16,-3.06 -3.37,1.1 0.97,-2.04 -0.44,-3.47 0.13,-2.66 -3.6,-5.31 -1.69,-7.59 -0.05,-1.17 0.9,-1.42 -0.5,-2.91 1.43,-0.97 3.17,-1.86 4.5,-2.69 -1.52,-2 -1.1,-5.7 1.75,-6.16 1.39,-0.71 -1.19,-2.05 0.69,-2.81 0.81,-2.16 -1.48,-3.72 -1.84,-5.84 1.6,-0.81 1.14,-3.15 2,-4.25 -0.08,-2.31 2.07,-1.25 2.72,-0.03 1.75,-0.02 3.3,-0.06 4.41,1.56 2.3,0.19 2.64,-3.44 5.09,-3.19 1.49,-1.51 -0.92,-3.03 -1.94,-1.38 -2.45,-0.56 1.15,-3.54 -1.97,-4.44 -1.17,-1.71 -3.05,0.7 -4.53,-0.56 -1.26,-0.27 -1.05,-1.58 -2.38,-1.47 -0.88,-1.51 -1.1,-3.88 -3.5,-3.53 -2.22,-0.27 -3.52,-3.42 -5.97,-1.44 -1.59,0.26 -4.08,-0.13 -2.88,-2.28 -0.7,-1.6 -0.78,-3.23 0.38,-4.75 1.08,-2.94 -3.71,-2.9 -3.44,-5.22 1.66,-1.87 1.38,-4.63 2.13,-6.72 0.47,-1.55 1.75,-1.78 1.81,-3.63 0.26,-2.46 -2.55,-0.11 -3.06,-2.5 z",
					    "region-31" : "m 335.55,0 c -3.43,1.47 -6.98,2.66 -10.72,2.44 -3.1,0.89 -6.3,1.61 -9.19,3.03 0.8,1.28 6.97,-1.14 -2.34,-0.13 -4.67,0.52 -9.22,1.97 -13.53,3.78 -2.62,1.21 -3.81,4.27 -6.75,5 -3.31,1.16 0.87,5.45 -0.72,8.03 -1.1,2.07 -1.79,4.43 -1.13,6.75 0.28,2.42 0.02,4.96 1.31,7.03 -2.1,2.06 -0.71,6.36 -1.75,9.34 1.02,1.95 3.49,2.59 4.78,4.31 2.63,0.04 5.26,-2.82 7.88,-0.78 1.48,1.06 3.49,3.43 4.94,1.34 2.53,0.17 -1.7,2.81 1.25,2.84 1.83,1.47 5.46,1.23 4.91,4.31 1.83,1.66 4.06,1.56 6.16,0.28 1.49,0.74 2.98,-1.47 4.28,0.06 1.29,-0.11 0.37,-2.57 1.84,-0.78 1.06,2.83 2.17,-1.71 4.19,-0.09 1.81,-0.02 3.82,3.17 0.84,3.09 -2.82,0.39 -4.83,5.19 -1.25,5.81 0.43,-1.96 3.39,-4.56 4.69,-1.88 0.95,0.06 0.96,-2.21 2.38,-0.91 -1.29,2.63 2.5,1.38 3.75,2.66 1.01,0.02 2.8,1.43 1.69,-0.5 0.03,-2.85 2.71,-0.51 3.78,-0.19 0.17,1.65 -2.94,5.59 0.5,3.59 1.5,-1.55 3.47,-2 3.75,0.66 0.78,1.86 3.16,-1.88 4.69,-0.22 1.46,-0.95 3.63,-0.91 4.72,-0.15 1.9,1.74 3.89,2.45 5.94,1.56 2.26,-1.32 5.08,2.02 6.88,-0.69 2.98,0.44 6.13,1.89 8.41,-1.06 1.98,-0.29 4.46,2.95 5.69,-0.34 2.9,-1.43 5.98,1.3 9.03,1.19 1.53,2.96 3.47,-0.57 5.81,0.03 -1.87,3.96 3.7,3.72 6.25,4.13 2.29,-0.95 -0.65,-4.31 2.59,-4.78 2.82,-0.8 0.91,-4.83 -0.56,-5.75 -3.06,0.67 -0.12,-3.85 -0.06,-5.38 1.87,-1.24 2.82,-4.01 -0.19,-4.25 -1.07,4.16 -2.09,-2.66 -4.38,-2.69 -1.69,-3.72 -4.83,-0.59 -7.63,-0.72 -2.37,-0.85 -5.7,-2.48 -7.81,-0.09 -1.66,4.51 -4.18,-2.38 -2.94,-4.66 0.52,-3.52 -3.25,-7.39 -6.78,-5.75 -1.77,0.07 0.31,-3.59 -2.47,-2.13 -2.41,2.31 -6.09,2.01 -8.28,-0.47 -0.77,-2.54 -0.39,-5.31 -1.88,-7.78 0.28,-2.25 0.28,-4.4 -2.31,-5.22 -0.57,-2.79 -2.95,-5.34 -5.75,-3.47 -2.32,0.87 -5.89,0.77 -6.5,3.63 -1.2,3.14 -4.3,-0.53 -6.47,-0.63 -1.62,-2.75 -3.48,-6.45 -7.19,-5.84 -1.19,-1.96 -1.71,-5.46 -1.09,-7.13 2.22,-2.65 -1.65,-4.22 -2,-6.53 -0.27,-1.34 -0.16,-2.93 -1.25,-3.94 z",
					    "region-41" : "m 466.52,97.41 c -1.09,2.05 -3.62,1.84 -4.56,4.16 -2.06,1.9 -3.21,-2.61 -5.44,-0.84 -1.22,-0.12 -2.64,-3.24 -3.13,-0.5 0.16,1.18 -1.23,2.02 -0.94,3.53 -0.98,0.86 -1.69,1.56 -0.25,2.59 0.87,1.11 1.38,3 1.09,4.25 -1.92,0.65 1.05,2.67 -1.31,3 -1.85,0.5 -3.02,3.3 -1.5,4.84 2.03,2.44 -5.45,1.89 -3.13,4.72 1.73,1.94 -2.71,2.05 -0.97,4.19 1.12,2.15 2.37,4.53 2.09,7 -0.73,0.97 -0.79,2.06 0.63,1.56 1.91,0.63 0.24,2.81 -0.25,3.22 2.97,1.13 -0.51,3.94 -2.44,3.81 -2.83,0.92 -1.21,4.12 -1.41,5.91 -2.27,0.76 -1.56,3.13 0.5,3.44 0.78,2.04 3.85,2.48 3.34,4.91 -1.03,1.56 0.33,2.54 -0.66,4.19 -0.41,2.22 1.46,2.8 2.69,1.28 0.35,1.45 0.98,2.82 2.72,2.31 1.09,2.08 3.52,2.55 5.06,4.34 2.27,0.9 4.8,0.88 6.22,3.16 2.51,0.35 2.84,2.78 4.16,4.07 0.18,1.56 -4.48,1.85 -0.63,2.75 -1.78,1.06 -0.17,4.08 1.16,1.75 2.93,-1.33 3.22,2.39 4.88,3.84 0.91,1.42 2.93,-0.64 3.63,1.69 -0.71,2.15 1.42,2.14 2.78,2.94 0.78,1.08 1.51,2.72 -0.56,2.47 -0.84,1.28 -0.49,3.15 -1.59,4.28 0.81,1.2 -2.55,2.08 -0.53,2.81 2.09,-0.91 3.19,2.33 5.13,2.81 2.36,1.3 0.12,4.13 1.53,5.44 1.54,0.44 2.35,-2.59 2.84,-0.06 0.68,2.6 2.59,0.64 2.94,-0.97 2.15,-1.68 1.28,1.08 0.69,1.97 1.78,-0.62 3.6,-1.91 4.47,-3.91 1.23,-1.14 3.61,-1.49 4.97,-1.19 1.42,1.44 -0.11,4.06 2.34,4.41 1.59,2.64 3.59,-1.32 5.56,-0.06 2.15,-1.17 4.72,-0.41 6,1.59 0.64,1.74 1.57,3.2 3.34,1.75 1.6,-0.75 3.18,-4.53 5,-1.72 1.23,2.37 3.96,3.34 6.13,4.66 1.42,0.78 2.18,3.61 4.22,2 2.04,-0.21 3.21,-1.94 2.16,-3.75 1.27,-2.36 0.32,-6.03 2.66,-8.19 2.71,-0.63 2.22,-4.22 4.34,-5.63 2.03,-1.71 -0.83,-4.01 1.34,-5.81 1.63,-1.7 1.83,-4.2 3.22,-6.03 1.11,-1.35 2.74,-4.19 -0.06,-4.34 -1.71,0.99 -4.63,-1.26 -2.47,-2.78 -1.57,-2.1 1.28,-4.86 0.25,-7.13 -1.03,-0.23 -0.28,-1.19 -1,-1.44 -0.68,0.29 -0.14,-0.47 -0.44,-0.75 -0.4,-3.01 1.27,1.11 5.69,-1.94 2.54,-1.28 3.63,-5.48 3.97,-7.28 -3.58,-1.29 -0.16,-3.78 0.28,-6 1.57,-2.39 -1.82,-4.04 -3.41,-4.91 -0.92,-0.46 -2.85,-2.67 -3.34,-0.41 0.04,1.34 -2.72,3.67 -3.47,1.97 1.42,-1.19 -2.33,-1.17 -0.66,-2.88 0.58,-0.42 2.92,-0.77 1,-1.22 -1.9,0.22 -3.07,-2.28 -5.31,-2.09 0.36,-1.47 -1.95,-2.92 0.66,-2.5 -0.24,-2.46 3.11,-1.18 2.78,-3.66 0.97,-1.9 0.89,-5.07 2.81,-5.94 1.56,0.28 -0.21,2.24 1.03,3.06 0.44,2.29 3.08,1.43 4.38,2.97 2.08,-0.63 3.44,0.95 4.44,2.22 2.35,0.41 4.6,-1.02 6.97,-0.91 1.74,1.66 4.79,2.7 5.41,-0.5 0.03,-2.29 3.08,-4.05 1.91,-6.13 -1.64,-1.28 -4.25,-0.4 -4.94,-3.09 -1.46,-0.89 -0.27,-4.1 -2.88,-3.22 -1.94,-1.81 -3.96,-0.43 -5,1.53 -1.63,0.41 -2.99,2.35 -4.94,1.09 -2.43,0.91 -4.5,-0.47 -6.56,-1.34 -0.06,2.16 -3.18,2.67 -2.81,0 0.36,-3.27 -3.35,-4.29 -5.78,-4.78 -1.02,0.19 -3.84,-0.21 -2.5,1.88 0.56,3.34 -3.79,1.81 -5.53,1.16 -1.66,-0.89 1.41,-3.24 -1.34,-3.13 -1.25,-2.69 -3.38,-5.31 -5.63,-7.63 -0.97,-1.2 2,-2.73 -0.66,-3.56 -1.56,-1.24 -0.91,-3.44 -3.28,-4.09 -1.88,-1.38 -4.07,-1.79 -6.22,-0.88 -2.51,-0.28 -4,-3.64 -6.72,-2.88 l -0.16,0.03 -0.06,-0.03 c -2.5,-0.46 -3.78,2.24 -5.5,3.13 -2.04,0.13 -5.36,1.51 -5.56,-1.88 -0.59,-1.44 -4.32,-0.37 -1.75,-0.13 6.4,8.39 -4.28,8.77 0.41,3.13 1.39,-4.07 -3.95,-2.74 -4.75,-5.91 -0.79,-0.88 -1.98,-1.2 -3,-1.72 -1.67,3.08 -5.74,-1.97 -6.63,2.41 -1.05,-0.08 -3.37,-1.42 -4.28,0.56 -1.19,-0.11 -1.91,0.37 -2.25,1.13 -0.01,-0.13 -0.06,-0.34 -0.16,-0.63 -0.19,-2.1 -0.51,-4.34 -1.91,-6.25 -0.32,-0.62 -0.83,-1.2 -1.56,-1.31 z",
					    "region-42" : "m 544.17,133.28 c -1.58,0.23 -0.4,2.18 -1.72,3.13 -0.53,1.32 -0.49,4.02 -1.78,4.5 -1.51,0.02 -3.73,3.48 -1.63,4.38 1.94,0.49 3.53,1.75 5.28,2.28 -0.53,0.75 -3.05,0.85 -1.84,2.56 1.17,0.35 1.66,0.71 0.88,1.56 2.9,0.8 2.45,-4.08 5.06,-3.5 0.08,1.99 2.93,1.1 3.25,2.09 0.08,1.35 3.5,2.12 2,4.19 -0.63,1.68 -2.44,3.57 -2,5.16 0.83,1.05 2.94,0.71 1.31,2.25 -1,1.88 -1.1,4.47 -3.13,5.69 -1.49,1.59 -3.4,2.15 -5.47,1.5 -1.5,-0.11 -1.19,1.4 0.16,0.88 1.61,0.28 1.03,1.44 -0.22,1.38 1.72,1.32 0.19,3.7 0,5.66 -0.32,1.37 1.25,2.63 -0.53,3.53 0.55,1.82 2.88,1.71 4.34,1.38 0.98,0.08 0.7,1.6 0.76,2.69 -1.65,1.36 -2.24,2.73 -3.14,4.75 -0.4,1.82 -2.18,2.92 -2.53,4.75 -1.33,1.4 1.34,1.6 0.25,2.88 -0.93,1.83 -2.95,3.03 -3.06,5.22 -0.53,1.75 -3.15,1.49 -3.13,3.25 -0.66,1.37 -1.22,3.06 -0.75,4.66 -0.41,1.17 -1.67,2.16 -0.53,3.44 0.71,1.97 -2.41,1.71 -3.06,2.97 -0.01,2.42 2.59,2.3 4.19,3.09 1.23,0.9 2.75,1.35 3.94,2.28 0.75,1.15 0.29,2.81 0.84,4.22 0.01,1.63 -1.95,1.8 -1.63,3.66 -0.16,2.76 3.71,-0.49 3.81,2.34 0.66,1.17 1.29,2.33 2.22,3.25 -0.26,1.35 -0.34,3.3 1.72,2.78 1.73,0.11 -1.35,2.87 0.69,3.56 1.21,-0.48 1.97,0.75 2.56,1.19 1.4,-0.54 2.92,-1.49 4.44,-0.84 1.79,0.56 3.17,-0.74 4.38,-1.84 1.37,-0.81 -1.77,-2.29 0.34,-2.25 1.11,1.41 3.17,-0.21 2.09,-1.59 1.35,0.23 1.88,-1.32 0.41,-1.53 0.05,-1.19 2.26,-1.14 2.66,-2.5 2.32,-0.26 0.57,-3.01 -0.22,-4.06 -1.18,-1.03 -2.5,-2.49 -1.91,-4.19 1.12,-1 1.79,-2.5 0.84,-3.94 -0.75,-1.85 0.36,-3.7 1.28,-5.22 -0.2,-1.24 -0.59,-2.58 0.78,-3.28 -0.03,-1.74 0.43,-3.15 1.69,-4.41 0.99,-1.53 -0.1,-3.22 -1.28,-4.25 -1.68,-1.54 -0.58,-3.95 -0.53,-5.88 -0.05,-0.53 -0.05,-0.78 -0.52,-0.9 1,-0.35 2.23,-1.39 2.36,-3.07 0.77,-2.6 3.86,-4.17 3.5,-7.09 -0.49,-2.51 3.84,-2.86 2.31,-5.53 -0.61,-2.16 0.06,-4.43 1.13,-6.31 -0.44,-2.54 2.88,-3.38 1.72,-5.97 -0.24,-1.77 -0.1,-3.58 0.78,-5.16 1.2,-2.36 4.12,-3.13 5.56,-5.34 0.93,-1.46 0.85,-3.74 3.25,-3.38 0.47,-2.65 4.31,-1.9 4.34,-4.97 0.46,-2.67 2.02,-4.89 3.41,-7.16 0.58,-0.8 2.66,-1.95 0.47,-2 -1.97,-0.34 -4.12,-0.64 -5.91,-1.63 -1.91,-1.34 -4.3,-2.4 -6.34,-3.16 -1.93,0.68 -3.88,0.6 -5.59,-0.59 -2.1,0.71 -4.3,0.32 -6.53,0.56 -2.49,-0.15 -2.66,2.95 -3.53,4.63 -0.5,2.61 -2.99,2.85 -4.69,1.16 -1.92,-1.57 -4.22,0.44 -6.31,0.41 -2.52,0.72 -2.77,-3.33 -5.5,-2.31 -1.48,-0.12 -2.6,-1.74 -4.31,-1.56 -0.6,-1.43 -1.26,-3.09 -1.06,-4.38 l -0.28,-0.03 c -0.13,-6.3e-4 -0.24,-0.02 -0.34,0 z",
					    "region-43" : "m 499.95,202.88 c -1.48,1.05 -4.3,0.24 -4.72,2.59 -0.74,1.61 -2.57,2.53 -4.03,2.94 -0.34,-0.77 1.77,-2.53 -0.13,-2.5 -0.99,1.61 -1.89,3.2 -2.41,4.94 -2.68,-0.87 -1.8,3.12 -3.25,3.5 -1.3,-0.7 -3.4,-0.74 -2.75,1.31 -0.88,1.21 -3.26,-0.03 -3.16,2.25 -0.46,1.62 2.57,1.94 0.91,3.63 -0.98,1.52 0.5,4.17 -2.22,4.09 -1.57,0.85 -3.25,0.21 -3.47,-1.56 -1.37,0.18 -2.07,2.82 -3.91,1.41 -1.24,0.85 -3.18,-0.03 -4.03,1.06 0.43,1.42 -2.57,3.53 -0.44,4.25 0.89,-1.83 2.68,-2.69 3.75,-0.38 0.5,1.68 1.76,4.17 -0.06,5.47 -0.69,1.13 -1.66,2.49 -3.19,1.78 -1.3,0.54 0.73,1.51 -0.69,1.81 -0.5,1.32 2.31,0.21 2.25,1.84 -0.45,1.42 -0.22,4.26 1.97,3.19 1.12,0.71 0.51,3.24 0.09,4.44 2,0.74 2.24,2.05 1.59,1.69 -1.89,1.19 -1.39,3.31 -1.88,5.28 -0.64,0.76 -1.53,1.44 -0.91,2.59 -0.09,2.24 -2.24,3.15 -2.59,5.25 -0.78,2.29 -3.95,1.21 -5.03,3.41 -1.54,1.4 0.69,1.67 1.06,2.56 -1.89,0.73 -2.98,2.37 -2.5,4.31 0.13,1.42 2.54,-0.58 2.41,1.59 0.08,2.38 2.07,2.37 3.72,2 0.66,0.84 0.66,2.24 2.22,2.19 2.43,0.87 -0.07,3.08 -1.69,1.94 -1.17,0.08 -2.56,0.6 -3.38,1.25 0.11,1.68 4.22,2.09 1.78,4 -0.64,1.56 1.6,1.33 1.53,2.91 0.07,1.18 -0.14,1.58 0.81,2.44 0.19,1.36 1.44,2.54 -0.31,3.53 -0.67,0.75 0.36,2.66 -1.63,2.5 -1.19,0.8 -1.33,4.35 1,4.72 2.68,1.66 -1.11,3.55 -2.81,2.97 -1.59,0.44 -1.07,2.34 -1.06,3.44 1.19,0.84 3.27,1.23 2.47,3.03 0.35,0.78 1.76,2.87 2.41,1.16 0.08,1.37 1.23,2.02 2.19,1.81 0.32,1.28 -1.45,3.91 1.22,3.44 2.17,0.36 3.07,-1.83 4.78,-2.44 -0.05,-1.35 2.19,-3.35 2.53,-1.41 1.91,0.51 3.27,1.45 2.94,3.66 1.58,0.41 3.83,0.19 5.69,0.41 2.04,-0.37 2.87,-2.19 4.06,-3.31 1.59,-0.86 1.86,-3.63 3.84,-4.44 0.79,-1.41 2.47,-2.27 3.03,-3.69 -1,-2.03 0.83,-3.26 1.53,-4.97 0.09,-1.12 3.26,-3.18 0.84,-3.09 -0.77,-1.17 0.92,1.4 -0.09,-1.81 1.33,-1.8 3.4,-2.99 4.88,-4.72 1.55,-1.95 4.01,-2.54 5.84,-4.06 0.99,-1.82 5.28,-2.43 3.19,-5 -0.6,-1.98 1.83,-3.6 1.09,-5.66 -0.72,-1.81 -1.81,-3.32 0.31,-4.66 1.51,-1.44 3.86,-1.04 5.63,-2.09 1.98,-0.67 3.24,-2.47 4.94,-3.63 0.57,-0.92 -0.6,-3.57 1.72,-3.63 0.6,-2.37 3.98,-2.14 4.69,-4.5 1.07,-2.43 3.92,-3.29 5.06,-5.56 -0.36,-1.72 0.13,-3.47 2.28,-3.53 0.32,-1.83 3.75,-1.83 2.03,-3.97 -1.97,-1.19 -4.44,0.69 -6.69,0.22 -2.07,-0.27 1.24,-2.7 1.84,-3.41 0.22,-0.54 0.22,-1.05 0.13,-1.53 0.18,0.04 0.39,0.05 0.53,-0.03 0.83,-0.18 1.46,-0.79 2.25,-1.06 0.62,-0.6 -0.22,-1.43 -0.38,-2.06 -0.12,-0.36 -0.43,-1.06 0.19,-1.13 0.42,-0.08 0.79,-0.29 1.13,-0.47 0.96,0.2 1.83,0.89 2.88,0.69 1.1,-0.11 2.46,-0.61 2.44,-1.94 0.17,-1 -0.68,-1.62 -1.41,-2.13 -0.16,-0.46 -0.02,-1.1 -0.53,-1.41 -0.45,-0.55 -0.43,-1.7 -1.38,-1.72 -0.72,-0.12 -1.45,0.05 -1.94,0.59 -0.4,0.24 -0.29,-0.53 -0.59,-0.63 -0.31,-0.79 -0.35,-1.73 0.09,-2.47 0.16,-0.36 0.01,-1.12 0.63,-1 0.41,0.01 0.39,-0.35 0.41,-0.63 0.61,-1 -0.16,-2.16 -0.31,-3.16 0.23,-0.47 0.39,-1.05 -0.09,-1.44 -0.8,-1.1 -2.3,-1.18 -3.28,-2.06 -0.38,-0.36 -0.85,-0.58 -1.34,-0.59 -0.84,-0.67 -2.11,-0.35 -2.91,-1.13 -0.45,-0.63 -0.76,-1.4 -0.97,-2.13 -0.05,-0.04 -0.09,-0.07 -0.16,-0.06 -0.55,0.23 -0.51,0.99 -0.97,1.34 -1.01,0.37 3.92,2.85 -0.59,-1.63 -1.1,-2.17 -3.71,-2.73 -5.59,-4.25 -2.21,-0.35 -2.46,-4.75 -5,-2.91 -0.65,1.93 -4.86,4.56 -5.25,1.25 -0.87,-1.44 -2.51,-3.08 -4.28,-2.97 -1.68,0.96 -3.66,-0.19 -5.13,1.22 -1.27,1.15 -2.33,0.4 -2.88,-0.84 -3.16,0.23 -0.06,-3.73 -2.81,-4.53 z",
					    "region-94" : "m 591.58,517.94 c -2.35,-0.01 -1.43,2.88 -1.09,4.28 0.7,1.81 -2.51,2.79 -1.13,4.66 -0.49,1.37 -1.42,2.72 -0.13,3.97 0.7,1.67 0.72,3.54 0.53,5.31 -1.04,0.77 -0.93,3.86 -2.56,3.13 -0.73,-1.62 -2.11,-3.04 -4,-3.03 -1.86,-0.3 -3.96,-0.02 -5.19,1.56 -1.27,1.17 -0.87,3.32 -2.75,3.91 -1.35,0.75 -2.96,0.9 -4.47,0.78 -1.63,0.44 -2.75,1.92 -4.5,2.06 -1.08,1.11 -1.59,3.82 -3.63,2.5 -2.28,-0.27 -0.71,2.9 -2.75,3.25 -1.77,0.65 -1.33,2.55 -0.72,3.72 -0.66,1.21 -0.31,3.41 -2.41,2.97 -0.67,0.62 -0.74,2.12 -1.28,2.47 0.95,10e-4 -0.08,0.77 -1.5,0.16 -0.71,0.81 -0.14,3.58 1.19,2.03 1.32,-0.93 3.13,1.22 1,1.59 -0.01,1 1.97,1.01 2.59,2 2.68,1.95 -1.56,2.5 -3.03,2.97 -0.69,0.53 -3.15,0.81 -1.41,1.72 1.22,1.06 0.05,2.76 0.63,3.53 0.85,0.12 -0.88,1.14 0.28,1.69 0.95,1.15 2.74,1.36 3.78,2.44 2.1,-0.64 1.94,2.54 3.38,3.53 -0.02,1.76 -4.46,1.44 -3.63,3.94 0.68,2.57 -4.21,0.58 -2.84,2.81 1.83,0.44 -0.6,3.95 1.91,2.84 1.99,0.16 3.75,-0.51 5.28,-1.56 2.42,0.22 1.96,2.83 1.16,4.31 1.13,1.3 -2.4,1.11 -0.19,2.13 0.63,2.06 -3.8,1.36 -2.69,3.78 0.22,1.8 -4.34,1.47 -1.31,2.5 0.94,2.3 4.04,-1.68 4.06,1.25 0.12,1.47 2.47,0.33 3.34,1.44 1.12,-0.15 4.2,0.76 1.94,1.72 -0.87,1.64 -2.45,2.58 -4.41,2.63 -0.89,1.51 -0.2,3.28 -0.22,4.84 0.82,0.95 2.52,1.16 2.75,2.44 1.7,0.55 3,1.99 4.72,2.41 1.66,0.13 3.24,1.84 4.81,1.22 1.07,-1.21 -0.28,2.62 1.63,1.5 2.2,0.53 -1.6,3.3 1.28,3.44 1.58,0.19 2.49,2.77 4.28,1.63 0.89,-0.72 2.28,-4.22 0.03,-2.56 -0.14,-1.13 -0.24,-2.82 1.44,-3.19 2.06,-1.11 0.42,-3.26 1.22,-4.75 1.02,-1.38 3.26,-2.06 3.38,-3.97 -0.51,-2.43 -3.68,1.63 -3.16,-1.09 0.32,-2.31 2.97,-0.07 3.16,-2.25 2.28,-0.35 0.06,-3.4 2.22,-4.19 0.34,-1.98 -0.18,-4.06 0.09,-6.09 -1.11,-4.76 0.77,-0.51 0.31,-8.16 -0.47,-1.47 -0.31,-2.8 0.84,-3.88 0.84,-1.19 1.62,-2.44 2.13,-3.81 -1.58,-0.86 0.17,-2.38 1.22,-1.81 1.03,-1.08 2.34,-2.79 2.25,-4.19 -1,0.15 -2.17,-0.12 -0.78,-0.97 1.56,-1.35 1.27,-3.54 1.22,-5.38 0.1,-3.14 -0.11,-6.33 -0.94,-9.38 -0.32,-3.98 0.06,-7.96 -0.31,-11.94 0.24,-1.18 -0.65,-2.07 -1.69,-1.91 -1.43,-1.2 -1.57,-3.23 -2.16,-4.88 0.02,-1.82 0.21,-3.64 0.5,-5.44 0.35,-1.84 0.88,-3.67 1.41,-5.47 -0.1,-2.84 -1.11,-5.58 -1.06,-8.44 -0.76,-1.38 0.27,-3.67 -1.56,-4.41 -0.78,-0.33 -1.64,-0.33 -2.47,-0.31 z"
					}
				}
			}
		}
	);
})(jQuery);