/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.html;

import com.opensymphony.module.sitemesh.html.HTMLProcessorContext;
import com.opensymphony.module.sitemesh.html.State;
import com.opensymphony.module.sitemesh.html.Tag;
import com.opensymphony.module.sitemesh.html.TagRule;
import com.opensymphony.module.sitemesh.html.Text;
import com.opensymphony.module.sitemesh.html.TextFilter;
import com.opensymphony.module.sitemesh.html.tokenizer.TagTokenizer;
import com.opensymphony.module.sitemesh.html.tokenizer.TokenHandler;
import com.opensymphony.module.sitemesh.html.util.CharArray;
import com.opensymphony.module.sitemesh.util.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class HTMLProcessor {
    private final char[] in;
    private final CharArray out;
    private final State defaultState;
    private State currentState;
    private Writer outStream;

    public HTMLProcessor(char[] in, CharArray out) {
        this.currentState = this.defaultState = new State();
        this.in = in;
        this.out = out;
    }

    public HTMLProcessor(Reader in, Writer out) throws IOException {
        int n;
        this.currentState = this.defaultState = new State();
        CharArrayWriter inBuffer = new CharArrayWriter();
        char[] buffer = new char[2048];
        while (-1 != (n = in.read(buffer))) {
            inBuffer.write(buffer, 0, n);
        }
        this.in = inBuffer.toCharArray();
        this.out = new CharArray(2048);
        this.outStream = out;
    }

    public State defaultState() {
        return this.defaultState;
    }

    public void addRule(TagRule rule) {
        this.defaultState.addRule(rule);
    }

    public void process() throws IOException {
        TagTokenizer tokenizer = new TagTokenizer(this.in);
        final HTMLProcessorContext context = new HTMLProcessorContext(){
            private CharArray[] buffers = new CharArray[10];
            private int size;

            public State currentState() {
                return HTMLProcessor.this.currentState;
            }

            public void changeState(State newState) {
                HTMLProcessor.this.currentState = newState;
            }

            public void pushBuffer(CharArray buffer) {
                if (this.size == this.buffers.length) {
                    CharArray[] newBuffers = new CharArray[this.buffers.length * 2];
                    System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                    this.buffers = newBuffers;
                }
                this.buffers[this.size++] = buffer;
            }

            public CharArray currentBuffer() {
                return this.buffers[this.size - 1];
            }

            public CharArray popBuffer() {
                CharArray last = this.buffers[this.size - 1];
                this.buffers[--this.size] = null;
                return last;
            }

            public void mergeBuffer() {
                CharArray top = this.buffers[this.size - 1];
                CharArray nextDown = this.buffers[this.size - 2];
                nextDown.append(top);
            }
        };
        context.pushBuffer(this.out);
        tokenizer.start(new TokenHandler(){

            public boolean shouldProcessTag(String name) {
                return HTMLProcessor.this.currentState.shouldProcessTag(name.toLowerCase());
            }

            public void tag(Tag tag) {
                TagRule tagRule = HTMLProcessor.this.currentState.getRule(tag.getName().toLowerCase());
                tagRule.setContext(context);
                tagRule.process(tag);
            }

            public void text(Text text) {
                HTMLProcessor.this.currentState.handleText(text, context);
            }

            public void warning(String message, int line, int column) {
            }
        });
        this.defaultState.endOfState();
        if (this.outStream != null) {
            this.outStream.write(this.out.toString());
        }
    }

    public void addTextFilter(TextFilter textFilter) {
        this.currentState.addTextFilter(textFilter);
    }
}

