"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeAxesSizes = void 0;
var common_1 = require("../../../utils/common");
var dimensions_1 = require("../../../utils/dimensions");
var spec_1 = require("../state/utils/spec");
var axis_type_utils_1 = require("../utils/axis_type_utils");
var axis_utils_1 = require("../utils/axis_utils");
var nullPadding = function () { return ({ left: 0, right: 0, top: 0, bottom: 0 }); };
function computeAxesSizes(_a, axisDimensions, axesStyles, axisSpecs, smSpec) {
    var sharedAxesStyles = _a.axes, chartMargins = _a.chartMargins;
    var axisMainSize = nullPadding();
    var axisLabelOverflow = nullPadding();
    axisDimensions.forEach(function (_a, id) {
        var _b;
        var _c = _a.maxLabelBboxWidth, maxLabelBboxWidth = _c === void 0 ? 0 : _c, _d = _a.maxLabelBboxHeight, maxLabelBboxHeight = _d === void 0 ? 0 : _d, isHidden = _a.isHidden;
        var axisSpec = spec_1.getSpecsById(axisSpecs, id);
        if (!axisSpec || isHidden) {
            return;
        }
        var _e = (_b = axesStyles.get(id)) !== null && _b !== void 0 ? _b : sharedAxesStyles, tickLine = _e.tickLine, axisTitle = _e.axisTitle, axisPanelTitle = _e.axisPanelTitle, tickLabel = _e.tickLabel;
        var showTicks = axis_utils_1.shouldShowTicks(tickLine, axisSpec.hide);
        var position = axisSpec.position, title = axisSpec.title;
        var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
        var labelPaddingSum = tickLabel.visible ? labelPadding.inner + labelPadding.outer : 0;
        var tickDimension = showTicks ? tickLine.size + tickLine.padding : 0;
        var titleDimension = title ? axis_utils_1.getTitleDimension(axisTitle) : 0;
        var hasPanelTitle = Boolean(axis_type_utils_1.isVerticalAxis(position) ? smSpec === null || smSpec === void 0 ? void 0 : smSpec.splitVertically : smSpec === null || smSpec === void 0 ? void 0 : smSpec.splitHorizontally);
        var panelTitleDimension = hasPanelTitle ? axis_utils_1.getTitleDimension(axisPanelTitle) : 0;
        var axisDimension = labelPaddingSum + tickDimension + titleDimension + panelTitleDimension;
        var maxAxisHeight = tickLabel.visible ? maxLabelBboxHeight + axisDimension : axisDimension;
        var maxAxisWidth = tickLabel.visible ? maxLabelBboxWidth + axisDimension : axisDimension;
        switch (position) {
            case common_1.Position.Top:
                axisMainSize.top += maxAxisHeight + chartMargins.top;
                axisLabelOverflow.left = Math.max(axisLabelOverflow.left, maxLabelBboxWidth / 2);
                axisLabelOverflow.right = Math.max(axisLabelOverflow.right, maxLabelBboxWidth / 2);
                break;
            case common_1.Position.Bottom:
                axisMainSize.bottom += maxAxisHeight + chartMargins.bottom;
                axisLabelOverflow.left = Math.max(axisLabelOverflow.left, maxLabelBboxWidth / 2);
                axisLabelOverflow.right = Math.max(axisLabelOverflow.right, maxLabelBboxWidth / 2);
                break;
            case common_1.Position.Right:
                axisMainSize.right += maxAxisWidth + chartMargins.right;
                axisLabelOverflow.top = Math.max(axisLabelOverflow.top, maxLabelBboxHeight / 2);
                axisLabelOverflow.bottom = Math.max(axisLabelOverflow.bottom, maxLabelBboxHeight / 2);
                break;
            case common_1.Position.Left:
            default:
                axisMainSize.left += maxAxisWidth + chartMargins.left;
                axisLabelOverflow.top = Math.max(axisLabelOverflow.top, maxLabelBboxHeight / 2);
                axisLabelOverflow.bottom = Math.max(axisLabelOverflow.bottom, maxLabelBboxHeight / 2);
        }
    });
    var left = Math.max(axisLabelOverflow.left + chartMargins.left, axisMainSize.left);
    return {
        margin: {
            left: left - axisMainSize.left,
        },
        left: left,
        right: Math.max(axisLabelOverflow.right + chartMargins.right, axisMainSize.right),
        top: Math.max(axisLabelOverflow.top + chartMargins.top, axisMainSize.top),
        bottom: Math.max(axisLabelOverflow.bottom + chartMargins.bottom, axisMainSize.bottom),
    };
}
exports.computeAxesSizes = computeAxesSizes;
//# sourceMappingURL=axes_sizes.js.map