"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "euiSelectableTemplateSitewideFormatOptions", {
  enumerable: true,
  get: function get() {
    return _selectable_template_sitewide_option.euiSelectableTemplateSitewideFormatOptions;
  }
});
Object.defineProperty(exports, "euiSelectableTemplateSitewideRenderOptions", {
  enumerable: true,
  get: function get() {
    return _selectable_template_sitewide_option.euiSelectableTemplateSitewideRenderOptions;
  }
});
exports.ouiSelectableTemplateSitewideRenderOptions = exports.ouiSelectableTemplateSitewideFormatOptions = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../../icon");

var _avatar = require("../../avatar");

var _highlight = require("../../highlight");

var _selectable_template_sitewide_option = require("../../../eui_components/selectable/selectable_templates/selectable_template_sitewide_option");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var ouiSelectableTemplateSitewideFormatOptions = function ouiSelectableTemplateSitewideFormatOptions(options) {
  return options.map(function (item) {
    var title = item.label;

    if (item.meta && item.meta.length) {
      title += " \u2022".concat(renderOptionMeta(item.meta, '', true));
    }

    return _objectSpread(_objectSpread({
      key: item.label,
      title: title
    }, item), {}, {
      className: (0, _classnames.default)('ouiSelectableTemplateSitewide__listItem', item.className),
      prepend: item.icon ? /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, (0, _extends2.default)({
        color: "subdued",
        size: "l"
      }, item.icon)) : item.prepend,
      append: item.avatar ? /*#__PURE__*/_react.default.createElement(_avatar.OuiAvatar, (0, _extends2.default)({
        type: "space",
        size: "s"
      }, item.avatar)) : item.append
    });
  });
};

exports.ouiSelectableTemplateSitewideFormatOptions = ouiSelectableTemplateSitewideFormatOptions;

var ouiSelectableTemplateSitewideRenderOptions = function ouiSelectableTemplateSitewideRenderOptions(option, searchValue) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_highlight.OuiHighlight, {
    className: "ouiSelectableTemplateSitewide__listItemTitle",
    search: searchValue
  }, option.label), renderOptionMeta(option.meta, searchValue));
};

exports.ouiSelectableTemplateSitewideRenderOptions = ouiSelectableTemplateSitewideRenderOptions;

function renderOptionMeta(meta) {
  var searchValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var stringsOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (!meta || meta.length < 1) return;
  var metas = meta.map(function (meta) {
    var text = meta.text,
        highlightSearchString = meta.highlightSearchString,
        className = meta.className,
        rest = (0, _objectWithoutProperties2.default)(meta, ["text", "highlightSearchString", "className"]);

    if (stringsOnly) {
      return " ".concat(text);
    } // Start with the base and custom classes


    var metaClasses = (0, _classnames.default)('ouiSelectableTemplateSitewide__optionMeta', className); // If they provided a type, create the class and append

    if (meta.type) {
      metaClasses = (0, _classnames.default)(["ouiSelectableTemplateSitewide__optionMeta--".concat(meta.type)], metaClasses);
    }

    return /*#__PURE__*/_react.default.createElement(_highlight.OuiHighlight, (0, _extends2.default)({
      search: highlightSearchString ? searchValue : '',
      className: metaClasses,
      key: text
    }, rest), text);
  });
  return stringsOnly ? metas : /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiSelectableTemplateSitewide__optionMetasList"
  }, metas);
}
/* OUI -> EUI Aliases: Build-Time */