"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getAliases = getAliases;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class AliasServices {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getAliases", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const client = this.osDriver.asScoped(request);
        const [aliases, apiAccessible, errMsg] = await getAliases(client, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              aliases: aliases,
              totalAliases: aliases.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - AliasesService - getAliases:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }

}

exports.default = AliasServices;

async function getAliases({
  callAsCurrentUser: callWithRequest
}, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const aliasesResponse = await callWithRequest("cat.aliases", {
    format: "json",
    name: searchPattern
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        alias: []
      };
    }

    throw e;
  });
  return [aliasesResponse, accessible, errMsg];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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