"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenSearchObservabilityPlugin = OpenSearchObservabilityPlugin;

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function OpenSearchObservabilityPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.observability = components.clientAction.namespaceFactory();
  const observability = Client.prototype.observability.prototype; // Get Object

  observability.getObject = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT,
      params: {
        objectId: {
          type: 'string'
        },
        objectIdList: {
          type: 'string'
        },
        objectType: {
          type: 'string'
        },
        sortField: {
          type: 'string'
        },
        sortOrder: {
          type: 'string'
        },
        fromIndex: {
          type: 'number'
        },
        maxItems: {
          type: 'number'
        },
        name: {
          type: 'string'
        },
        lastUpdatedTimeMs: {
          type: 'string'
        },
        createdTimeMs: {
          type: 'string'
        }
      }
    },
    method: 'GET'
  }); // Get Object by Id

  observability.getObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  }); // Create new Object

  observability.createObject = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT
    },
    method: 'POST',
    needBody: true
  }); // Update Object by Id

  observability.updateObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  }); // Delete Object by Id

  observability.deleteObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  }); // Delete Object by Id List

  observability.deleteObjectByIdList = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT,
      params: {
        objectIdList: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  observability.getJobStatus = clientAction({
    url: {
      fmt: `${_shared.JOBS_ENDPOINT_BASE}/<%=queryId%>`,
      req: {
        queryId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  observability.runDirectQuery = clientAction({
    url: {
      fmt: `${_shared.JOBS_ENDPOINT_BASE}`
    },
    method: 'POST',
    needBody: true
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9wZW5zZWFyY2hfb2JzZXJ2YWJpbGl0eV9wbHVnaW4udHMiXSwibmFtZXMiOlsiT3BlblNlYXJjaE9ic2VydmFiaWxpdHlQbHVnaW4iLCJDbGllbnQiLCJjb25maWciLCJjb21wb25lbnRzIiwiY2xpZW50QWN0aW9uIiwiZmFjdG9yeSIsInByb3RvdHlwZSIsIm9ic2VydmFiaWxpdHkiLCJuYW1lc3BhY2VGYWN0b3J5IiwiZ2V0T2JqZWN0IiwidXJsIiwiZm10IiwiT1BFTlNFQVJDSF9QQU5FTFNfQVBJIiwiT0JKRUNUIiwicGFyYW1zIiwib2JqZWN0SWQiLCJ0eXBlIiwib2JqZWN0SWRMaXN0Iiwib2JqZWN0VHlwZSIsInNvcnRGaWVsZCIsInNvcnRPcmRlciIsImZyb21JbmRleCIsIm1heEl0ZW1zIiwibmFtZSIsImxhc3RVcGRhdGVkVGltZU1zIiwiY3JlYXRlZFRpbWVNcyIsIm1ldGhvZCIsImdldE9iamVjdEJ5SWQiLCJyZXEiLCJyZXF1aXJlZCIsImNyZWF0ZU9iamVjdCIsIm5lZWRCb2R5IiwidXBkYXRlT2JqZWN0QnlJZCIsImRlbGV0ZU9iamVjdEJ5SWQiLCJkZWxldGVPYmplY3RCeUlkTGlzdCIsImdldEpvYlN0YXR1cyIsIkpPQlNfRU5EUE9JTlRfQkFTRSIsInF1ZXJ5SWQiLCJydW5EaXJlY3RRdWVyeSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBSU8sU0FBU0EsNkJBQVQsQ0FBdUNDLE1BQXZDLEVBQW9EQyxNQUFwRCxFQUFpRUMsVUFBakUsRUFBa0Y7QUFDdkYsUUFBTUMsWUFBWSxHQUFHRCxVQUFVLENBQUNDLFlBQVgsQ0FBd0JDLE9BQTdDO0FBRUFKLEVBQUFBLE1BQU0sQ0FBQ0ssU0FBUCxDQUFpQkMsYUFBakIsR0FBaUNKLFVBQVUsQ0FBQ0MsWUFBWCxDQUF3QkksZ0JBQXhCLEVBQWpDO0FBQ0EsUUFBTUQsYUFBYSxHQUFHTixNQUFNLENBQUNLLFNBQVAsQ0FBaUJDLGFBQWpCLENBQStCRCxTQUFyRCxDQUp1RixDQU12Rjs7QUFDQUMsRUFBQUEsYUFBYSxDQUFDRSxTQUFkLEdBQTBCTCxZQUFZLENBQUM7QUFDckNNLElBQUFBLEdBQUcsRUFBRTtBQUNIQyxNQUFBQSxHQUFHLEVBQUVDLDhCQUFzQkMsTUFEeEI7QUFFSEMsTUFBQUEsTUFBTSxFQUFFO0FBQ05DLFFBQUFBLFFBQVEsRUFBRTtBQUNSQyxVQUFBQSxJQUFJLEVBQUU7QUFERSxTQURKO0FBSU5DLFFBQUFBLFlBQVksRUFBRTtBQUNaRCxVQUFBQSxJQUFJLEVBQUU7QUFETSxTQUpSO0FBT05FLFFBQUFBLFVBQVUsRUFBRTtBQUNWRixVQUFBQSxJQUFJLEVBQUU7QUFESSxTQVBOO0FBVU5HLFFBQUFBLFNBQVMsRUFBRTtBQUNUSCxVQUFBQSxJQUFJLEVBQUU7QUFERyxTQVZMO0FBYU5JLFFBQUFBLFNBQVMsRUFBRTtBQUNUSixVQUFBQSxJQUFJLEVBQUU7QUFERyxTQWJMO0FBZ0JOSyxRQUFBQSxTQUFTLEVBQUU7QUFDVEwsVUFBQUEsSUFBSSxFQUFFO0FBREcsU0FoQkw7QUFtQk5NLFFBQUFBLFFBQVEsRUFBRTtBQUNSTixVQUFBQSxJQUFJLEVBQUU7QUFERSxTQW5CSjtBQXNCTk8sUUFBQUEsSUFBSSxFQUFFO0FBQ0pQLFVBQUFBLElBQUksRUFBRTtBQURGLFNBdEJBO0FBeUJOUSxRQUFBQSxpQkFBaUIsRUFBRTtBQUNqQlIsVUFBQUEsSUFBSSxFQUFFO0FBRFcsU0F6QmI7QUE0Qk5TLFFBQUFBLGFBQWEsRUFBRTtBQUNiVCxVQUFBQSxJQUFJLEVBQUU7QUFETztBQTVCVDtBQUZMLEtBRGdDO0FBb0NyQ1UsSUFBQUEsTUFBTSxFQUFFO0FBcEM2QixHQUFELENBQXRDLENBUHVGLENBOEN2Rjs7QUFDQW5CLEVBQUFBLGFBQWEsQ0FBQ29CLGFBQWQsR0FBOEJ2QixZQUFZLENBQUM7QUFDekNNLElBQUFBLEdBQUcsRUFBRTtBQUNIQyxNQUFBQSxHQUFHLEVBQUcsR0FBRUMsOEJBQXNCQyxNQUFPLGdCQURsQztBQUVIZSxNQUFBQSxHQUFHLEVBQUU7QUFDSGIsUUFBQUEsUUFBUSxFQUFFO0FBQ1JDLFVBQUFBLElBQUksRUFBRSxRQURFO0FBRVJhLFVBQUFBLFFBQVEsRUFBRTtBQUZGO0FBRFA7QUFGRixLQURvQztBQVV6Q0gsSUFBQUEsTUFBTSxFQUFFO0FBVmlDLEdBQUQsQ0FBMUMsQ0EvQ3VGLENBNER2Rjs7QUFDQW5CLEVBQUFBLGFBQWEsQ0FBQ3VCLFlBQWQsR0FBNkIxQixZQUFZLENBQUM7QUFDeENNLElBQUFBLEdBQUcsRUFBRTtBQUNIQyxNQUFBQSxHQUFHLEVBQUVDLDhCQUFzQkM7QUFEeEIsS0FEbUM7QUFJeENhLElBQUFBLE1BQU0sRUFBRSxNQUpnQztBQUt4Q0ssSUFBQUEsUUFBUSxFQUFFO0FBTDhCLEdBQUQsQ0FBekMsQ0E3RHVGLENBcUV2Rjs7QUFDQXhCLEVBQUFBLGFBQWEsQ0FBQ3lCLGdCQUFkLEdBQWlDNUIsWUFBWSxDQUFDO0FBQzVDTSxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFHLEdBQUVDLDhCQUFzQkMsTUFBTyxnQkFEbEM7QUFFSGUsTUFBQUEsR0FBRyxFQUFFO0FBQ0hiLFFBQUFBLFFBQVEsRUFBRTtBQUNSQyxVQUFBQSxJQUFJLEVBQUUsUUFERTtBQUVSYSxVQUFBQSxRQUFRLEVBQUU7QUFGRjtBQURQO0FBRkYsS0FEdUM7QUFVNUNILElBQUFBLE1BQU0sRUFBRSxLQVZvQztBQVc1Q0ssSUFBQUEsUUFBUSxFQUFFO0FBWGtDLEdBQUQsQ0FBN0MsQ0F0RXVGLENBb0Z2Rjs7QUFDQXhCLEVBQUFBLGFBQWEsQ0FBQzBCLGdCQUFkLEdBQWlDN0IsWUFBWSxDQUFDO0FBQzVDTSxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFHLEdBQUVDLDhCQUFzQkMsTUFBTyxnQkFEbEM7QUFFSGUsTUFBQUEsR0FBRyxFQUFFO0FBQ0hiLFFBQUFBLFFBQVEsRUFBRTtBQUNSQyxVQUFBQSxJQUFJLEVBQUUsUUFERTtBQUVSYSxVQUFBQSxRQUFRLEVBQUU7QUFGRjtBQURQO0FBRkYsS0FEdUM7QUFVNUNILElBQUFBLE1BQU0sRUFBRTtBQVZvQyxHQUFELENBQTdDLENBckZ1RixDQWtHdkY7O0FBQ0FuQixFQUFBQSxhQUFhLENBQUMyQixvQkFBZCxHQUFxQzlCLFlBQVksQ0FBQztBQUNoRE0sSUFBQUEsR0FBRyxFQUFFO0FBQ0hDLE1BQUFBLEdBQUcsRUFBRUMsOEJBQXNCQyxNQUR4QjtBQUVIQyxNQUFBQSxNQUFNLEVBQUU7QUFDTkcsUUFBQUEsWUFBWSxFQUFFO0FBQ1pELFVBQUFBLElBQUksRUFBRSxRQURNO0FBRVphLFVBQUFBLFFBQVEsRUFBRTtBQUZFO0FBRFI7QUFGTCxLQUQyQztBQVVoREgsSUFBQUEsTUFBTSxFQUFFO0FBVndDLEdBQUQsQ0FBakQ7QUFhQW5CLEVBQUFBLGFBQWEsQ0FBQzRCLFlBQWQsR0FBNkIvQixZQUFZLENBQUM7QUFDeENNLElBQUFBLEdBQUcsRUFBRTtBQUNIQyxNQUFBQSxHQUFHLEVBQUcsR0FBRXlCLDBCQUFtQixlQUR4QjtBQUVIUixNQUFBQSxHQUFHLEVBQUU7QUFDSFMsUUFBQUEsT0FBTyxFQUFFO0FBQ1ByQixVQUFBQSxJQUFJLEVBQUUsUUFEQztBQUVQYSxVQUFBQSxRQUFRLEVBQUU7QUFGSDtBQUROO0FBRkYsS0FEbUM7QUFVeENILElBQUFBLE1BQU0sRUFBRTtBQVZnQyxHQUFELENBQXpDO0FBYUFuQixFQUFBQSxhQUFhLENBQUMrQixjQUFkLEdBQStCbEMsWUFBWSxDQUFDO0FBQzFDTSxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFHLEdBQUV5QiwwQkFBbUI7QUFEeEIsS0FEcUM7QUFJMUNWLElBQUFBLE1BQU0sRUFBRSxNQUprQztBQUsxQ0ssSUFBQUEsUUFBUSxFQUFFO0FBTGdDLEdBQUQsQ0FBM0M7QUFPRCIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgSk9CU19FTkRQT0lOVF9CQVNFLCBPUEVOU0VBUkNIX1BBTkVMU19BUEkgfSBmcm9tICcuLi8uLi9jb21tb24vY29uc3RhbnRzL3NoYXJlZCc7XG5cbmV4cG9ydCBmdW5jdGlvbiBPcGVuU2VhcmNoT2JzZXJ2YWJpbGl0eVBsdWdpbihDbGllbnQ6IGFueSwgY29uZmlnOiBhbnksIGNvbXBvbmVudHM6IGFueSkge1xuICBjb25zdCBjbGllbnRBY3Rpb24gPSBjb21wb25lbnRzLmNsaWVudEFjdGlvbi5mYWN0b3J5O1xuXG4gIENsaWVudC5wcm90b3R5cGUub2JzZXJ2YWJpbGl0eSA9IGNvbXBvbmVudHMuY2xpZW50QWN0aW9uLm5hbWVzcGFjZUZhY3RvcnkoKTtcbiAgY29uc3Qgb2JzZXJ2YWJpbGl0eSA9IENsaWVudC5wcm90b3R5cGUub2JzZXJ2YWJpbGl0eS5wcm90b3R5cGU7XG5cbiAgLy8gR2V0IE9iamVjdFxuICBvYnNlcnZhYmlsaXR5LmdldE9iamVjdCA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IE9QRU5TRUFSQ0hfUEFORUxTX0FQSS5PQkpFQ1QsXG4gICAgICBwYXJhbXM6IHtcbiAgICAgICAgb2JqZWN0SWQ6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSxcbiAgICAgICAgb2JqZWN0SWRMaXN0OiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0sXG4gICAgICAgIG9iamVjdFR5cGU6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgfSxcbiAgICAgICAgc29ydEZpZWxkOiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0sXG4gICAgICAgIHNvcnRPcmRlcjoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9LFxuICAgICAgICBmcm9tSW5kZXg6IHtcbiAgICAgICAgICB0eXBlOiAnbnVtYmVyJyxcbiAgICAgICAgfSxcbiAgICAgICAgbWF4SXRlbXM6IHtcbiAgICAgICAgICB0eXBlOiAnbnVtYmVyJyxcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZToge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9LFxuICAgICAgICBsYXN0VXBkYXRlZFRpbWVNczoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9LFxuICAgICAgICBjcmVhdGVkVGltZU1zOiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0aG9kOiAnR0VUJyxcbiAgfSk7XG5cbiAgLy8gR2V0IE9iamVjdCBieSBJZFxuICBvYnNlcnZhYmlsaXR5LmdldE9iamVjdEJ5SWQgPSBjbGllbnRBY3Rpb24oe1xuICAgIHVybDoge1xuICAgICAgZm10OiBgJHtPUEVOU0VBUkNIX1BBTkVMU19BUEkuT0JKRUNUfS88JT1vYmplY3RJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBvYmplY3RJZDoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIHJlcXVpcmVkOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIG1ldGhvZDogJ0dFVCcsXG4gIH0pO1xuXG4gIC8vIENyZWF0ZSBuZXcgT2JqZWN0XG4gIG9ic2VydmFiaWxpdHkuY3JlYXRlT2JqZWN0ID0gY2xpZW50QWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogT1BFTlNFQVJDSF9QQU5FTFNfQVBJLk9CSkVDVCxcbiAgICB9LFxuICAgIG1ldGhvZDogJ1BPU1QnLFxuICAgIG5lZWRCb2R5OiB0cnVlLFxuICB9KTtcblxuICAvLyBVcGRhdGUgT2JqZWN0IGJ5IElkXG4gIG9ic2VydmFiaWxpdHkudXBkYXRlT2JqZWN0QnlJZCA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke09QRU5TRUFSQ0hfUEFORUxTX0FQSS5PQkpFQ1R9LzwlPW9iamVjdElkJT5gLFxuICAgICAgcmVxOiB7XG4gICAgICAgIG9iamVjdElkOiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0aG9kOiAnUFVUJyxcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgfSk7XG5cbiAgLy8gRGVsZXRlIE9iamVjdCBieSBJZFxuICBvYnNlcnZhYmlsaXR5LmRlbGV0ZU9iamVjdEJ5SWQgPSBjbGllbnRBY3Rpb24oe1xuICAgIHVybDoge1xuICAgICAgZm10OiBgJHtPUEVOU0VBUkNIX1BBTkVMU19BUEkuT0JKRUNUfS88JT1vYmplY3RJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBvYmplY3RJZDoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIHJlcXVpcmVkOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIG1ldGhvZDogJ0RFTEVURScsXG4gIH0pO1xuXG4gIC8vIERlbGV0ZSBPYmplY3QgYnkgSWQgTGlzdFxuICBvYnNlcnZhYmlsaXR5LmRlbGV0ZU9iamVjdEJ5SWRMaXN0ID0gY2xpZW50QWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogT1BFTlNFQVJDSF9QQU5FTFNfQVBJLk9CSkVDVCxcbiAgICAgIHBhcmFtczoge1xuICAgICAgICBvYmplY3RJZExpc3Q6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBtZXRob2Q6ICdERUxFVEUnLFxuICB9KTtcblxuICBvYnNlcnZhYmlsaXR5LmdldEpvYlN0YXR1cyA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0pPQlNfRU5EUE9JTlRfQkFTRX0vPCU9cXVlcnlJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBxdWVyeUlkOiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0aG9kOiAnR0VUJyxcbiAgfSk7XG5cbiAgb2JzZXJ2YWJpbGl0eS5ydW5EaXJlY3RRdWVyeSA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0pPQlNfRU5EUE9JTlRfQkFTRX1gLFxuICAgIH0sXG4gICAgbWV0aG9kOiAnUE9TVCcsXG4gICAgbmVlZEJvZHk6IHRydWUsXG4gIH0pO1xufVxuIl19