"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRelevancePlugin = void 0;

var _operators = require("rxjs/operators");

var _routes = require("./routes");

var _metrics_service = require("./metrics/metrics_service");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class SearchRelevancePlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "config$", void 0);

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "metricsService", void 0);

    this.config$ = this.initializerContext.config.create();
    this.logger = this.initializerContext.logger.get();
    this.metricsService = new _metrics_service.MetricsService(this.logger.get('metrics-service'));
  }

  async setup(core) {
    this.logger.debug('SearchRelevance: Setup');
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const metricsService = this.metricsService.setup(config.metrics.metricInterval, config.metrics.windowSize);
    const router = core.http.createRouter();
    const opensearchSearchRelevanceClient = core.opensearch.legacy.createClient('opensearch_search_relevance'); // @ts-ignore

    core.http.registerRouteHandlerContext('searchRelevance', (context, request) => {
      return {
        logger: this.logger,
        relevancyWorkbenchClient: opensearchSearchRelevanceClient,
        metricsService: metricsService
      };
    }); // Register server side APIs

    (0, _routes.defineRoutes)(router);
    return {};
  }

  start(core) {
    this.logger.debug('SearchRelevance: Started');
    return {};
  }

  stop() {}

}

exports.SearchRelevancePlugin = SearchRelevancePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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