/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.logging.Logger;
import tr.extract.Extract;
import tr.model.Data;
import tr.model.information.Information;

public class ExtractReferences {
    private static final Logger LOG = Logger.getLogger("tr.extract");
    private static final DateFormat df = Constants.DATE_FORMAT_FIXED;

    public static void process(Data data, File xmlfile) {
        try {
            Writer out = ExtractReferences.initialise(xmlfile);
            ExtractReferences.process(data, out);
            ExtractReferences.finalise(out);
        }
        catch (Exception ex) {
            LOG.severe("Extracting data failed: " + ex.getMessage());
        }
    }

    private static Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        return out;
    }

    private static void finalise(Writer out) throws Exception {
        out.flush();
        out.close();
    }

    public static void process(Data data, Writer out) {
        try {
            LOG.info("Extracting references ... ");
            ExtractReferences.writeReferences(data, out);
            LOG.info("Extracting references ... done");
        }
        catch (Exception ex) {
            LOG.severe("Extracting references failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static void writeReferences(Data data, Writer out) throws Exception {
        out.write("<references>\r\n");
        for (Information reference : data.getInformationManager().list()) {
            out.write("<reference>\r\n");
            out.write("<created>" + df.format(reference.getCreated()) + "</created>\r\n");
            out.write("<descr>" + ExtractReferences.escape(reference.getDescription()) + "</descr>\r\n");
            out.write("<topic>" + ExtractReferences.escape(reference.getTopic().getName()) + "</topic>\r\n");
            out.write("<notes>" + ExtractReferences.escape(reference.getNotes().trim()) + "</notes>\r\n");
            out.write("</reference>\r\n");
        }
        out.write("</references>\r\n");
    }

    private static String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }
}

