/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAClientKeyExchangeSerializer<T extends RSAClientKeyExchangeMessage>
extends ClientKeyExchangeSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public RSAClientKeyExchangeSerializer(T message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing RSAClientKeyExchangeMessage");
        if (!this.version.isSSL()) {
            this.writeSerializedPublicKeyLength(this.msg);
        }
        this.writeSerializedPublickey(this.msg);
        return this.getAlreadySerialized();
    }

    protected byte[] serializeRsaParams() {
        if (!this.version.isSSL()) {
            this.writeSerializedPublicKeyLength(this.msg);
        }
        this.writeSerializedPublickey(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSerializedPublicKeyLength(T msg) {
        this.appendInt((Integer)((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue(), 2);
        LOGGER.debug("SerializedPublicKeyLength: " + ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    private void writeSerializedPublickey(T msg) {
        this.appendBytes((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
        LOGGER.debug("SerializedPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue())));
    }
}

