/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.QueryDocumentSnapshot;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DocumentChange {
    private final Type type;
    private final QueryDocumentSnapshot document;
    private final int oldIndex;
    private final int newIndex;

    DocumentChange(QueryDocumentSnapshot document, Type type, int oldIndex, int newIndex) {
        this.type = type;
        this.document = document;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Nonnull
    public QueryDocumentSnapshot getDocument() {
        return this.document;
    }

    public int getOldIndex() {
        return this.oldIndex;
    }

    public int getNewIndex() {
        return this.newIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentChange that = (DocumentChange)obj;
        return this.oldIndex == that.oldIndex && this.newIndex == that.newIndex && this.type == that.type && Objects.equals(this.document, that.document);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.document, this.oldIndex, this.newIndex});
    }

    public static enum Type {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

