/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgementHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcknowledgementHandler.class);
    private List<Entry> queue;
    private final Set<Object> waiting = new HashSet<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        LinkedList<Entry> output = new LinkedList<Entry>();
        AcknowledgementHandler acknowledgementHandler = this;
        synchronized (acknowledgementHandler) {
            if (msg instanceof Event) {
                Event event;
                if (msg instanceof EventReceived) {
                    LOGGER.debug("Event received");
                    if (this.queue == null) {
                        this.queue = new LinkedList<Entry>();
                    }
                } else if (msg instanceof EventDecoded) {
                    event = (EventDecoded)msg;
                    LOGGER.debug("Event decoded {}", (Object)((EventDecoded)event).getObjects().size());
                    this.waiting.addAll(((EventDecoded)event).getObjects());
                } else if (msg instanceof EventHandled) {
                    event = (EventHandled)msg;
                    LOGGER.debug("Event handled");
                    this.waiting.remove(((EventHandled)event).getObject());
                }
                if (!(msg instanceof EventReceived) && this.waiting.isEmpty()) {
                    output.addAll(this.queue);
                    this.queue = null;
                }
            } else if (this.queue != null) {
                LOGGER.debug("Message queued");
                this.queue.add(new Entry(msg, promise));
            } else {
                LOGGER.debug("Message sent");
                output.add(new Entry(msg, promise));
            }
        }
        for (Entry entry : output) {
            ctx.write(entry.getMessage(), entry.getPromise());
        }
    }

    public static interface Event {
    }

    public static class EventReceived
    implements Event {
    }

    public static class EventDecoded
    implements Event {
        private final Collection<Object> objects;

        public EventDecoded(Collection<Object> objects) {
            this.objects = objects;
        }

        public Collection<Object> getObjects() {
            return this.objects;
        }
    }

    public static class EventHandled
    implements Event {
        private final Object object;

        public EventHandled(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    private static final class Entry {
        private final Object message;
        private final ChannelPromise promise;

        private Entry(Object message, ChannelPromise promise) {
            this.message = message;
            this.promise = promise;
        }

        public Object getMessage() {
            return this.message;
        }

        public ChannelPromise getPromise() {
            return this.promise;
        }
    }
}

