/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import org.traccar.LifecycleObject;
import org.traccar.schedule.ScheduleTask;
import org.traccar.schedule.TaskClearStatus;
import org.traccar.schedule.TaskDeleteTemporary;
import org.traccar.schedule.TaskDeviceInactivityCheck;
import org.traccar.schedule.TaskExpirations;
import org.traccar.schedule.TaskHealthCheck;
import org.traccar.schedule.TaskReports;
import org.traccar.schedule.TaskWebSocketKeepalive;

@Singleton
public class ScheduleManager
implements LifecycleObject {
    private final Injector injector;
    private ScheduledExecutorService executor;

    @Inject
    public ScheduleManager(Injector injector) {
        this.injector = injector;
    }

    @Override
    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        Stream.of(TaskHealthCheck.class, TaskClearStatus.class, TaskExpirations.class, TaskDeleteTemporary.class, TaskReports.class, TaskDeviceInactivityCheck.class, TaskWebSocketKeepalive.class).forEachOrdered(task -> ((ScheduleTask)this.injector.getInstance(task)).schedule(this.executor));
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

