/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.json;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.exceptions.JedisException;

public final class JsonBuilderFactory {
    public static final Builder<Class<?>> JSON_TYPE = new Builder<Class<?>>(){

        @Override
        public Class<?> build(Object data) {
            String str;
            if (data == null) {
                return null;
            }
            switch (str = BuilderFactory.STRING.build(data)) {
                case "null": {
                    return null;
                }
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "integer": {
                    return Integer.TYPE;
                }
                case "number": {
                    return Float.TYPE;
                }
                case "string": {
                    return String.class;
                }
                case "object": {
                    return Object.class;
                }
                case "array": {
                    return List.class;
                }
            }
            throw new JedisException("Unknown type: " + str);
        }

        public String toString() {
            return "Class<?>";
        }
    };
    public static final Builder<List<Class<?>>> JSON_TYPE_LIST = new Builder<List<Class<?>>>(){

        @Override
        public List<Class<?>> build(Object data) {
            List list = (List)data;
            ArrayList classes = new ArrayList(list.size());
            for (Object elem : list) {
                try {
                    classes.add(JSON_TYPE.build(elem));
                }
                catch (JedisException je) {
                    classes.add(null);
                }
            }
            return classes;
        }
    };
    public static final Builder<List<List<Class<?>>>> JSON_TYPE_RESPONSE_RESP3 = new Builder<List<List<Class<?>>>>(){

        @Override
        public List<List<Class<?>>> build(Object data) {
            return ((List)data).stream().map(JSON_TYPE_LIST::build).collect(Collectors.toList());
        }
    };
    public static final Builder<List<Class<?>>> JSON_TYPE_RESPONSE_RESP3_COMPATIBLE = new Builder<List<Class<?>>>(){

        @Override
        public List<Class<?>> build(Object data) {
            List<List<Class<?>>> fullReply = JSON_TYPE_RESPONSE_RESP3.build(data);
            return fullReply == null ? null : fullReply.get(0);
        }
    };
    public static final Builder<Object> JSON_OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            if (data == null) {
                return null;
            }
            if (!(data instanceof byte[])) {
                return data;
            }
            String str = BuilderFactory.STRING.build(data);
            if (str.charAt(0) == '{') {
                try {
                    return new JSONObject(str);
                }
                catch (Exception exception) {
                }
            } else if (str.charAt(0) == '[') {
                try {
                    return new JSONArray(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return str;
        }
    };
    public static final Builder<JSONArray> JSON_ARRAY = new Builder<JSONArray>(){

        @Override
        public JSONArray build(Object data) {
            if (data == null) {
                return null;
            }
            String str = BuilderFactory.STRING.build(data);
            try {
                return new JSONArray(str);
            }
            catch (JSONException ex) {
                throw new JedisException(ex);
            }
        }
    };
    public static final Builder<Object> JSON_ARRAY_OR_DOUBLE_LIST = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof List) {
                return BuilderFactory.DOUBLE_LIST.build(data);
            }
            return JSON_ARRAY.build(data);
        }
    };
    public static final Builder<List<JSONArray>> JSON_ARRAY_LIST = new Builder<List<JSONArray>>(){

        @Override
        public List<JSONArray> build(Object data) {
            if (data == null) {
                return null;
            }
            List list = (List)data;
            return list.stream().map(o -> JSON_ARRAY.build(o)).collect(Collectors.toList());
        }
    };

    private JsonBuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

