"""Generated client library for serviceusage version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.serviceusage.v2 import serviceusage_v2_messages as messages


class ServiceusageV2(base_api.BaseApiClient):
  """Generated client library for service serviceusage version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://serviceusage.googleapis.com/'
  MTLS_BASE_URL = 'https://serviceusage.mtls.googleapis.com/'

  _PACKAGE = 'serviceusage'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only', 'https://www.googleapis.com/auth/service.management']
  _VERSION = 'v2'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ServiceusageV2'
  _URL_VERSION = 'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new serviceusage handle."""
    url = url or self.BASE_URL
    super(ServiceusageV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.consumerPolicies = self.ConsumerPoliciesService(self)
    self.groups_publicValues = self.GroupsPublicValuesService(self)
    self.groups_values = self.GroupsValuesService(self)
    self.groups = self.GroupsService(self)
    self.operations = self.OperationsService(self)
    self.publicServiceApis = self.PublicServiceApisService(self)
    self.publicValueInfo = self.PublicValueInfoService(self)
    self.services_dependencies = self.ServicesDependenciesService(self)
    self.services_groups_flattenedMembers = self.ServicesGroupsFlattenedMembersService(self)
    self.services_groups_members = self.ServicesGroupsMembersService(self)
    self.services_groups = self.ServicesGroupsService(self)
    self.services = self.ServicesService(self)
    self.v2 = self.V2Service(self)

  class ConsumerPoliciesService(base_api.BaseApiService):
    """Service class for the consumerPolicies resource."""

    _NAME = 'consumerPolicies'

    def __init__(self, client):
      super(ServiceusageV2.ConsumerPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddEnableRules(self, request, global_params=None):
      r"""Unimplemented. Do not use. Add enable rules to a resource's consumer policy.

      Args:
        request: (ServiceusageConsumerPoliciesAddEnableRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddEnableRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddEnableRules.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/consumerPolicies/{consumerPoliciesId}:addEnableRules',
        http_method='POST',
        method_id='serviceusage.consumerPolicies.addEnableRules',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}:addEnableRules',
        request_field='addEnableRulesRequest',
        request_type_name='ServiceusageConsumerPoliciesAddEnableRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Unimplemented. Do not use. Get consumer policy for a resource.

      Args:
        request: (ServiceusageConsumerPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConsumerPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/consumerPolicies/{consumerPoliciesId}',
        http_method='GET',
        method_id='serviceusage.consumerPolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='ServiceusageConsumerPoliciesGetRequest',
        response_type_name='ConsumerPolicy',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Unimplemented. Do not use. Update consumer policy for a resource.

      Args:
        request: (ServiceusageConsumerPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/consumerPolicies/{consumerPoliciesId}',
        http_method='PATCH',
        method_id='serviceusage.consumerPolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v2/{+name}',
        request_field='consumerPolicy',
        request_type_name='ServiceusageConsumerPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveEnableRules(self, request, global_params=None):
      r"""Unimplemented. Do not use. Remove enable rules from a resource's consumer policy.

      Args:
        request: (ServiceusageConsumerPoliciesRemoveEnableRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveEnableRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveEnableRules.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/consumerPolicies/{consumerPoliciesId}:removeEnableRules',
        http_method='POST',
        method_id='serviceusage.consumerPolicies.removeEnableRules',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}:removeEnableRules',
        request_field='removeEnableRulesRequest',
        request_type_name='ServiceusageConsumerPoliciesRemoveEnableRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class GroupsPublicValuesService(base_api.BaseApiService):
    """Service class for the groups_publicValues resource."""

    _NAME = 'groups_publicValues'

    def __init__(self, client):
      super(ServiceusageV2.GroupsPublicValuesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Unimplemented. Do not use. List public values in a service group. Currently, we only support two groups "googleServices" and "partnerServices" and return public services in these two groups.

      Args:
        request: (ServiceusageGroupsPublicValuesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPublicValuesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/groups/{groupsId}/publicValues',
        http_method='GET',
        method_id='serviceusage.groups.publicValues.list',
        ordered_params=['group'],
        path_params=['group'],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='v2/{+group}/publicValues',
        request_field='',
        request_type_name='ServiceusageGroupsPublicValuesListRequest',
        response_type_name='ListPublicValuesResponse',
        supports_download=False,
    )

  class GroupsValuesService(base_api.BaseApiService):
    """Service class for the groups_values resource."""

    _NAME = 'groups_values'

    def __init__(self, client):
      super(ServiceusageV2.GroupsValuesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Unimplemented. Do not use. List values in a service group. Currently, we only support two groups "partnerServices" and "googleServices" and return services in these two groups.

      Args:
        request: (ServiceusageGroupsValuesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListValuesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/groups/{groupsId}/values',
        http_method='GET',
        method_id='serviceusage.groups.values.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/values',
        request_field='',
        request_type_name='ServiceusageGroupsValuesListRequest',
        response_type_name='ListValuesResponse',
        supports_download=False,
    )

  class GroupsService(base_api.BaseApiService):
    """Service class for the groups resource."""

    _NAME = 'groups'

    def __init__(self, client):
      super(ServiceusageV2.GroupsService, self).__init__(client)
      self._upload_configs = {
          }

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = 'operations'

    def __init__(self, client):
      super(ServiceusageV2.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ServiceusageOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/operations/{operationsId}',
        http_method='GET',
        method_id='serviceusage.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='ServiceusageOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (ServiceusageOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='serviceusage.operations.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'name', 'pageSize', 'pageToken'],
        relative_path='v2/operations',
        request_field='',
        request_type_name='ServiceusageOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class PublicServiceApisService(base_api.BaseApiService):
    """Service class for the publicServiceApis resource."""

    _NAME = 'publicServiceApis'

    def __init__(self, client):
      super(ServiceusageV2.PublicServiceApisService, self).__init__(client)
      self._upload_configs = {
          }

    def Fetch(self, request, global_params=None):
      r"""Unimplemented. Do not use. Fetch the information of public service APIs.

      Args:
        request: (FetchPublicServiceApisRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchPublicServiceApisResponse) The response message.
      """
      config = self.GetMethodConfig('Fetch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Fetch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='serviceusage.publicServiceApis.fetch',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v2/publicServiceApis:fetch',
        request_field='<request>',
        request_type_name='FetchPublicServiceApisRequest',
        response_type_name='FetchPublicServiceApisResponse',
        supports_download=False,
    )

  class PublicValueInfoService(base_api.BaseApiService):
    """Service class for the publicValueInfo resource."""

    _NAME = 'publicValueInfo'

    def __init__(self, client):
      super(ServiceusageV2.PublicValueInfoService, self).__init__(client)
      self._upload_configs = {
          }

    def Fetch(self, request, global_params=None):
      r"""Unimplemented. Do not use. Fetch the information of public values.

      Args:
        request: (FetchPublicValueInfoRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchPublicValueInfoResponse) The response message.
      """
      config = self.GetMethodConfig('Fetch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Fetch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='serviceusage.publicValueInfo.fetch',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v2/publicValueInfo:fetch',
        request_field='<request>',
        request_type_name='FetchPublicValueInfoRequest',
        response_type_name='FetchPublicValueInfoResponse',
        supports_download=False,
    )

  class ServicesDependenciesService(base_api.BaseApiService):
    """Service class for the services_dependencies resource."""

    _NAME = 'services_dependencies'

    def __init__(self, client):
      super(ServiceusageV2.ServicesDependenciesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetClosure(self, request, global_params=None):
      r"""Unimplemented. Do not use. Get closure of a service dependency group. TODO (hanshao): remove this API once front-end migrates to ListFlattenedMembers.

      Args:
        request: (ServiceusageServicesDependenciesGetClosureRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DependencyClosure) The response message.
      """
      config = self.GetMethodConfig('GetClosure')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetClosure.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/services/{servicesId}/dependencies/{dependenciesId}/closure',
        http_method='GET',
        method_id='serviceusage.services.dependencies.getClosure',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='ServiceusageServicesDependenciesGetClosureRequest',
        response_type_name='DependencyClosure',
        supports_download=False,
    )

  class ServicesGroupsFlattenedMembersService(base_api.BaseApiService):
    """Service class for the services_groups_flattenedMembers resource."""

    _NAME = 'services_groups_flattenedMembers'

    def __init__(self, client):
      super(ServiceusageV2.ServicesGroupsFlattenedMembersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Unimplemented. Do not use. List flattened members for the given service group.

      Args:
        request: (ServiceusageServicesGroupsFlattenedMembersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFlattenedMembersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/services/{servicesId}/groups/{groupsId}/flattenedMembers',
        http_method='GET',
        method_id='serviceusage.services.groups.flattenedMembers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/flattenedMembers',
        request_field='',
        request_type_name='ServiceusageServicesGroupsFlattenedMembersListRequest',
        response_type_name='ListFlattenedMembersResponse',
        supports_download=False,
    )

  class ServicesGroupsMembersService(base_api.BaseApiService):
    """Service class for the services_groups_members resource."""

    _NAME = 'services_groups_members'

    def __init__(self, client):
      super(ServiceusageV2.ServicesGroupsMembersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Unimplemented. Do not use. List members for the given service group.

      Args:
        request: (ServiceusageServicesGroupsMembersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGroupMembersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/services/{servicesId}/groups/{groupsId}/members',
        http_method='GET',
        method_id='serviceusage.services.groups.members.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/members',
        request_field='',
        request_type_name='ServiceusageServicesGroupsMembersListRequest',
        response_type_name='ListGroupMembersResponse',
        supports_download=False,
    )

  class ServicesGroupsService(base_api.BaseApiService):
    """Service class for the services_groups resource."""

    _NAME = 'services_groups'

    def __init__(self, client):
      super(ServiceusageV2.ServicesGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Unimplemented. Do not use. List service groups owned by the given service.

      Args:
        request: (ServiceusageServicesGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/services/{servicesId}/groups',
        http_method='GET',
        method_id='serviceusage.services.groups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/groups',
        request_field='',
        request_type_name='ServiceusageServicesGroupsListRequest',
        response_type_name='ListServiceGroupsResponse',
        supports_download=False,
    )

  class ServicesService(base_api.BaseApiService):
    """Service class for the services resource."""

    _NAME = 'services'

    def __init__(self, client):
      super(ServiceusageV2.ServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetReverseClosure(self, request, global_params=None):
      r"""Unimplemented. Do not use. Get reverse dependency closure of a single service.

      Args:
        request: (ServiceusageServicesGetReverseClosureRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReverseDependencyClosure) The response message.
      """
      config = self.GetMethodConfig('GetReverseClosure')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetReverseClosure.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/services/{servicesId}/reverseClosure',
        http_method='GET',
        method_id='serviceusage.services.getReverseClosure',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='ServiceusageServicesGetReverseClosureRequest',
        response_type_name='ReverseDependencyClosure',
        supports_download=False,
    )

  class V2Service(base_api.BaseApiService):
    """Service class for the v2 resource."""

    _NAME = 'v2'

    def __init__(self, client):
      super(ServiceusageV2.V2Service, self).__init__(client)
      self._upload_configs = {
          }

    def CheckValue(self, request, global_params=None):
      r""" Unimplemented. Do not use. Tests a value against the result of merging consumer policies in the resource hierarchy. This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking.

      Args:
        request: (ServiceusageCheckValueRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckValueResponse) The response message.
      """
      config = self.GetMethodConfig('CheckValue')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckValue.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}:checkValue',
        http_method='POST',
        method_id='serviceusage.checkValue',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:checkValue',
        request_field='checkValueRequest',
        request_type_name='ServiceusageCheckValueRequest',
        response_type_name='CheckValueResponse',
        supports_download=False,
    )

    def FetchServiceApis(self, request, global_params=None):
      r"""Unimplemented. Do not use. Fetch the information of service APIs.

      Args:
        request: (ServiceusageFetchServiceApisRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchServiceApisResponse) The response message.
      """
      config = self.GetMethodConfig('FetchServiceApis')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchServiceApis.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}:fetchServiceApis',
        http_method='POST',
        method_id='serviceusage.fetchServiceApis',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:fetchServiceApis',
        request_field='fetchServiceApisRequest',
        request_type_name='ServiceusageFetchServiceApisRequest',
        response_type_name='FetchServiceApisResponse',
        supports_download=False,
    )

    def FetchValueInfo(self, request, global_params=None):
      r"""Unimplemented. Do not use. Fetch the information of values.

      Args:
        request: (ServiceusageFetchValueInfoRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FetchValueInfoResponse) The response message.
      """
      config = self.GetMethodConfig('FetchValueInfo')
      return self._RunMethod(
          config, request, global_params=global_params)

    FetchValueInfo.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}:fetchValueInfo',
        http_method='POST',
        method_id='serviceusage.fetchValueInfo',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:fetchValueInfo',
        request_field='fetchValueInfoRequest',
        request_type_name='ServiceusageFetchValueInfoRequest',
        response_type_name='FetchValueInfoResponse',
        supports_download=False,
    )

    def GetEffectivePolicy(self, request, global_params=None):
      r"""Unimplemented. Do not use. Get effective consumer policy for a resource, which contains enabled value information of consumer policies from the resource hierarchy.

      Args:
        request: (ServiceusageGetEffectivePolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EffectivePolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectivePolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectivePolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/effectivePolicy',
        http_method='GET',
        method_id='serviceusage.getEffectivePolicy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='ServiceusageGetEffectivePolicyRequest',
        response_type_name='EffectivePolicy',
        supports_download=False,
    )

    def UpdateConsumerPolicy(self, request, global_params=None):
      r"""Unimplemented. Do not use. Update consumer policy for a resource and returns LRO.

      Args:
        request: (ServiceusageUpdateConsumerPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateConsumerPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateConsumerPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/{v2Id}/{v2Id1}/consumerPolicy',
        http_method='PATCH',
        method_id='serviceusage.updateConsumerPolicy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v2/{+name}',
        request_field='consumerPolicy',
        request_type_name='ServiceusageUpdateConsumerPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )
