<?php
/**
 * @copyright Copyright (c) 2016, ownCloud GmbH
 *
 * @author Thomas Müller <thomas.mueller@tmit.eu>
 * @author Louis Chemineau <louis@chmn.me>
 * @author Côme Chilliet <come.chilliet@nextcloud.com>
 * @author Kate Döen <kate.doeen@nextcloud.com>
 *
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 */
namespace OCA\DAV;

use OCP\Capabilities\ICapability;
use OCP\IConfig;
use OCP\User\IAvailabilityCoordinator;

class Capabilities implements ICapability {
	private IConfig $config;
	private IAvailabilityCoordinator $coordinator;

	public function __construct(IConfig $config, IAvailabilityCoordinator $coordinator) {
		$this->config = $config;
		$this->coordinator = $coordinator;
	}

	/**
	 * @return array{dav: array{chunking: string, bulkupload?: string, absence-supported?: bool}}
	 */
	public function getCapabilities() {
		$capabilities = [
			'dav' => [
				'chunking' => '1.0',
			]
		];
		if ($this->config->getSystemValueBool('bulkupload.enabled', true)) {
			$capabilities['dav']['bulkupload'] = '1.0';
		}
		if ($this->coordinator->isEnabled()) {
			$capabilities['dav']['absence-supported'] = true;
		}
		return $capabilities;
	}
}
