/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.dup.util;

import com.almworks.dup.util.DecentFormatter$QuickDateFormatter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DecentFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final DecentFormatter$QuickDateFormatter myDateFormat = new DecentFormatter$QuickDateFormatter("yyyyMMdd", '-', '\u0000', '.', true);

    @Override
    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.myDateFormat.formatTo(logRecord.getMillis(), stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(logRecord.getLevel().getName());
        stringBuffer.append(' ');
        String string = this.formatMessage(logRecord);
        stringBuffer.append(string);
        stringBuffer.append(LINE_SEPARATOR);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            DecentFormatter.printStackTrace(throwable, stringBuffer, 0);
        }
        return stringBuffer.toString();
    }

    public static void printStackTrace(Throwable throwable, StringBuffer stringBuffer, int n) {
        try {
            stringBuffer.ensureCapacity(1000);
            stringBuffer.append(throwable.getClass().getName());
            String string = throwable.getLocalizedMessage();
            if (string != null) {
                stringBuffer.append(':').append(' ');
                stringBuffer.append(string);
            }
            stringBuffer.append(LINE_SEPARATOR);
            DecentFormatter.printStackTrace(throwable.getStackTrace(), stringBuffer);
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                stringBuffer.append("Caused by: ");
                DecentFormatter.printStackTrace(throwable2, stringBuffer, n + 1);
            }
            if (n == 0) {
                stringBuffer.append("==========================================================================================");
                stringBuffer.append(LINE_SEPARATOR);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printStackTrace(StackTraceElement[] stackTraceElementArray, StringBuffer stringBuffer) {
        if (stackTraceElementArray != null) {
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                stringBuffer.append("\tat ");
                stringBuffer.append(stackTraceElement.getClassName());
                stringBuffer.append('.');
                stringBuffer.append(stackTraceElement.getMethodName());
                if (stackTraceElement.isNativeMethod()) {
                    stringBuffer.append("(Native Method)");
                } else {
                    String string = stackTraceElement.getFileName();
                    int n = stackTraceElement.getLineNumber();
                    if (string != null && n >= 0) {
                        stringBuffer.append('(').append(string).append(':').append(n).append(')');
                    } else if (string != null) {
                        stringBuffer.append('(').append(string).append(')');
                    } else {
                        stringBuffer.append("Unknown Source");
                    }
                }
                stringBuffer.append(LINE_SEPARATOR);
            }
        }
    }

    public static void install(String string) {
        DecentFormatter decentFormatter = new DecentFormatter();
        Logger logger = Logger.getLogger(string);
        if (logger != null) {
            Handler[] handlerArray;
            for (Handler handler : handlerArray = logger.getHandlers()) {
                handler.setFormatter(decentFormatter);
            }
        }
    }
}

