/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ShutdownHookIntegration
implements Integration,
Closeable {
    @NotNull
    private final Runtime runtime;
    @Nullable
    private Thread thread;

    @TestOnly
    public ShutdownHookIntegration(@NotNull Runtime runtime) {
        this.runtime = Objects.requireNonNull(runtime, "Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options2) {
        Objects.requireNonNull(hub, "Hub is required");
        Objects.requireNonNull(options2, "SentryOptions is required");
        if (options2.isEnableShutdownHook()) {
            this.thread = new Thread(() -> hub.flush(options2.getFlushTimeoutMillis()));
            this.runtime.addShutdownHook(this.thread);
            options2.getLogger().log(SentryLevel.DEBUG, "ShutdownHookIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        } else {
            options2.getLogger().log(SentryLevel.INFO, "enableShutdownHook is disabled.", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        block3: {
            if (this.thread != null) {
                try {
                    this.runtime.removeShutdownHook(this.thread);
                }
                catch (IllegalStateException e) {
                    @Nullable String message = e.getMessage();
                    if (message != null && message.equals("Shutdown in progress")) break block3;
                    throw e;
                }
            }
        }
    }

    @VisibleForTesting
    @Nullable
    Thread getHook() {
        return this.thread;
    }
}

