/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cookie;

import jakarta.ws.rs.core.NewCookie;
import java.net.URI;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;

class CookieSecureResolver {
    private final KeycloakContext context;
    private final boolean sameSiteLegacyEnabled;

    CookieSecureResolver(KeycloakContext context, boolean sameSiteLegacyEnabled) {
        this.context = context;
        this.sameSiteLegacyEnabled = sameSiteLegacyEnabled;
    }

    boolean resolveSecure(NewCookie.SameSite sameSite) {
        if (!this.sameSiteLegacyEnabled) {
            return true;
        }
        if (NewCookie.SameSite.NONE.equals((Object)sameSite)) {
            return true;
        }
        URI requestUri = this.context.getUri().getRequestUri();
        RealmModel realm = this.context.getRealm();
        return realm != null && realm.getSslRequired().isRequired(requestUri.getHost());
    }
}

