/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.logstream;

import io.quarkus.arc.Arc;
import io.quarkus.devui.runtime.logstream.JsonFormatter;
import io.quarkus.devui.runtime.logstream.LogStreamBroadcaster;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class MutinyLogHandler
extends ExtHandler {
    private LogStreamBroadcaster logStreamBroadcaster;

    public MutinyLogHandler() {
        this.setFormatter((Formatter)((Object)new JsonFormatter()));
    }

    public final void doPublish(ExtLogRecord record) {
        LogStreamBroadcaster broadcaster;
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        if (this.isLoggable((LogRecord)record) && (broadcaster = this.getBroadcaster()) != null) {
            JsonObject message = ((JsonFormatter)((Object)this.getFormatter())).toJsonObject(record);
            broadcaster.onNext(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogStreamBroadcaster getBroadcaster() {
        MutinyLogHandler mutinyLogHandler = this;
        synchronized (mutinyLogHandler) {
            if (this.logStreamBroadcaster == null && Arc.container() != null) {
                this.logStreamBroadcaster = (LogStreamBroadcaster)Arc.container().instance(LogStreamBroadcaster.class, new Annotation[0]).get();
            }
        }
        return this.logStreamBroadcaster;
    }
}

