/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.quarkus.agroal.runtime.DataSourceJdbcTracingRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public interface DataSourceJdbcRuntimeConfig {
    public Optional<String> url();

    public OptionalInt initialSize();

    @WithDefault(value="0")
    public int minSize();

    @WithDefault(value="20")
    public int maxSize();

    @WithDefault(value="2M")
    public Duration backgroundValidationInterval();

    public Optional<Duration> foregroundValidationInterval();

    @WithDefault(value="5S")
    public Optional<Duration> acquisitionTimeout();

    public Optional<Duration> leakDetectionInterval();

    @WithDefault(value="5M")
    public Duration idleRemovalInterval();

    public Optional<Duration> maxLifetime();

    public Optional<AgroalConnectionFactoryConfiguration.TransactionIsolation> transactionIsolationLevel();

    @WithDefault(value="false")
    public boolean extendedLeakReport();

    @WithDefault(value="false")
    public boolean flushOnClose();

    @WithDefault(value="true")
    public boolean detectStatementLeaks();

    public Optional<String> newConnectionSql();

    public Optional<String> validationQuerySql();

    @WithDefault(value="true")
    public boolean poolingEnabled();

    public Optional<AgroalConnectionPoolConfiguration.TransactionRequirement> transactionRequirement();

    public Map<String, String> additionalJdbcProperties();

    public DataSourceJdbcTracingRuntimeConfig tracing();

    @WithName(value="telemetry.enabled")
    public Optional<Boolean> telemetry();
}

