/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class WebSocketModelChange
extends Change {
    private WebSocketModel wsModel;
    private final Map<WebSocketModel, Boolean> wsModels = new LinkedHashMap<WebSocketModel, Boolean>();
    private boolean disabled;
    private final List<OsgiContextModel> newModels = new LinkedList<OsgiContextModel>();
    private String newModelsInfo;

    public WebSocketModelChange(OpCode op, WebSocketModel wsModel, OsgiContextModel ... newModels) {
        this(op, wsModel, false, newModels);
    }

    public WebSocketModelChange(OpCode op, Map<WebSocketModel, Boolean> wsModels) {
        super(op);
        this.wsModels.putAll(wsModels);
    }

    public WebSocketModelChange(OpCode op, WebSocketModel wsModel, boolean disabled, OsgiContextModel ... newModels) {
        super(op);
        this.wsModel = wsModel;
        this.wsModels.put(wsModel, !disabled);
        this.disabled = disabled;
        this.newModels.addAll(Arrays.asList(newModels));
        if (this.newModels.size() > 0) {
            this.newModelsInfo = this.newModels.stream().map(ocm -> String.format("{%s,%s,%s,%s}", ocm.isWhiteboard() ? "WB" : "HS", ocm.getId(), ocm.getName(), ocm.getContextPath())).collect(Collectors.joining(", ", "[", "]"));
        }
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            HashMap<WebSocketModel, Boolean> models = new HashMap<WebSocketModel, Boolean>();
            models.put(this.wsModel, true);
            operations.add(new WebSocketModelChange(OpCode.DELETE, models));
        }
    }

    public WebSocketModel getWebSocketModel() {
        return this.wsModel;
    }

    public Map<WebSocketModel, Boolean> getWebSocketModels() {
        return this.wsModels;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<OsgiContextModel> getNewModels() {
        return this.newModels;
    }

    public String getNewModelsInfo() {
        return this.newModelsInfo;
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitWebSocketModelChange(this);
    }

    @Override
    public List<OsgiContextModel> getContextModels() {
        return this.newModels.size() > 0 ? this.newModels : this.wsModel.getContextModels();
    }

    public String toString() {
        WebSocketModel model = this.wsModel;
        if (model == null && this.wsModels.size() == 1) {
            model = this.wsModels.keySet().iterator().next();
        }
        if (model != null) {
            return (Object)((Object)this.getKind()) + ": " + model + (this.disabled ? " (disabled)" : " (enabled)") + (this.newModelsInfo != null ? " (new contexts: " + this.newModelsInfo : "");
        }
        return (Object)((Object)this.getKind()) + ": " + this.wsModels.size() + " web socket models";
    }
}

