/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BasePipelineFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.NetworkUtil;
import org.traccar.session.ConnectionManager;

@Singleton
@ChannelHandler.Sharable
public class MainEventHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainEventHandler.class);
    private final ConnectionManager connectionManager;
    private final Set<String> connectionlessProtocols = new HashSet<String>();

    @Inject
    public MainEventHandler(Config config, ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        String connectionlessProtocolList = config.getString(Keys.STATUS_IGNORE_OFFLINE);
        if (connectionlessProtocolList != null) {
            this.connectionlessProtocols.addAll(Arrays.asList(connectionlessProtocolList.split("[, ]")));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (!(ctx.channel() instanceof DatagramChannel)) {
            LOGGER.info("[{}] connected", (Object)NetworkUtil.session(ctx.channel()));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.info("[{}] disconnected", (Object)NetworkUtil.session(ctx.channel()));
        this.closeChannel(ctx.channel());
        boolean supportsOffline = BasePipelineFactory.getHandler(ctx.pipeline(), HttpRequestDecoder.class) == null && !this.connectionlessProtocols.contains(((BaseProtocolDecoder)ctx.pipeline().get(BaseProtocolDecoder.class)).getProtocolName());
        this.connectionManager.deviceDisconnected(ctx.channel(), supportsOffline);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        while (cause.getCause() != null && cause.getCause() != cause) {
            cause = cause.getCause();
        }
        LOGGER.info("[{}] error", (Object)NetworkUtil.session(ctx.channel()), (Object)cause);
        this.closeChannel(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            LOGGER.info("[{}] timed out", (Object)NetworkUtil.session(ctx.channel()));
            this.closeChannel(ctx.channel());
        }
    }

    private void closeChannel(Channel channel) {
        if (!(channel instanceof DatagramChannel)) {
            channel.close();
        }
    }
}

