/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpResponseException;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.ErrorCode;
import com.google.firebase.FirebaseException;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.HttpErrorHandler;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractHttpErrorHandler<T extends FirebaseException>
implements HttpErrorHandler<T> {
    private static final Map<Integer, ErrorCode> HTTP_ERROR_CODES = ImmutableMap.builder().put((Object)400, (Object)ErrorCode.INVALID_ARGUMENT).put((Object)401, (Object)ErrorCode.UNAUTHENTICATED).put((Object)403, (Object)ErrorCode.PERMISSION_DENIED).put((Object)404, (Object)ErrorCode.NOT_FOUND).put((Object)409, (Object)ErrorCode.CONFLICT).put((Object)429, (Object)ErrorCode.RESOURCE_EXHAUSTED).put((Object)500, (Object)ErrorCode.INTERNAL).put((Object)503, (Object)ErrorCode.UNAVAILABLE).build();

    @Override
    public final T handleHttpResponseException(HttpResponseException e, IncomingHttpResponse response) {
        FirebaseException base = this.httpResponseErrorToBaseException(e, response);
        return this.createException(base);
    }

    @Override
    public final T handleIOException(IOException e) {
        FirebaseException base = this.ioErrorToBaseException(e);
        return this.createException(base);
    }

    @Override
    public final T handleParseException(IOException e, IncomingHttpResponse response) {
        FirebaseException base = this.parseErrorToBaseException(e, response);
        return this.createException(base);
    }

    protected FirebaseException httpResponseErrorToBaseException(HttpResponseException e, IncomingHttpResponse response) {
        ErrorCode code = HTTP_ERROR_CODES.get(e.getStatusCode());
        if (code == null) {
            code = ErrorCode.UNKNOWN;
        }
        String message = String.format("Unexpected HTTP response with status: %d\n%s", e.getStatusCode(), e.getContent());
        return new FirebaseException(code, message, (Throwable)e, response);
    }

    protected FirebaseException ioErrorToBaseException(IOException e) {
        ErrorCode code = ErrorCode.UNKNOWN;
        String message = "Unknown error while making a remote service call";
        if (this.isInstance(e, SocketTimeoutException.class)) {
            code = ErrorCode.DEADLINE_EXCEEDED;
            message = "Timed out while making an API call";
        }
        if (this.isInstance(e, UnknownHostException.class) || this.isInstance(e, NoRouteToHostException.class)) {
            code = ErrorCode.UNAVAILABLE;
            message = "Failed to establish a connection";
        }
        return new FirebaseException(code, message + ": " + e.getMessage(), e);
    }

    protected FirebaseException parseErrorToBaseException(IOException e, IncomingHttpResponse response) {
        return new FirebaseException(ErrorCode.UNKNOWN, "Error while parsing HTTP response: " + e.getMessage(), e, response);
    }

    protected abstract T createException(FirebaseException var1);

    private <U> boolean isInstance(IOException t, Class<U> type) {
        HashSet<IOException> chain = new HashSet<IOException>();
        for (Throwable current = t; current != null && chain.add((IOException)current); current = current.getCause()) {
            if (!type.isInstance(current)) continue;
            return true;
        }
        return false;
    }
}

