/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.connection.PersistentConnectionImpl;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.JvmAuthTokenProvider;
import com.google.firebase.database.core.Platform;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.ThreadPoolEventTarget;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.utilities.DefaultRunLoop;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JvmPlatform
implements Platform {
    private static final String PROCESS_PLATFORM = System.getProperty("java.version", "Unknown");
    private final FirebaseApp firebaseApp;

    JvmPlatform(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    @Override
    public EventTarget newEventTarget(Context ctx) {
        ThreadFactory threadFactory = ImplFirebaseTrampolines.getThreadFactory(this.firebaseApp);
        return new ThreadPoolEventTarget(threadFactory);
    }

    @Override
    public RunLoop newRunLoop(Context context) {
        final Logger logger = LoggerFactory.getLogger(RunLoop.class);
        ThreadFactory threadFactory = ImplFirebaseTrampolines.getThreadFactory(this.firebaseApp);
        return new DefaultRunLoop(threadFactory){

            @Override
            public void handleException(Throwable e) {
                logger.error(DefaultRunLoop.messageForException(e), e);
            }
        };
    }

    @Override
    public PersistentConnection newPersistentConnection(Context context, ConnectionContext connectionContext, HostInfo info, PersistentConnection.Delegate delegate) {
        return new PersistentConnectionImpl(context.getConnectionContext(), info, delegate);
    }

    @Override
    public AuthTokenProvider newAuthTokenProvider(ScheduledExecutorService executorService) {
        return new JvmAuthTokenProvider(this.firebaseApp, executorService);
    }

    @Override
    public String getUserAgent(Context ctx) {
        return PROCESS_PLATFORM + "/" + "AdminJava";
    }

    @Override
    public String getPlatformVersion() {
        return "jvm-" + FirebaseDatabase.getSdkVersion();
    }

    @Override
    public PersistenceManager createPersistenceManager(Context ctx, String namespace) {
        return null;
    }
}

