/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.re2j.Pattern;
import io.grpc.xds.internal.AutoValue_Matchers_CidrMatcher;
import io.grpc.xds.internal.AutoValue_Matchers_FractionMatcher;
import io.grpc.xds.internal.AutoValue_Matchers_HeaderMatcher;
import io.grpc.xds.internal.AutoValue_Matchers_HeaderMatcher_Range;
import io.grpc.xds.internal.AutoValue_Matchers_StringMatcher;
import java.math.BigInteger;
import java.net.InetAddress;
import javax.annotation.Nullable;

public final class Matchers {
    private Matchers() {
    }

    @AutoValue
    public static abstract class CidrMatcher {
        abstract InetAddress addressPrefix();

        abstract int prefixLen();

        public boolean matches(InetAddress address) {
            if (address == null) {
                return false;
            }
            byte[] cidr = this.addressPrefix().getAddress();
            byte[] addr = address.getAddress();
            if (addr.length != cidr.length) {
                return false;
            }
            BigInteger cidrInt = new BigInteger(cidr);
            BigInteger addrInt = new BigInteger(addr);
            int shiftAmount = 8 * cidr.length - this.prefixLen();
            cidrInt = cidrInt.shiftRight(shiftAmount);
            addrInt = addrInt.shiftRight(shiftAmount);
            return cidrInt.equals(addrInt);
        }

        public static CidrMatcher create(InetAddress addressPrefix, int prefixLen) {
            return new AutoValue_Matchers_CidrMatcher(addressPrefix, prefixLen);
        }
    }

    @AutoValue
    public static abstract class StringMatcher {
        @Nullable
        abstract String exact();

        @Nullable
        abstract String prefix();

        @Nullable
        abstract String suffix();

        @Nullable
        abstract Pattern regEx();

        @Nullable
        abstract String contains();

        abstract boolean ignoreCase();

        public static StringMatcher forExact(String exact, boolean ignoreCase) {
            Preconditions.checkNotNull((Object)exact, (Object)"exact");
            return StringMatcher.create(exact, null, null, null, null, ignoreCase);
        }

        public static StringMatcher forPrefix(String prefix, boolean ignoreCase) {
            Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
            return StringMatcher.create(null, prefix, null, null, null, ignoreCase);
        }

        public static StringMatcher forSuffix(String suffix, boolean ignoreCase) {
            Preconditions.checkNotNull((Object)suffix, (Object)"suffix");
            return StringMatcher.create(null, null, suffix, null, null, ignoreCase);
        }

        public static StringMatcher forSafeRegEx(Pattern regEx) {
            Preconditions.checkNotNull((Object)regEx, (Object)"regEx");
            return StringMatcher.create(null, null, null, regEx, null, false);
        }

        public static StringMatcher forContains(String contains) {
            Preconditions.checkNotNull((Object)contains, (Object)"contains");
            return StringMatcher.create(null, null, null, null, contains, false);
        }

        public boolean matches(String args) {
            if (args == null) {
                return false;
            }
            if (this.exact() != null) {
                return this.ignoreCase() ? this.exact().equalsIgnoreCase(args) : this.exact().equals(args);
            }
            if (this.prefix() != null) {
                return this.ignoreCase() ? args.toLowerCase().startsWith(this.prefix().toLowerCase()) : args.startsWith(this.prefix());
            }
            if (this.suffix() != null) {
                return this.ignoreCase() ? args.toLowerCase().endsWith(this.suffix().toLowerCase()) : args.endsWith(this.suffix());
            }
            if (this.contains() != null) {
                return args.contains(this.contains());
            }
            return this.regEx().matches(args);
        }

        private static StringMatcher create(@Nullable String exact, @Nullable String prefix, @Nullable String suffix, @Nullable Pattern regEx, @Nullable String contains, boolean ignoreCase) {
            return new AutoValue_Matchers_StringMatcher(exact, prefix, suffix, regEx, contains, ignoreCase);
        }
    }

    @AutoValue
    public static abstract class FractionMatcher {
        public abstract int numerator();

        public abstract int denominator();

        public static FractionMatcher create(int numerator, int denominator) {
            return new AutoValue_Matchers_FractionMatcher(numerator, denominator);
        }
    }

    @AutoValue
    public static abstract class HeaderMatcher {
        public abstract String name();

        @Nullable
        public abstract String exactValue();

        @Nullable
        public abstract Pattern safeRegEx();

        @Nullable
        public abstract Range range();

        @Nullable
        public abstract Boolean present();

        @Nullable
        public abstract String prefix();

        @Nullable
        public abstract String suffix();

        @Nullable
        public abstract String contains();

        @Nullable
        public abstract StringMatcher stringMatcher();

        public abstract boolean inverted();

        public static HeaderMatcher forExactValue(String name, String exactValue, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)exactValue, (Object)"exactValue");
            return HeaderMatcher.create(name, exactValue, null, null, null, null, null, null, null, inverted);
        }

        public static HeaderMatcher forSafeRegEx(String name, Pattern safeRegEx, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)safeRegEx, (Object)"safeRegEx");
            return HeaderMatcher.create(name, null, safeRegEx, null, null, null, null, null, null, inverted);
        }

        public static HeaderMatcher forRange(String name, Range range, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)range, (Object)"range");
            return HeaderMatcher.create(name, null, null, range, null, null, null, null, null, inverted);
        }

        public static HeaderMatcher forPresent(String name, boolean present, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return HeaderMatcher.create(name, null, null, null, present, null, null, null, null, inverted);
        }

        public static HeaderMatcher forPrefix(String name, String prefix, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
            return HeaderMatcher.create(name, null, null, null, null, prefix, null, null, null, inverted);
        }

        public static HeaderMatcher forSuffix(String name, String suffix, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)suffix, (Object)"suffix");
            return HeaderMatcher.create(name, null, null, null, null, null, suffix, null, null, inverted);
        }

        public static HeaderMatcher forContains(String name, String contains, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)contains, (Object)"contains");
            return HeaderMatcher.create(name, null, null, null, null, null, null, contains, null, inverted);
        }

        public static HeaderMatcher forString(String name, StringMatcher stringMatcher, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)stringMatcher, (Object)"stringMatcher");
            return HeaderMatcher.create(name, null, null, null, null, null, null, null, stringMatcher, inverted);
        }

        private static HeaderMatcher create(String name, @Nullable String exactValue, @Nullable Pattern safeRegEx, @Nullable Range range, @Nullable Boolean present, @Nullable String prefix, @Nullable String suffix, @Nullable String contains, @Nullable StringMatcher stringMatcher, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return new AutoValue_Matchers_HeaderMatcher(name, exactValue, safeRegEx, range, present, prefix, suffix, contains, stringMatcher, inverted);
        }

        public boolean matches(@Nullable String value) {
            boolean baseMatch;
            if (value == null) {
                return this.present() != null && this.present().booleanValue() == this.inverted();
            }
            if (this.exactValue() != null) {
                baseMatch = this.exactValue().equals(value);
            } else if (this.safeRegEx() != null) {
                baseMatch = this.safeRegEx().matches(value);
            } else if (this.range() != null) {
                try {
                    long numValue = Long.parseLong(value);
                    baseMatch = numValue >= this.range().start() && numValue <= this.range().end();
                }
                catch (NumberFormatException ignored) {
                    baseMatch = false;
                }
            } else {
                baseMatch = this.prefix() != null ? value.startsWith(this.prefix()) : (this.present() != null ? this.present() : (this.suffix() != null ? value.endsWith(this.suffix()) : (this.contains() != null ? value.contains(this.contains()) : this.stringMatcher().matches(value))));
            }
            return baseMatch != this.inverted();
        }

        @AutoValue
        public static abstract class Range {
            public abstract long start();

            public abstract long end();

            public static Range create(long start, long end) {
                return new AutoValue_Matchers_HeaderMatcher_Range(start, end);
            }
        }
    }
}

