/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.GzipOutputStream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ChunkedBytesStream;

public class GzipCompression
implements Compression {
    public static final int MIN_LEVEL = 1;
    public static final int MAX_LEVEL = 9;
    public static final int DEFAULT_LEVEL = -1;
    private final int level;

    private GzipCompression(int level) {
        this.level = level;
    }

    @Override
    public CompressionType type() {
        return CompressionType.GZIP;
    }

    @Override
    public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
        try {
            return new BufferedOutputStream(new GzipOutputStream((OutputStream)buffer, 8192, this.level), 16384);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
        try {
            return new ChunkedBytesStream(new GZIPInputStream((InputStream)new ByteBufferInputStream(buffer), 8192), decompressionBufferSupplier, this.decompressionOutputSize(), false);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public int decompressionOutputSize() {
        return 16384;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GzipCompression that = (GzipCompression)o;
        return this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(this.level);
    }

    public static class LevelValidator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object o) {
            if (o == null) {
                throw new ConfigException(name, null, "Value must be non-null");
            }
            int level = ((Number)o).intValue();
            if (level > 9 || level < 1 && level != -1) {
                throw new ConfigException(name, o, "Value must be between 1 and 9 or equal to -1");
            }
        }

        public String toString() {
            return "[1,...,9] or -1";
        }
    }

    public static class Builder
    implements Compression.Builder<GzipCompression> {
        private int level = -1;

        public Builder level(int level) {
            if ((level < 1 || 9 < level) && level != -1) {
                throw new IllegalArgumentException("gzip doesn't support given compression level: " + level);
            }
            this.level = level;
            return this;
        }

        @Override
        public GzipCompression build() {
            return new GzipCompression(this.level);
        }
    }
}

