/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import jakarta.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.protocol.XexunFrameDecoder;
import org.traccar.protocol.XexunProtocolDecoder;
import org.traccar.protocol.XexunProtocolEncoder;

public class XexunProtocol
extends BaseProtocol {
    @Inject
    public XexunProtocol(Config config) {
        this.setSupportedDataCommands("engineStop", "engineResume");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                boolean full = config.getBoolean(Keys.PROTOCOL_EXTENDED.withPrefix(XexunProtocol.this.getName()));
                if (full) {
                    pipeline.addLast((ChannelHandler)new LineBasedFrameDecoder(1024));
                } else {
                    pipeline.addLast((ChannelHandler)new XexunFrameDecoder());
                }
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new StringDecoder());
                pipeline.addLast((ChannelHandler)new XexunProtocolEncoder(XexunProtocol.this));
                pipeline.addLast((ChannelHandler)new XexunProtocolDecoder(XexunProtocol.this, full));
            }
        });
    }
}

