## MAPINFO

This page tracks support for the MAPINFO lump, as seen in ZDoom. This is all a work in progress - the status of any feature (including whether or not it is planned) is subject to change.

### Current Status

You can enable MAPINFO parsing via the `-mapinfo` command line option. There is *very limited* support currently and crashing is possible.

### Legend

| Symbol             | Meaning                        |
| ------------------ | ------------------------------ |
| :heavy_check_mark: | Feature is supported           |
| :warning:          | Feature is partially supported |
| :telescope:        | Feature is planned             |
| :grey_question:    | Feature is under investigation |
| :x:                | Feature is not planned         |

### Major Features (old format)

| Name         | Status          |
| ------------ | --------------- |
| episode      | :grey_question: |
| map          | :warning:       |
| clusterdef   | :grey_question: |
| skill        | :grey_question: |

### Episode

Not looked at yet.

### Map

| Key                                | Status             |
| ---------------------------------- | ------------------ |
| map                                | :warning:          |
| lookup                             | :grey_question:    |
| defaultmap                         | :grey_question:    |
| adddefaultmap                      | :grey_question:    |
| gamedefaults                       | :grey_question:    |
| levelnum                           | :grey_question:    |
| warptrans                          | :heavy_check_mark: |
| next                               | :warning:          |
| secretnext                         | :telescope:        |
| cluster                            | :warning:          |
| doublesky                          | :warning:          |
| sky1                               | :warning:          |
| sky2                               | :warning:          |
| fade                               | :grey_question:    |
| outsidefog                         | :grey_question:    |
| titlepatch                         | :grey_question:    |
| par                                | :grey_question:    |
| music                              | :grey_question:    |
| cdtrack                            | :grey_question:    |
| cdid                               | :grey_question:    |
| nointermission                     | :grey_question:    |
| exitpic                            | :grey_question:    |
| enterpic                           | :grey_question:    |
| intermusic                         | :grey_question:    |
| bordertexture                      | :grey_question:    |
| nosoundclipping                    | :grey_question:    |
| allowmonstertelefrags              | :grey_question:    |
| specialaction                      | :grey_question:    |
| map07special                       | :grey_question:    |
| baronspecial                       | :grey_question:    |
| cyberdemonspecial                  | :grey_question:    |
| spidermastermindspecial            | :grey_question:    |
| specialaction_exitlevel            | :grey_question:    |
| specialaction_opendoor             | :grey_question:    |
| specialaction_lowerfloor           | :grey_question:    |
| specialaction_killmonsters         | :grey_question:    |
| lightning                          | :warning:          |
| fadetable                          | :warning:          |
| evenlighting                       | :grey_question:    |
| smoothlighting                     | :grey_question:    |
| vertwallshade                      | :grey_question:    |
| horizwallshade                     | :grey_question:    |
| clipmidtextures                    | :grey_question:    |
| forcenoskystretch                  | :grey_question:    |
| skystretch                         | :grey_question:    |
| noautosequences                    | :grey_question:    |
| autosquences                       | :grey_question:    |
| strictmonsteractivation            | :grey_question:    |
| laxmonsteractivation               | :grey_question:    |
| missileshootersactivateimpactlines | :grey_question:    |
| missilesactivateimpactlines        | :grey_question:    |
| fallingdamage                      | :grey_question:    |
| monsterfallingdamage               | :grey_question:    |
| oldfallingdamage                   | :grey_question:    |
| strifefallingdamage                | :grey_question:    |
| forcefallingdamage                 | :grey_question:    |
| nofallingdamage                    | :grey_question:    |
| teamdamage                         | :grey_question:    |
| gravity                            | :grey_question:    |
| aircontrol                         | :grey_question:    |
| airsupply                          | :grey_question:    |
| filterstarts                       | :grey_question:    |
| allowrespawn                       | :grey_question:    |
| teamplayon                         | :grey_question:    |
| teamplayoff                        | :grey_question:    |
| noinventorybar                     | :grey_question:    |
| keepfullinventory                  | :grey_question:    |
| infiniteflightpowerup              | :grey_question:    |
| nojump                             | :grey_question:    |
| allowjump                          | :grey_question:    |
| nocrouch                           | :grey_question:    |
| allowcrouch                        | :grey_question:    |
| noinfighting                       | :grey_question:    |
| normalinfighting                   | :grey_question:    |
| totalinfighting                    | :grey_question:    |
| f1                                 | :grey_question:    |
| checkswitchrange                   | :grey_question:    |
| nocheckswitchrange                 | :grey_question:    |
| translator                         | :grey_question:    |
| unfreezesingleplayerconversations  | :grey_question:    |
| compat_*                           | :grey_question:    |

#### Notes
- Various keys only work in Hexen.

### Clusterdef

Not looked at yet.

### Skill

Not looked at yet.
